/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.api.resources;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.apache.pinot.common.utils.SimpleHttpErrorInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class WebApplicationExceptionMapper
implements ExceptionMapper<Throwable> {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebApplicationExceptionMapper.class);

    public Response toResponse(Throwable t) {
        int status = 500;
        if (!(t instanceof WebApplicationException)) {
            LOGGER.error("Server error: ", t);
        } else {
            status = ((WebApplicationException)t).getResponse().getStatus();
        }
        SimpleHttpErrorInfo errorInfo = new SimpleHttpErrorInfo(status, t.getMessage());
        return Response.status((int)status).entity((Object)errorInfo).type("application/json").build();
    }
}

