/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.api.resources;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.Encoded;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.helix.ZNRecord;
import org.apache.helix.store.zk.ZkHelixPropertyStore;
import org.apache.pinot.common.exception.InvalidConfigException;
import org.apache.pinot.common.metadata.ZKMetadataProvider;
import org.apache.pinot.common.metadata.segment.SegmentZKMetadata;
import org.apache.pinot.common.utils.SegmentName;
import org.apache.pinot.common.utils.URIUtils;
import org.apache.pinot.controller.ControllerConf;
import org.apache.pinot.controller.api.access.AccessType;
import org.apache.pinot.controller.api.access.Authenticate;
import org.apache.pinot.controller.api.exception.ControllerApplicationException;
import org.apache.pinot.controller.api.resources.Constants;
import org.apache.pinot.controller.api.resources.ResourceUtils;
import org.apache.pinot.controller.api.resources.SuccessResponse;
import org.apache.pinot.controller.helix.core.PinotHelixResourceManager;
import org.apache.pinot.controller.helix.core.PinotResourceManagerResponse;
import org.apache.pinot.controller.util.ConsumingSegmentInfoReader;
import org.apache.pinot.controller.util.TableMetadataReader;
import org.apache.pinot.spi.config.table.TableType;
import org.apache.pinot.spi.utils.JsonUtils;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(tags={"Segment"})
@Path(value="/")
public class PinotSegmentRestletResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(PinotSegmentRestletResource.class);
    @Inject
    ControllerConf _controllerConf;
    @Inject
    PinotHelixResourceManager _pinotHelixResourceManager;
    @Inject
    Executor _executor;
    @Inject
    HttpConnectionManager _connectionManager;

    @GET
    @Produces(value={"application/json"})
    @Path(value="/segments/{tableName}")
    @ApiOperation(value="List all segments. An optional 'excludeReplacedSegments' parameter is used to get the list of segments which has not yet been replaced (determined by segment lineage entries) and can be queried from the table. The value is false by default.", notes="List all segments")
    public List<Map<TableType, List<String>>> getSegments(@ApiParam(value="Name of the table", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="OFFLINE|REALTIME") @QueryParam(value="type") String tableTypeStr, @ApiParam(value="Whether to exclude replaced segments in the response, which have been replaced specified in the segment lineage entries and cannot be queried from the table") @QueryParam(value="excludeReplacedSegments") String excludeReplacedSegments) {
        List<String> tableNamesWithType = ResourceUtils.getExistingTableNamesWithType(this._pinotHelixResourceManager, tableName, Constants.validateTableType(tableTypeStr), LOGGER);
        boolean shouldExcludeReplacedSegments = Boolean.parseBoolean(excludeReplacedSegments);
        ArrayList<Map<TableType, List<String>>> resultList = new ArrayList<Map<TableType, List<String>>>(tableNamesWithType.size());
        for (String tableNameWithType : tableNamesWithType) {
            TableType tableType = TableNameBuilder.getTableTypeFromTableName((String)tableNameWithType);
            List<String> segments = this._pinotHelixResourceManager.getSegmentsFor(tableNameWithType, shouldExcludeReplacedSegments);
            resultList.add(Collections.singletonMap(tableType, segments));
        }
        return resultList;
    }

    @GET
    @Path(value="segments/{tableName}/servers")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get a map from server to segments hosted by the server", notes="Get a map from server to segments hosted by the server")
    public List<Map<String, Object>> getServerToSegmentsMap(@ApiParam(value="Name of the table", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="OFFLINE|REALTIME") @QueryParam(value="type") String tableTypeStr) {
        List<String> tableNamesWithType = ResourceUtils.getExistingTableNamesWithType(this._pinotHelixResourceManager, tableName, Constants.validateTableType(tableTypeStr), LOGGER);
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(tableNamesWithType.size());
        for (String tableNameWithType : tableNamesWithType) {
            LinkedHashMap<String, Object> resultForTable = new LinkedHashMap<String, Object>();
            resultForTable.put("tableName", tableNameWithType);
            resultForTable.put("serverToSegmentsMap", this._pinotHelixResourceManager.getServerToSegmentsMap(tableNameWithType));
            resultList.add(resultForTable);
        }
        return resultList;
    }

    @Deprecated
    @GET
    @Path(value="tables/{tableName}/segments")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get a map from server to segments hosted by the server (deprecated, use 'GET /segments/{tableName}/servers' instead)", notes="Get a map from server to segments hosted by the server (deprecated, use 'GET /segments/{tableName}/servers' instead)")
    public List<Map<String, String>> getServerToSegmentsMapDeprecated1(@ApiParam(value="Name of the table", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="MUST be null") @QueryParam(value="state") String stateStr, @ApiParam(value="OFFLINE|REALTIME") @QueryParam(value="type") String tableTypeStr) throws JsonProcessingException {
        if (stateStr != null) {
            throw new WebApplicationException("Cannot toggle segment state", Response.Status.FORBIDDEN);
        }
        List<String> tableNamesWithType = ResourceUtils.getExistingTableNamesWithType(this._pinotHelixResourceManager, tableName, Constants.validateTableType(tableTypeStr), LOGGER);
        ArrayList<Map<String, String>> resultList = new ArrayList<Map<String, String>>(tableNamesWithType.size());
        for (String tableNameWithType : tableNamesWithType) {
            LinkedHashMap<String, String> resultForTable = new LinkedHashMap<String, String>();
            resultForTable.put("tableName", tableNameWithType);
            resultForTable.put("segments", JsonUtils.objectToString(this._pinotHelixResourceManager.getServerToSegmentsMap(tableNameWithType)));
            resultList.add(resultForTable);
        }
        return resultList;
    }

    @Deprecated
    @GET
    @Path(value="tables/{tableName}/segments/metadata")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get a map from server to segments hosted by the server (deprecated, use 'GET /segments/{tableName}/servers' instead)", notes="Get a map from server to segments hosted by the server (deprecated, use 'GET /segments/{tableName}/servers' instead)")
    public List<Map<String, String>> getServerToSegmentsMapDeprecated2(@ApiParam(value="Name of the table", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="MUST be null") @QueryParam(value="state") String stateStr, @ApiParam(value="OFFLINE|REALTIME") @QueryParam(value="type") String tableTypeStr) throws JsonProcessingException {
        return this.getServerToSegmentsMapDeprecated1(tableName, stateStr, tableTypeStr);
    }

    @GET
    @Path(value="segments/{tableName}/crc")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get a map from segment to CRC of the segment (only apply to OFFLINE table)", notes="Get a map from segment to CRC of the segment (only apply to OFFLINE table)")
    public Map<String, String> getSegmentToCrcMap(@ApiParam(value="Name of the table", required=true) @PathParam(value="tableName") String tableName) {
        String offlineTableName = ResourceUtils.getExistingTableNamesWithType(this._pinotHelixResourceManager, tableName, TableType.OFFLINE, LOGGER).get(0);
        return this._pinotHelixResourceManager.getSegmentsCrcForTable(offlineTableName);
    }

    @Deprecated
    @GET
    @Path(value="tables/{tableName}/segments/crc")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get a map from segment to CRC of the segment (deprecated, use 'GET /segments/{tableName}/crc' instead)", notes="Get a map from segment to CRC of the segment (deprecated, use 'GET /segments/{tableName}/crc' instead)")
    public Map<String, String> getSegmentToCrcMapDeprecated(@ApiParam(value="Name of the table", required=true) @PathParam(value="tableName") String tableName) {
        return this.getSegmentToCrcMap(tableName);
    }

    @GET
    @Path(value="segments/{tableName}/{segmentName}/metadata")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the metadata for a segment", notes="Get the metadata for a segment")
    public Map<String, String> getSegmentMetadata(@ApiParam(value="Name of the table", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="Name of the segment", required=true) @PathParam(value="segmentName") @Encoded String segmentName) {
        TableType tableType = SegmentName.isRealtimeSegmentName((String)(segmentName = URIUtils.decode((String)segmentName))) ? TableType.REALTIME : TableType.OFFLINE;
        String tableNameWithType = ResourceUtils.getExistingTableNamesWithType(this._pinotHelixResourceManager, tableName, tableType, LOGGER).get(0);
        Map<String, String> segmentMetadata = this.getSegmentMetadataInternal(tableNameWithType, segmentName);
        if (segmentMetadata != null) {
            return segmentMetadata;
        }
        throw new ControllerApplicationException(LOGGER, "Failed to find segment: " + segmentName + " in table: " + tableName, Response.Status.NOT_FOUND);
    }

    @Nullable
    private Map<String, String> getSegmentMetadataInternal(String tableNameWithType, String segmentName) {
        ZkHelixPropertyStore<ZNRecord> propertyStore = this._pinotHelixResourceManager.getPropertyStore();
        SegmentZKMetadata segmentZKMetadata = ZKMetadataProvider.getSegmentZKMetadata(propertyStore, (String)tableNameWithType, (String)segmentName);
        return segmentZKMetadata != null ? segmentZKMetadata.toMap() : null;
    }

    @Deprecated
    @GET
    @Path(value="tables/{tableName}/segments/{segmentName}/metadata")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the metadata for a segment (deprecated, use 'GET /segments/{tableName}/{segmentName}/metadata' instead)", notes="Get the metadata for a segment (deprecated, use 'GET /segments/{tableName}/{segmentName}/metadata' instead)")
    public List<List<Map<String, Object>>> getSegmentMetadataDeprecated1(@ApiParam(value="Name of the table", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="Name of the segment", required=true) @PathParam(value="segmentName") @Encoded String segmentName, @ApiParam(value="OFFLINE|REALTIME") @QueryParam(value="type") String tableTypeStr) {
        segmentName = URIUtils.decode((String)segmentName);
        TableType tableType = Constants.validateTableType(tableTypeStr);
        List<String> tableNamesWithType = ResourceUtils.getExistingTableNamesWithType(this._pinotHelixResourceManager, tableName, tableType, LOGGER);
        ArrayList<List<Map<String, Object>>> resultList = new ArrayList<List<Map<String, Object>>>(tableNamesWithType.size());
        for (String tableNameWithType : tableNamesWithType) {
            Map<String, String> segmentMetadata = this.getSegmentMetadata(tableNameWithType, segmentName);
            if (segmentMetadata == null) continue;
            LinkedHashMap<String, Object> resultForTable = new LinkedHashMap<String, Object>();
            resultForTable.put("tableName", tableNameWithType);
            resultForTable.put("state", segmentMetadata);
            resultList.add(Collections.singletonList(resultForTable));
        }
        if (resultList.isEmpty()) {
            String errorMessage = "Failed to find segment: " + segmentName + " in table: " + tableName;
            if (tableType != null) {
                errorMessage = errorMessage + " of type: " + tableType;
            }
            throw new ControllerApplicationException(LOGGER, errorMessage, Response.Status.NOT_FOUND);
        }
        return resultList;
    }

    @Deprecated
    @GET
    @Path(value="tables/{tableName}/segments/{segmentName}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the metadata for a segment (deprecated, use 'GET /segments/{tableName}/{segmentName}/metadata' instead)", notes="Get the metadata for a segment (deprecated, use 'GET /segments/{tableName}/{segmentName}/metadata' instead)")
    public List<List<Map<String, Object>>> getSegmentMetadataDeprecated2(@ApiParam(value="Name of the table", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="Name of the segment", required=true) @PathParam(value="segmentName") @Encoded String segmentName, @ApiParam(value="MUST be null") @QueryParam(value="state") String stateStr, @ApiParam(value="OFFLINE|REALTIME") @QueryParam(value="type") String tableTypeStr) {
        if (stateStr != null) {
            throw new WebApplicationException("Cannot toggle segment state", Response.Status.FORBIDDEN);
        }
        return this.getSegmentMetadataDeprecated1(tableName, segmentName, tableTypeStr);
    }

    @POST
    @Path(value="segments/{tableName}/{segmentName}/reload")
    @Authenticate(value=AccessType.UPDATE)
    @Produces(value={"application/json"})
    @ApiOperation(value="Reload a segment", notes="Reload a segment")
    public SuccessResponse reloadSegment(@ApiParam(value="Name of the table", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="Name of the segment", required=true) @PathParam(value="segmentName") @Encoded String segmentName, @ApiParam(value="Whether to force server to download segment") @QueryParam(value="forceDownload") @DefaultValue(value="false") boolean forceDownload) {
        TableType tableType = SegmentName.isRealtimeSegmentName((String)(segmentName = URIUtils.decode((String)segmentName))) ? TableType.REALTIME : TableType.OFFLINE;
        String tableNameWithType = ResourceUtils.getExistingTableNamesWithType(this._pinotHelixResourceManager, tableName, tableType, LOGGER).get(0);
        int numMessagesSent = this._pinotHelixResourceManager.reloadSegment(tableNameWithType, segmentName, forceDownload);
        if (numMessagesSent > 0) {
            return new SuccessResponse("Sent " + numMessagesSent + " reload messages");
        }
        throw new ControllerApplicationException(LOGGER, "Failed to find segment: " + segmentName + " in table: " + tableName, Response.Status.NOT_FOUND);
    }

    @POST
    @Path(value="segments/{tableNameWithType}/{segmentName}/reset")
    @Authenticate(value=AccessType.UPDATE)
    @Produces(value={"application/json"})
    @ApiOperation(value="Resets a segment by first disabling it, waiting for external view to stabilize, and finally enabling it again", notes="Resets a segment by disabling and then enabling the segment")
    public SuccessResponse resetSegment(@ApiParam(value="Name of the table with type", required=true) @PathParam(value="tableNameWithType") String tableNameWithType, @ApiParam(value="Name of the segment", required=true) @PathParam(value="segmentName") @Encoded String segmentName, @ApiParam(value="Maximum time in milliseconds to wait for reset to be completed. By default, uses serverAdminRequestTimeout") @QueryParam(value="maxWaitTimeMs") long maxWaitTimeMs) {
        segmentName = URIUtils.decode((String)segmentName);
        TableType tableType = TableNameBuilder.getTableTypeFromTableName((String)tableNameWithType);
        try {
            Preconditions.checkState((tableType != null ? 1 : 0) != 0, (String)"Must provide table name with type: %s", (Object)tableNameWithType);
            this._pinotHelixResourceManager.resetSegment(tableNameWithType, segmentName, maxWaitTimeMs > 0L ? maxWaitTimeMs : (long)(this._controllerConf.getServerAdminRequestTimeoutSeconds() * 1000));
            return new SuccessResponse(String.format("Successfully reset segment: %s of table: %s", segmentName, tableNameWithType));
        }
        catch (IllegalStateException e) {
            throw new ControllerApplicationException(LOGGER, String.format("Failed to reset segments in table: %s. %s", tableNameWithType, e.getMessage()), Response.Status.NOT_FOUND);
        }
        catch (Exception e) {
            throw new ControllerApplicationException(LOGGER, String.format("Failed to reset segment: %s of table: %s. %s", segmentName, tableNameWithType, e.getMessage()), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @POST
    @Path(value="segments/{tableNameWithType}/reset")
    @Produces(value={"application/json"})
    @Authenticate(value=AccessType.UPDATE)
    @ApiOperation(value="Resets all segments of the table, by first disabling them, waiting for external view to stabilize, and finally enabling the segments", notes="Resets a segment by disabling and then enabling a segment")
    public SuccessResponse resetAllSegments(@ApiParam(value="Name of the table with type", required=true) @PathParam(value="tableNameWithType") String tableNameWithType, @ApiParam(value="Maximum time in milliseconds to wait for reset to be completed. By default, uses serverAdminRequestTimeout") @QueryParam(value="maxWaitTimeMs") long maxWaitTimeMs) {
        TableType tableType = TableNameBuilder.getTableTypeFromTableName((String)tableNameWithType);
        try {
            Preconditions.checkState((tableType != null ? 1 : 0) != 0, (String)"Must provide table name with type: %s", (Object)tableNameWithType);
            this._pinotHelixResourceManager.resetAllSegments(tableNameWithType, maxWaitTimeMs > 0L ? maxWaitTimeMs : (long)(this._controllerConf.getServerAdminRequestTimeoutSeconds() * 1000));
            return new SuccessResponse(String.format("Successfully reset all segments of table: %s", tableNameWithType));
        }
        catch (IllegalStateException e) {
            throw new ControllerApplicationException(LOGGER, String.format("Failed to reset segments in table: %s. %s", tableNameWithType, e.getMessage()), Response.Status.NOT_FOUND);
        }
        catch (Exception e) {
            throw new ControllerApplicationException(LOGGER, String.format("Failed to reset segments in table: %s. %s", tableNameWithType, e.getMessage()), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @Deprecated
    @POST
    @Path(value="tables/{tableName}/segments/{segmentName}/reload")
    @Authenticate(value=AccessType.UPDATE)
    @Produces(value={"application/json"})
    @ApiOperation(value="Reload a segment (deprecated, use 'POST /segments/{tableName}/{segmentName}/reload' instead)", notes="Reload a segment (deprecated, use 'POST /segments/{tableName}/{segmentName}/reload' instead)")
    public SuccessResponse reloadSegmentDeprecated1(@ApiParam(value="Name of the table", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="Name of the segment", required=true) @PathParam(value="segmentName") @Encoded String segmentName, @ApiParam(value="OFFLINE|REALTIME") @QueryParam(value="type") String tableTypeStr) {
        segmentName = URIUtils.decode((String)segmentName);
        List<String> tableNamesWithType = ResourceUtils.getExistingTableNamesWithType(this._pinotHelixResourceManager, tableName, Constants.validateTableType(tableTypeStr), LOGGER);
        int numMessagesSent = 0;
        for (String tableNameWithType : tableNamesWithType) {
            numMessagesSent += this._pinotHelixResourceManager.reloadSegment(tableNameWithType, segmentName, false);
        }
        return new SuccessResponse("Sent " + numMessagesSent + " reload messages");
    }

    @Deprecated
    @GET
    @Path(value="tables/{tableName}/segments/{segmentName}/reload")
    @Authenticate(value=AccessType.UPDATE)
    @Produces(value={"application/json"})
    @ApiOperation(value="Reload a segment (deprecated, use 'POST /segments/{tableName}/{segmentName}/reload' instead)", notes="Reload a segment (deprecated, use 'POST /segments/{tableName}/{segmentName}/reload' instead)")
    public SuccessResponse reloadSegmentDeprecated2(@ApiParam(value="Name of the table", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="Name of the segment", required=true) @PathParam(value="segmentName") @Encoded String segmentName, @ApiParam(value="OFFLINE|REALTIME") @QueryParam(value="type") String tableTypeStr) {
        return this.reloadSegmentDeprecated1(tableName, segmentName, tableTypeStr);
    }

    @POST
    @Path(value="segments/{tableName}/reload")
    @Authenticate(value=AccessType.UPDATE)
    @Produces(value={"application/json"})
    @ApiOperation(value="Reload all segments", notes="Reload all segments")
    public SuccessResponse reloadAllSegments(@ApiParam(value="Name of the table", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="OFFLINE|REALTIME") @QueryParam(value="type") String tableTypeStr, @ApiParam(value="Whether to force server to download segment") @QueryParam(value="forceDownload") @DefaultValue(value="false") boolean forceDownload) {
        TableType tableTypeFromTableName = TableNameBuilder.getTableTypeFromTableName((String)tableName);
        TableType tableTypeFromRequest = Constants.validateTableType(tableTypeStr);
        if (forceDownload && tableTypeFromTableName == null && tableTypeFromRequest == null) {
            tableTypeFromRequest = TableType.OFFLINE;
        }
        List<String> tableNamesWithType = ResourceUtils.getExistingTableNamesWithType(this._pinotHelixResourceManager, tableName, tableTypeFromRequest, LOGGER);
        LinkedHashMap<String, Integer> numMessagesSentPerTable = new LinkedHashMap<String, Integer>();
        for (String tableNameWithType : tableNamesWithType) {
            int numMsgSent = this._pinotHelixResourceManager.reloadAllSegments(tableNameWithType, forceDownload);
            numMessagesSentPerTable.put(tableNameWithType, numMsgSent);
        }
        return new SuccessResponse("Sent " + numMessagesSentPerTable + " reload messages");
    }

    @Deprecated
    @POST
    @Path(value="tables/{tableName}/segments/reload")
    @Authenticate(value=AccessType.UPDATE)
    @Produces(value={"application/json"})
    @ApiOperation(value="Reload all segments (deprecated, use 'POST /segments/{tableName}/reload' instead)", notes="Reload all segments (deprecated, use 'POST /segments/{tableName}/reload' instead)")
    public SuccessResponse reloadAllSegmentsDeprecated1(@ApiParam(value="Name of the table", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="OFFLINE|REALTIME") @QueryParam(value="type") String tableTypeStr) {
        List<String> tableNamesWithType = ResourceUtils.getExistingTableNamesWithType(this._pinotHelixResourceManager, tableName, Constants.validateTableType(tableTypeStr), LOGGER);
        int numMessagesSent = 0;
        for (String tableNameWithType : tableNamesWithType) {
            numMessagesSent += this._pinotHelixResourceManager.reloadAllSegments(tableNameWithType, false);
        }
        return new SuccessResponse("Sent " + numMessagesSent + " reload messages");
    }

    @Deprecated
    @GET
    @Path(value="tables/{tableName}/segments/reload")
    @Authenticate(value=AccessType.UPDATE)
    @Produces(value={"application/json"})
    @ApiOperation(value="Reload all segments (deprecated, use 'POST /segments/{tableName}/reload' instead)", notes="Reload all segments (deprecated, use 'POST /segments/{tableName}/reload' instead)")
    public SuccessResponse reloadAllSegmentsDeprecated2(@ApiParam(value="Name of the table", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="OFFLINE|REALTIME") @QueryParam(value="type") String tableTypeStr) {
        return this.reloadAllSegmentsDeprecated1(tableName, tableTypeStr);
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/segments/{tableName}/{segmentName}")
    @Authenticate(value=AccessType.DELETE)
    @ApiOperation(value="Delete a segment", notes="Delete a segment")
    public SuccessResponse deleteSegment(@ApiParam(value="Name of the table", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="Name of the segment", required=true) @PathParam(value="segmentName") @Encoded String segmentName, @ApiParam(value="Retention period for the deleted segments (e.g. 12h, 3d); Using 0d or -1d will instantly delete segments without retention") @QueryParam(value="retention") String retentionPeriod) {
        TableType tableType = SegmentName.isRealtimeSegmentName((String)(segmentName = URIUtils.decode((String)segmentName))) ? TableType.REALTIME : TableType.OFFLINE;
        String tableNameWithType = ResourceUtils.getExistingTableNamesWithType(this._pinotHelixResourceManager, tableName, tableType, LOGGER).get(0);
        this.deleteSegmentsInternal(tableNameWithType, Collections.singletonList(segmentName), retentionPeriod);
        return new SuccessResponse("Segment deleted");
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/segments/{tableName}")
    @Authenticate(value=AccessType.DELETE)
    @ApiOperation(value="Delete all segments", notes="Delete all segments")
    public SuccessResponse deleteAllSegments(@ApiParam(value="Name of the table", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="OFFLINE|REALTIME", required=true) @QueryParam(value="type") String tableTypeStr, @ApiParam(value="Retention period for the deleted segments (e.g. 12h, 3d); Using 0d or -1d will instantly delete segments without retention") @QueryParam(value="retention") String retentionPeriod) {
        TableType tableType = Constants.validateTableType(tableTypeStr);
        if (tableType == null) {
            throw new ControllerApplicationException(LOGGER, "Table type must not be null", Response.Status.BAD_REQUEST);
        }
        String tableNameWithType = ResourceUtils.getExistingTableNamesWithType(this._pinotHelixResourceManager, tableName, tableType, LOGGER).get(0);
        this.deleteSegmentsInternal(tableNameWithType, this._pinotHelixResourceManager.getSegmentsFor(tableNameWithType, false), retentionPeriod);
        return new SuccessResponse("All segments of table " + tableNameWithType + " deleted");
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/segments/{tableName}/delete")
    @Authenticate(value=AccessType.DELETE)
    @ApiOperation(value="Delete the segments in the JSON array payload", notes="Delete the segments in the JSON array payload")
    public SuccessResponse deleteSegments(@ApiParam(value="Name of the table", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="Retention period for the deleted segments (e.g. 12h, 3d); Using 0d or -1d will instantly delete segments without retention") @QueryParam(value="retention") String retentionPeriod, List<String> segments) {
        int numSegments = segments.size();
        if (numSegments == 0) {
            throw new ControllerApplicationException(LOGGER, "Segments must be provided", Response.Status.BAD_REQUEST);
        }
        boolean isRealtimeSegment = SegmentName.isRealtimeSegmentName((String)segments.get(0));
        for (int i = 1; i < numSegments; ++i) {
            if (SegmentName.isRealtimeSegmentName((String)segments.get(i)) == isRealtimeSegment) continue;
            throw new ControllerApplicationException(LOGGER, "All segments must be of the same type (OFFLINE|REALTIME)", Response.Status.BAD_REQUEST);
        }
        TableType tableType = isRealtimeSegment ? TableType.REALTIME : TableType.OFFLINE;
        String tableNameWithType = ResourceUtils.getExistingTableNamesWithType(this._pinotHelixResourceManager, tableName, tableType, LOGGER).get(0);
        this.deleteSegmentsInternal(tableNameWithType, segments, retentionPeriod);
        if (numSegments <= 5) {
            return new SuccessResponse("Deleted segments: " + segments + " from table: " + tableNameWithType);
        }
        return new SuccessResponse("Deleted " + numSegments + " segments from table: " + tableNameWithType);
    }

    private void deleteSegmentsInternal(String tableNameWithType, List<String> segments, String retentionPeriod) {
        PinotResourceManagerResponse response = this._pinotHelixResourceManager.deleteSegments(tableNameWithType, segments, retentionPeriod);
        if (!response.isSuccessful()) {
            throw new ControllerApplicationException(LOGGER, "Failed to delete segments from table: " + tableNameWithType + ", error message: " + response.getMessage(), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="segments/{tableName}/metadata")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the server metadata for all table segments", notes="Get the server metadata for all table segments")
    public String getServerMetadata(@ApiParam(value="Name of the table", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="OFFLINE|REALTIME") @QueryParam(value="type") String tableTypeStr, @ApiParam(value="Columns name", allowMultiple=true) @QueryParam(value="columns") @DefaultValue(value="") List<String> columns) {
        String segmentsMetadata;
        LOGGER.info("Received a request to fetch metadata for all segments for table {}", (Object)tableName);
        TableType tableType = Constants.validateTableType(tableTypeStr);
        String tableNameWithType = ResourceUtils.getExistingTableNamesWithType(this._pinotHelixResourceManager, tableName, tableType, LOGGER).get(0);
        try {
            JsonNode segmentsMetadataJson = this.getSegmentsMetadataFromServer(tableNameWithType, columns);
            segmentsMetadata = JsonUtils.objectToPrettyString((Object)segmentsMetadataJson);
        }
        catch (InvalidConfigException e) {
            throw new ControllerApplicationException(LOGGER, e.getMessage(), Response.Status.BAD_REQUEST);
        }
        catch (IOException ioe) {
            throw new ControllerApplicationException(LOGGER, "Error parsing Pinot server response: " + ioe.getMessage(), Response.Status.INTERNAL_SERVER_ERROR, (Throwable)ioe);
        }
        return segmentsMetadata;
    }

    @GET
    @Path(value="segments/{tableName}/select")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the selected segments given the (inclusive) start and (exclusive) end timestamps in milliseconds. These timestamps will be compared against the minmax values of the time column in each segment. If the table is a refresh use case, the value of start and end timestamp is voided, since there is no time column for refresh use case; instead, the whole qualified segments will be returned. If no timestamps are provided, all the qualified segments will be returned. For the segments that partially belong to the time range, the boolean flag 'excludeOverlapping' is introduced in order for user to determine whether to exclude this kind of segments in the response.", notes="Get the selected segments given the start and end timestamps in milliseconds")
    public List<Map<TableType, List<String>>> getSelectedSegments(@ApiParam(value="Name of the table", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="OFFLINE|REALTIME") @QueryParam(value="type") String tableTypeStr, @ApiParam(value="Start timestamp (inclusive)") @QueryParam(value="startTimestamp") @DefaultValue(value="") String startTimestampStr, @ApiParam(value="End timestamp (exclusive)") @QueryParam(value="endTimestamp") @DefaultValue(value="") String endTimestampStr, @ApiParam(value="Whether to exclude the segments overlapping with the timestamps, false by default") @QueryParam(value="excludeOverlapping") @DefaultValue(value="false") boolean excludeOverlapping) {
        long startTimestamp = Strings.isNullOrEmpty((String)startTimestampStr) ? Long.MIN_VALUE : Long.parseLong(startTimestampStr);
        long endTimestamp = Strings.isNullOrEmpty((String)endTimestampStr) ? Long.MAX_VALUE : Long.parseLong(endTimestampStr);
        Preconditions.checkArgument((startTimestamp < endTimestamp ? 1 : 0) != 0, (String)"The value of startTimestamp should be smaller than the one of endTimestamp. Start timestamp: %d. End timestamp: %d", (long)startTimestamp, (long)endTimestamp);
        List<String> tableNamesWithType = ResourceUtils.getExistingTableNamesWithType(this._pinotHelixResourceManager, tableName, Constants.validateTableType(tableTypeStr), LOGGER);
        ArrayList<Map<TableType, List<String>>> resultList = new ArrayList<Map<TableType, List<String>>>(tableNamesWithType.size());
        for (String tableNameWithType : tableNamesWithType) {
            TableType tableType = TableNameBuilder.getTableTypeFromTableName((String)tableNameWithType);
            List<String> segments = this._pinotHelixResourceManager.getSegmentsForTableWithTimestamps(tableNameWithType, startTimestamp, endTimestamp, excludeOverlapping);
            resultList.add(Collections.singletonMap(tableType, segments));
        }
        return resultList;
    }

    private JsonNode getSegmentsMetadataFromServer(String tableNameWithType, List<String> columns) throws InvalidConfigException, IOException {
        TableMetadataReader tableMetadataReader = new TableMetadataReader(this._executor, this._connectionManager, this._pinotHelixResourceManager);
        return tableMetadataReader.getSegmentsMetadata(tableNameWithType, columns, this._controllerConf.getServerAdminRequestTimeoutSeconds() * 1000);
    }

    @GET
    @Path(value="/tables/{realtimeTableName}/consumingSegmentsInfo")
    @Produces(value={"application/json"})
    @ApiOperation(value="Returns state of consuming segments", notes="Gets the status of consumers from all servers")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=404, message="Table not found"), @ApiResponse(code=500, message="Internal server error")})
    public ConsumingSegmentInfoReader.ConsumingSegmentsInfoMap getConsumingSegmentsInfo(@ApiParam(value="Realtime table name with or without type", required=true, example="myTable | myTable_REALTIME") @PathParam(value="realtimeTableName") String realtimeTableName) {
        try {
            TableType tableType = TableNameBuilder.getTableTypeFromTableName((String)realtimeTableName);
            if (TableType.OFFLINE == tableType) {
                throw new IllegalStateException("Cannot get consuming segments info for OFFLINE table: " + realtimeTableName);
            }
            String tableNameWithType = TableNameBuilder.forType((TableType)TableType.REALTIME).tableNameWithType(realtimeTableName);
            ConsumingSegmentInfoReader consumingSegmentInfoReader = new ConsumingSegmentInfoReader(this._executor, this._connectionManager, this._pinotHelixResourceManager);
            return consumingSegmentInfoReader.getConsumingSegmentsInfo(tableNameWithType, this._controllerConf.getServerAdminRequestTimeoutSeconds() * 1000);
        }
        catch (Exception e) {
            throw new ControllerApplicationException(LOGGER, String.format("Failed to get consuming segments info for table %s. %s", realtimeTableName, e.getMessage()), Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }
}

