/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.api.resources;

import com.google.common.collect.ImmutableList;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.helix.model.InstanceConfig;
import org.apache.pinot.common.exception.TableNotFoundException;
import org.apache.pinot.controller.api.access.AccessType;
import org.apache.pinot.controller.api.access.Authenticate;
import org.apache.pinot.controller.api.exception.ControllerApplicationException;
import org.apache.pinot.controller.api.resources.Constants;
import org.apache.pinot.controller.api.resources.InstanceInfo;
import org.apache.pinot.controller.api.resources.SuccessResponse;
import org.apache.pinot.controller.helix.core.PinotHelixResourceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(tags={"Broker"})
@Path(value="/")
public class PinotBrokerRestletResource {
    public static final Logger LOGGER = LoggerFactory.getLogger(PinotBrokerRestletResource.class);
    @Inject
    PinotHelixResourceManager _pinotHelixResourceManager;

    @GET
    @Produces(value={"application/json"})
    @Path(value="/brokers")
    @ApiOperation(value="List tenants and tables to brokers mappings", notes="List tenants and tables to brokers mappings")
    public Map<String, Map<String, List<String>>> listBrokersMapping(@ApiParam(value="ONLINE|OFFLINE") @QueryParam(value="state") String state) {
        HashMap<String, Map<String, List<String>>> resultMap = new HashMap<String, Map<String, List<String>>>();
        resultMap.put("tenants", this.getTenantsToBrokersMapping(state));
        resultMap.put("tables", this.getTablesToBrokersMapping(state));
        return resultMap;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/brokers/tenants")
    @ApiOperation(value="List tenants to brokers mappings", notes="List tenants to brokers mappings")
    public Map<String, List<String>> getTenantsToBrokersMapping(@ApiParam(value="ONLINE|OFFLINE") @QueryParam(value="state") String state) {
        HashMap<String, List<String>> resultMap = new HashMap<String, List<String>>();
        this._pinotHelixResourceManager.getAllBrokerTenantNames().stream().forEach(tenant -> resultMap.put((String)tenant, this.getBrokersForTenant((String)tenant, state)));
        return resultMap;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/brokers/tenants/{tenantName}")
    @ApiOperation(value="List brokers for a given tenant", notes="List brokers for a given tenant")
    public List<String> getBrokersForTenant(@ApiParam(value="Name of the tenant", required=true) @PathParam(value="tenantName") String tenantName, @ApiParam(value="ONLINE|OFFLINE") @QueryParam(value="state") String state) {
        List<InstanceInfo> instanceInfoList = this.getBrokersForTenantV2(tenantName, state);
        List<String> tenantBrokers = instanceInfoList.stream().map(InstanceInfo::getInstanceName).collect(Collectors.toList());
        return tenantBrokers;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/brokers/tables")
    @ApiOperation(value="List tables to brokers mappings", notes="List tables to brokers mappings")
    public Map<String, List<String>> getTablesToBrokersMapping(@ApiParam(value="ONLINE|OFFLINE") @QueryParam(value="state") String state) {
        HashMap<String, List<String>> resultMap = new HashMap<String, List<String>>();
        this._pinotHelixResourceManager.getAllRawTables().stream().forEach(table -> resultMap.put((String)table, this.getBrokersForTable((String)table, null, state)));
        return resultMap;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/brokers/tables/{tableName}")
    @ApiOperation(value="List brokers for a given table", notes="List brokers for a given table")
    public List<String> getBrokersForTable(@ApiParam(value="Name of the table", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="OFFLINE|REALTIME") @QueryParam(value="type") String tableTypeStr, @ApiParam(value="ONLINE|OFFLINE") @QueryParam(value="state") String state) {
        List<InstanceInfo> instanceInfoList = this.getBrokersForTableV2(tableName, tableTypeStr, state);
        return instanceInfoList.stream().map(InstanceInfo::getInstanceName).collect(Collectors.toList());
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/v2/brokers")
    @ApiOperation(value="List tenants and tables to brokers mappings", notes="List tenants and tables to brokers mappings")
    public Map<String, Map<String, List<InstanceInfo>>> listBrokersMappingV2(@ApiParam(value="ONLINE|OFFLINE") @QueryParam(value="state") String state) {
        HashMap<String, Map<String, List<InstanceInfo>>> resultMap = new HashMap<String, Map<String, List<InstanceInfo>>>();
        resultMap.put("tenants", this.getTenantsToBrokersMappingV2(state));
        resultMap.put("tables", this.getTablesToBrokersMappingV2(state));
        return resultMap;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/v2/brokers/tenants")
    @ApiOperation(value="List tenants to brokers mappings", notes="List tenants to brokers mappings")
    public Map<String, List<InstanceInfo>> getTenantsToBrokersMappingV2(@ApiParam(value="ONLINE|OFFLINE") @QueryParam(value="state") String state) {
        HashMap<String, List<InstanceInfo>> resultMap = new HashMap<String, List<InstanceInfo>>();
        this._pinotHelixResourceManager.getAllBrokerTenantNames().stream().forEach(tenant -> resultMap.put((String)tenant, this.getBrokersForTenantV2((String)tenant, state)));
        return resultMap;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/v2/brokers/tenants/{tenantName}")
    @ApiOperation(value="List brokers for a given tenant", notes="List brokers for a given tenant")
    public List<InstanceInfo> getBrokersForTenantV2(@ApiParam(value="Name of the tenant", required=true) @PathParam(value="tenantName") String tenantName, @ApiParam(value="ONLINE|OFFLINE") @QueryParam(value="state") String state) {
        if (!this._pinotHelixResourceManager.getAllBrokerTenantNames().contains(tenantName)) {
            throw new ControllerApplicationException(LOGGER, String.format("Tenant '%s' not found.", tenantName), Response.Status.NOT_FOUND);
        }
        HashSet<InstanceConfig> tenantBrokers = new HashSet<InstanceConfig>(this._pinotHelixResourceManager.getAllInstancesConfigsForBrokerTenant(tenantName));
        Set<InstanceInfo> instanceInfoSet = tenantBrokers.stream().map(x -> new InstanceInfo(x.getInstanceName(), x.getHostName(), Integer.parseInt(x.getPort()))).collect(Collectors.toSet());
        this.applyStateChanges(instanceInfoSet, state);
        return ImmutableList.copyOf(instanceInfoSet);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/v2/brokers/tables")
    @ApiOperation(value="List tables to brokers mappings", notes="List tables to brokers mappings")
    public Map<String, List<InstanceInfo>> getTablesToBrokersMappingV2(@ApiParam(value="ONLINE|OFFLINE") @QueryParam(value="state") String state) {
        HashMap<String, List<InstanceInfo>> resultMap = new HashMap<String, List<InstanceInfo>>();
        this._pinotHelixResourceManager.getAllRawTables().stream().forEach(table -> resultMap.put((String)table, this.getBrokersForTableV2((String)table, null, state)));
        return resultMap;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/v2/brokers/tables/{tableName}")
    @ApiOperation(value="List brokers for a given table", notes="List brokers for a given table")
    public List<InstanceInfo> getBrokersForTableV2(@ApiParam(value="Name of the table", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="OFFLINE|REALTIME") @QueryParam(value="type") String tableTypeStr, @ApiParam(value="ONLINE|OFFLINE") @QueryParam(value="state") String state) {
        try {
            List<String> tableNamesWithType = this._pinotHelixResourceManager.getExistingTableNamesWithType(tableName, Constants.validateTableType(tableTypeStr));
            if (tableNamesWithType.isEmpty()) {
                throw new ControllerApplicationException(LOGGER, String.format("Table '%s' not found.", tableName), Response.Status.NOT_FOUND);
            }
            HashSet<InstanceConfig> tenantBrokers = new HashSet<InstanceConfig>(this._pinotHelixResourceManager.getBrokerInstancesConfigsFor(tableNamesWithType.get(0)));
            Set<InstanceInfo> instanceInfoSet = tenantBrokers.stream().map(x -> new InstanceInfo(x.getInstanceName(), x.getHostName(), Integer.parseInt(x.getPort()))).collect(Collectors.toSet());
            this.applyStateChanges(instanceInfoSet, state);
            return ImmutableList.copyOf(instanceInfoSet);
        }
        catch (TableNotFoundException e) {
            throw new ControllerApplicationException(LOGGER, String.format("Table '%s' not found.", tableName), Response.Status.NOT_FOUND);
        }
        catch (IllegalArgumentException e) {
            throw new ControllerApplicationException(LOGGER, e.getMessage(), Response.Status.FORBIDDEN);
        }
    }

    @POST
    @Path(value="/brokers/instances/{instanceName}/qps")
    @Authenticate(value=AccessType.UPDATE)
    @Produces(value={"application/json"})
    @Consumes(value={"text/plain"})
    @ApiOperation(value="Enable/disable the query rate limiting for a broker instance", notes="Enable/disable the query rate limiting for a broker instance")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=404, message="Instance not found"), @ApiResponse(code=500, message="Internal error")})
    public SuccessResponse toggleQueryRateLimiting(@ApiParam(value="Broker instance name", required=true, example="Broker_my.broker.com_30000") @PathParam(value="instanceName") String brokerInstanceName, @ApiParam(value="ENABLE|DISABLE", allowableValues="ENABLE, DISABLE", required=true) @QueryParam(value="state") String state) {
        if (brokerInstanceName == null || !brokerInstanceName.startsWith("Broker_")) {
            throw new ControllerApplicationException(LOGGER, String.format("'%s' is not a valid broker instance name.", brokerInstanceName), Response.Status.BAD_REQUEST);
        }
        String stateInUpperCases = state.toUpperCase();
        this.validateQueryQuotaStateChange(stateInUpperCases);
        List<String> liveInstances = this._pinotHelixResourceManager.getOnlineInstanceList();
        if (!liveInstances.contains(brokerInstanceName)) {
            throw new ControllerApplicationException(LOGGER, String.format("Instance '%s' not found.", brokerInstanceName), Response.Status.NOT_FOUND);
        }
        this._pinotHelixResourceManager.toggleQueryQuotaStateForBroker(brokerInstanceName, stateInUpperCases);
        String msg = String.format("Set query rate limiting to: %s for all tables in broker: %s", stateInUpperCases, brokerInstanceName);
        LOGGER.info(msg);
        return new SuccessResponse(msg);
    }

    private void validateQueryQuotaStateChange(String state) {
        if (!"ENABLE".equals(state) && !"DISABLE".equals(state)) {
            throw new ControllerApplicationException(LOGGER, "Invalid query quota state: " + state, Response.Status.BAD_REQUEST);
        }
    }

    private void applyStateChanges(Set<InstanceInfo> brokers, String state) {
        if (state == null) {
            return;
        }
        List<String> onlineInstanceList = this._pinotHelixResourceManager.getOnlineInstanceList();
        Set onlineBrokers = brokers.stream().filter(x -> onlineInstanceList.contains(x.getInstanceName())).collect(Collectors.toSet());
        switch (state) {
            case "ONLINE": {
                brokers.retainAll(onlineBrokers);
                break;
            }
            case "OFFLINE": {
                brokers.removeAll(onlineBrokers);
                break;
            }
        }
    }
}

