/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.xobject;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSBoolean;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.preflight.PreflightConfiguration;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.exception.ValidationException;
import org.apache.pdfbox.preflight.graphic.ColorSpaceHelper;
import org.apache.pdfbox.preflight.graphic.ColorSpaceHelperFactory;
import org.apache.pdfbox.preflight.utils.RenderingIntents;
import org.apache.pdfbox.preflight.xobject.AbstractXObjValidator;

public class XObjImageValidator
extends AbstractXObjValidator {
    private static final Log LOGGER = LogFactory.getLog(XObjImageValidator.class);
    protected PDImageXObject xImage = null;

    public XObjImageValidator(PreflightContext context, PDImageXObject xobj) {
        super(context, xobj.getCOSObject());
        this.xImage = xobj;
    }

    @Override
    protected void checkMandatoryFields() {
        boolean res = this.xobject.getItem(COSName.WIDTH) != null;
        boolean bl = res = res && this.xobject.getItem(COSName.HEIGHT) != null;
        if (!res) {
            this.context.addValidationError(new ValidationResult.ValidationError("2.1.7"));
        }
    }

    protected void checkAlternates() throws ValidationException {
        if (this.xobject.getItem("Alternates") != null) {
            this.context.addValidationError(new ValidationResult.ValidationError("2.3", "Unexpected 'Alternates' Key"));
        }
    }

    protected void checkInterpolate() {
        if (this.xobject.getItem(COSName.INTERPOLATE) != null && this.xobject.getBoolean(COSName.INTERPOLATE, true)) {
            this.context.addValidationError(new ValidationResult.ValidationError("2.3.2", "Unexpected 'true' value for 'Interpolate' Key"));
        }
    }

    protected void checkIntent() {
        COSName renderingIntent = this.xobject.getCOSName(COSName.INTENT);
        if (renderingIntent != null && !RenderingIntents.contains(renderingIntent)) {
            this.context.addValidationError(new ValidationResult.ValidationError("2.3.2", "Unexpected value '" + renderingIntent.getName() + "' for Intent key in image"));
        }
    }

    protected void checkColorSpaceAndImageMask() throws ValidationException {
        COSBase csImg = this.xobject.getItem(COSName.COLORSPACE);
        COSBase bitsPerComp = this.xobject.getDictionaryObject(COSName.BITS_PER_COMPONENT);
        COSBase mask = this.xobject.getItem(COSName.MASK);
        if (this.isImageMaskTrue()) {
            if (csImg != null || mask != null) {
                this.context.addValidationError(new ValidationResult.ValidationError("2.3", "ImageMask entry is true, ColorSpace and Mask are forbidden."));
            }
            if (bitsPerComp instanceof COSInteger && ((COSInteger)bitsPerComp).intValue() != 1) {
                this.context.addValidationError(new ValidationResult.ValidationError("2.3.2", "ImageMask entry is true, BitsPerComponent must be absent or 1."));
            }
        } else {
            try {
                PreflightConfiguration config = this.context.getConfig();
                ColorSpaceHelperFactory csFact = config.getColorSpaceHelperFact();
                PDColorSpace pdCS = PDColorSpace.create((COSBase)csImg);
                ColorSpaceHelper csh = csFact.getColorSpaceHelper(this.context, pdCS, ColorSpaceHelperFactory.ColorSpaceRestriction.NO_PATTERN);
                csh.validate();
            }
            catch (IOException e) {
                LOGGER.debug((Object)("Couldn't create PDColorSpace " + csImg), (Throwable)e);
                this.context.addValidationError(new ValidationResult.ValidationError("2.4.4"));
            }
        }
    }

    private boolean isImageMaskTrue() {
        COSBase imgMask = this.xobject.getItem("ImageMask");
        if (imgMask instanceof COSBoolean) {
            return ((COSBoolean)imgMask).getValue();
        }
        return false;
    }

    @Override
    public void validate() throws ValidationException {
        super.validate();
        this.checkAlternates();
        this.checkInterpolate();
        this.checkIntent();
        this.checkColorSpaceAndImageMask();
    }
}

