/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.process;

import java.util.HashSet;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNull;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDDocumentOutline;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDOutlineItem;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.exception.ValidationException;
import org.apache.pdfbox.preflight.process.AbstractProcess;
import org.apache.pdfbox.preflight.utils.ContextHelper;

public class BookmarkValidationProcess
extends AbstractProcess {
    @Override
    public void validate(PreflightContext ctx) throws ValidationException {
        PDDocumentCatalog catalog = ctx.getDocument().getDocumentCatalog();
        if (catalog != null) {
            PDDocumentOutline outlineHierarchy = catalog.getDocumentOutline();
            if (outlineHierarchy != null) {
                COSDictionary dict = outlineHierarchy.getCOSObject();
                if (!this.checkIndirectObjects(ctx, dict)) {
                    return;
                }
                COSObject firstObj = this.toCOSObject(dict.getItem(COSName.FIRST));
                COSObject lastObj = this.toCOSObject(dict.getItem(COSName.LAST));
                if (!(this.isCountEntryPresent(dict) || outlineHierarchy.getFirstChild() == null && outlineHierarchy.getLastChild() == null)) {
                    this.addValidationError(ctx, new ValidationResult.ValidationError("1.4.9", "Outline Hierarchy doesn't have Count entry"));
                } else if (this.isCountEntryPositive(dict) && (outlineHierarchy.getFirstChild() == null || outlineHierarchy.getLastChild() == null)) {
                    this.addValidationError(ctx, new ValidationResult.ValidationError("1.4.9", "Outline Hierarchy doesn't have First and/or Last entry(ies)"));
                } else {
                    this.exploreOutlineLevel(ctx, outlineHierarchy.getFirstChild(), firstObj, lastObj);
                }
            }
        } else {
            ctx.addValidationError(new ValidationResult.ValidationError("1.2.14", "There is no /Catalog entry in the Document"));
        }
    }

    private boolean isCountEntryPresent(COSDictionary outline) {
        return outline.getItem(COSName.COUNT) != null;
    }

    private boolean isCountEntryPositive(COSDictionary outline) {
        COSBase countBase = outline.getDictionaryObject(COSName.COUNT);
        return countBase instanceof COSInteger && ((COSInteger)countBase).intValue() > 0;
    }

    protected boolean exploreOutlineLevel(PreflightContext ctx, PDOutlineItem inputItem, COSObject firstObj, COSObject lastObj) throws ValidationException {
        PDOutlineItem currentItem = inputItem;
        COSObject currentObj = firstObj;
        HashSet<COSObject> levelObjects = new HashSet<COSObject>();
        levelObjects.add(firstObj);
        boolean result = true;
        if (currentItem != null && inputItem.getPreviousSibling() != null) {
            this.addValidationError(ctx, new ValidationResult.ValidationError("1.4.9", "The value of /Prev of first object " + firstObj + " on a level is " + inputItem.getCOSObject().getItem(COSName.PREV) + ", but shouldn't exist"));
            result = false;
        }
        while (currentItem != null) {
            COSObject realPrevObject = currentObj;
            if (!this.validateItem(ctx, currentItem)) {
                result = false;
            }
            if (levelObjects.contains(currentObj = this.toCOSObject(currentItem.getCOSObject().getItem(COSName.NEXT)))) {
                this.addValidationError(ctx, new ValidationResult.ValidationError("1.4.9", "Loop detected: /Next " + currentObj + " is already in the list"));
                return false;
            }
            if (realPrevObject == null) {
                this.addValidationError(ctx, new ValidationResult.ValidationError("1.4.9", "Outline object before " + currentObj + " is null"));
                return false;
            }
            levelObjects.add(currentObj);
            currentItem = currentItem.getNextSibling();
            if (currentItem == null) {
                if (realPrevObject.equals(lastObj)) continue;
                this.addValidationError(ctx, new ValidationResult.ValidationError("1.4.9", "Last object on a level isn't the expected /Last: " + lastObj + ", but is " + currentObj));
                result = false;
                continue;
            }
            COSObject prevObject = this.toCOSObject(currentItem.getCOSObject().getItem(COSName.PREV));
            if (realPrevObject.equals(prevObject)) continue;
            this.addValidationError(ctx, new ValidationResult.ValidationError("1.4.9", "The value of /Prev at " + currentObj + " doesn't point to previous object " + realPrevObject + ", but to " + prevObject));
            result = false;
        }
        return result;
    }

    protected boolean validateItem(PreflightContext ctx, PDOutlineItem inputItem) throws ValidationException {
        boolean isValid = true;
        COSDictionary dictionary = inputItem.getCOSObject();
        COSBase dest = dictionary.getItem(COSName.DEST);
        COSBase action = dictionary.getItem(COSName.A);
        if (!this.checkIndirectObjects(ctx, dictionary)) {
            return false;
        }
        if (action != null && dest != null) {
            this.addValidationError(ctx, new ValidationResult.ValidationError("1.4.9", "Dest entry isn't permitted if the A entry is present"));
            return false;
        }
        if (action != null) {
            ContextHelper.validateElement(ctx, dictionary, "actions-process");
        } else if (dest != null) {
            ContextHelper.validateElement(ctx, dest, "destination-process");
        }
        PDOutlineItem fChild = inputItem.getFirstChild();
        if (fChild != null) {
            if (!this.isCountEntryPresent(inputItem.getCOSObject())) {
                this.addValidationError(ctx, new ValidationResult.ValidationError("1.4.9", "Outline item doesn't have Count entry but has at least one descendant"));
                isValid = false;
            } else {
                COSObject firstObj = this.toCOSObject(dictionary.getItem(COSName.FIRST));
                COSObject lastObj = this.toCOSObject(dictionary.getItem(COSName.LAST));
                if (firstObj == null && lastObj != null || firstObj != null && lastObj == null) {
                    this.addValidationError(ctx, new ValidationResult.ValidationError("1.4.9", "/First and /Last are both required if there are outline entries"));
                    isValid = false;
                }
                isValid = isValid && this.exploreOutlineLevel(ctx, fChild, firstObj, lastObj);
            }
        }
        return isValid;
    }

    private boolean checkIndirectObjects(PreflightContext ctx, COSDictionary dictionary) {
        if (!this.checkIndirectObject(ctx, dictionary, COSName.PARENT)) {
            return false;
        }
        if (!this.checkIndirectObject(ctx, dictionary, COSName.PREV)) {
            return false;
        }
        if (!this.checkIndirectObject(ctx, dictionary, COSName.NEXT)) {
            return false;
        }
        if (!this.checkIndirectObject(ctx, dictionary, COSName.FIRST)) {
            return false;
        }
        return this.checkIndirectObject(ctx, dictionary, COSName.LAST);
    }

    private boolean checkIndirectObject(PreflightContext ctx, COSDictionary dictionary, COSName name) {
        COSBase item = dictionary.getItem(name);
        if (item == null || item instanceof COSNull || item instanceof COSObject) {
            return true;
        }
        this.addValidationError(ctx, new ValidationResult.ValidationError("1.4.9", "/" + name.getName() + " entry must be an indirect object"));
        return false;
    }

    private COSObject toCOSObject(COSBase base) {
        if (base == null || base instanceof COSNull) {
            return null;
        }
        if (!(base instanceof COSObject)) {
            throw new IllegalArgumentException("Paremater " + base + " should be null, COSNull or a COSObject");
        }
        return (COSObject)base;
    }
}

