/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight;

import java.io.Closeable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.activation.DataSource;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.pdfparser.XrefTrailerResolver;
import org.apache.pdfbox.preflight.PreflightConfiguration;
import org.apache.pdfbox.preflight.PreflightDocument;
import org.apache.pdfbox.preflight.PreflightPath;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.font.container.FontContainer;
import org.apache.pdfbox.preflight.graphic.ICCProfileWrapper;
import org.apache.pdfbox.preflight.utils.COSUtils;
import org.apache.xmpbox.XMPMetadata;

public class PreflightContext
implements Closeable {
    private final Map<COSBase, FontContainer<?>> fontContainers = new HashMap();
    private PreflightDocument document = null;
    private DataSource source = null;
    private XrefTrailerResolver xrefTrailerResolver;
    private ICCProfileWrapper iccProfileWrapper = null;
    private boolean iccProfileAlreadySearched = false;
    private XMPMetadata metadata = null;
    private PreflightConfiguration config = null;
    private PreflightPath validationPath = new PreflightPath();
    private Integer currentPageNumber = null;
    private long fileLen;

    public PreflightContext(DataSource source) {
        this.source = source;
    }

    public PreflightContext(DataSource source, PreflightConfiguration configuration) {
        this.source = source;
        this.config = configuration;
    }

    public XMPMetadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(XMPMetadata metadata) {
        this.metadata = metadata;
    }

    public PreflightDocument getDocument() {
        return this.document;
    }

    public XrefTrailerResolver getXrefTrailerResolver() {
        return this.xrefTrailerResolver;
    }

    public void setXrefTrailerResolver(XrefTrailerResolver xrefTrailerResolver) {
        this.xrefTrailerResolver = xrefTrailerResolver;
    }

    public void setDocument(PreflightDocument document) {
        this.document = document;
    }

    public DataSource getSource() {
        return this.source;
    }

    public boolean isComplete() {
        return this.document != null && this.source != null;
    }

    public void addFontContainer(COSBase cBase, FontContainer<?> fc) {
        this.fontContainers.put(cBase, fc);
    }

    public FontContainer<?> getFontContainer(COSBase cBase) {
        return this.fontContainers.get(cBase);
    }

    public ICCProfileWrapper getIccProfileWrapper() {
        return this.iccProfileWrapper;
    }

    public void setIccProfileWrapper(ICCProfileWrapper iccProfileWrapper) {
        this.iccProfileWrapper = iccProfileWrapper;
    }

    public PreflightConfiguration getConfig() {
        return this.config;
    }

    public void setConfig(PreflightConfiguration config) {
        this.config = config;
    }

    @Override
    public void close() {
        COSUtils.closeDocumentQuietly(this.document);
    }

    public void addValidationError(ValidationResult.ValidationError error) {
        PreflightDocument pfDoc = this.document;
        error.setPageNumber(this.currentPageNumber);
        pfDoc.addValidationError(error);
    }

    public void addValidationErrors(List<ValidationResult.ValidationError> errors) {
        PreflightDocument pfDoc = this.document;
        for (ValidationResult.ValidationError error : errors) {
            pfDoc.addValidationError(error);
        }
    }

    public PreflightPath getValidationPath() {
        return this.validationPath;
    }

    public void setValidationPath(PreflightPath validationPath) {
        this.validationPath = validationPath;
    }

    public boolean isIccProfileAlreadySearched() {
        return this.iccProfileAlreadySearched;
    }

    public void setIccProfileAlreadySearched(boolean iccProfileAlreadySearched) {
        this.iccProfileAlreadySearched = iccProfileAlreadySearched;
    }

    public void setCurrentPageNumber(Integer currentPageNumber) {
        this.currentPageNumber = currentPageNumber;
    }

    public Integer getCurrentPageNumber() {
        return this.currentPageNumber;
    }

    public void setFileLen(long fileLen) {
        this.fileLen = fileLen;
    }

    public long getFileLen() {
        return this.fileLen;
    }
}

