/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.content;

import java.io.IOException;
import java.util.List;
import org.apache.pdfbox.contentstream.PDFStreamEngine;
import org.apache.pdfbox.contentstream.operator.DrawObject;
import org.apache.pdfbox.contentstream.operator.Operator;
import org.apache.pdfbox.contentstream.operator.OperatorProcessor;
import org.apache.pdfbox.contentstream.operator.color.SetNonStrokingColor;
import org.apache.pdfbox.contentstream.operator.color.SetNonStrokingColorN;
import org.apache.pdfbox.contentstream.operator.color.SetNonStrokingColorSpace;
import org.apache.pdfbox.contentstream.operator.color.SetNonStrokingDeviceCMYKColor;
import org.apache.pdfbox.contentstream.operator.color.SetNonStrokingDeviceGrayColor;
import org.apache.pdfbox.contentstream.operator.color.SetNonStrokingDeviceRGBColor;
import org.apache.pdfbox.contentstream.operator.color.SetStrokingColor;
import org.apache.pdfbox.contentstream.operator.color.SetStrokingColorN;
import org.apache.pdfbox.contentstream.operator.color.SetStrokingColorSpace;
import org.apache.pdfbox.contentstream.operator.color.SetStrokingDeviceCMYKColor;
import org.apache.pdfbox.contentstream.operator.color.SetStrokingDeviceGrayColor;
import org.apache.pdfbox.contentstream.operator.color.SetStrokingDeviceRGBColor;
import org.apache.pdfbox.contentstream.operator.state.Concatenate;
import org.apache.pdfbox.contentstream.operator.state.Restore;
import org.apache.pdfbox.contentstream.operator.state.Save;
import org.apache.pdfbox.contentstream.operator.state.SetGraphicsStateParameters;
import org.apache.pdfbox.contentstream.operator.state.SetLineCapStyle;
import org.apache.pdfbox.contentstream.operator.state.SetLineDashPattern;
import org.apache.pdfbox.contentstream.operator.state.SetLineJoinStyle;
import org.apache.pdfbox.contentstream.operator.state.SetLineWidth;
import org.apache.pdfbox.contentstream.operator.state.SetMatrix;
import org.apache.pdfbox.contentstream.operator.text.BeginText;
import org.apache.pdfbox.contentstream.operator.text.EndText;
import org.apache.pdfbox.contentstream.operator.text.MoveText;
import org.apache.pdfbox.contentstream.operator.text.MoveTextSetLeading;
import org.apache.pdfbox.contentstream.operator.text.NextLine;
import org.apache.pdfbox.contentstream.operator.text.SetCharSpacing;
import org.apache.pdfbox.contentstream.operator.text.SetFontAndSize;
import org.apache.pdfbox.contentstream.operator.text.SetTextHorizontalScaling;
import org.apache.pdfbox.contentstream.operator.text.SetTextLeading;
import org.apache.pdfbox.contentstream.operator.text.SetTextRenderingMode;
import org.apache.pdfbox.contentstream.operator.text.SetTextRise;
import org.apache.pdfbox.contentstream.operator.text.SetWordSpacing;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.graphics.color.PDCIEBasedColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDICCBased;
import org.apache.pdfbox.pdmodel.graphics.color.PDSeparation;
import org.apache.pdfbox.preflight.PreflightConfiguration;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.content.ContentStreamException;
import org.apache.pdfbox.preflight.content.StubOperator;
import org.apache.pdfbox.preflight.exception.ValidationException;
import org.apache.pdfbox.preflight.graphic.ColorSpaceHelper;
import org.apache.pdfbox.preflight.graphic.ColorSpaceHelperFactory;
import org.apache.pdfbox.preflight.graphic.ColorSpaces;
import org.apache.pdfbox.preflight.graphic.ICCProfileWrapper;
import org.apache.pdfbox.preflight.utils.COSUtils;
import org.apache.pdfbox.preflight.utils.FilterHelper;
import org.apache.pdfbox.preflight.utils.RenderingIntents;

public abstract class PreflightStreamEngine
extends PDFStreamEngine {
    protected PreflightContext context = null;
    protected COSDocument cosDocument = null;
    protected PDPage processedPage = null;

    public PreflightStreamEngine(PreflightContext context, PDPage page) {
        this.context = context;
        this.cosDocument = context.getDocument().getDocument();
        this.processedPage = page;
        this.addOperator((OperatorProcessor)new SetLineWidth());
        this.addOperator((OperatorProcessor)new Concatenate());
        this.addOperator((OperatorProcessor)new SetStrokingColorSpace());
        this.addOperator((OperatorProcessor)new SetNonStrokingColorSpace());
        this.addOperator((OperatorProcessor)new SetLineDashPattern());
        this.addOperator((OperatorProcessor)new DrawObject());
        this.addOperator((OperatorProcessor)new SetLineJoinStyle());
        this.addOperator((OperatorProcessor)new SetLineCapStyle());
        this.addOperator((OperatorProcessor)new SetStrokingDeviceCMYKColor());
        this.addOperator((OperatorProcessor)new SetNonStrokingDeviceCMYKColor());
        this.addOperator((OperatorProcessor)new SetNonStrokingDeviceRGBColor());
        this.addOperator((OperatorProcessor)new SetStrokingDeviceRGBColor());
        this.addOperator((OperatorProcessor)new SetNonStrokingDeviceGrayColor());
        this.addOperator((OperatorProcessor)new SetStrokingDeviceGrayColor());
        this.addOperator((OperatorProcessor)new SetStrokingColor());
        this.addOperator((OperatorProcessor)new SetStrokingColorN());
        this.addOperator((OperatorProcessor)new SetNonStrokingColor());
        this.addOperator((OperatorProcessor)new SetNonStrokingColorN());
        this.addOperator((OperatorProcessor)new Restore());
        this.addOperator((OperatorProcessor)new Save());
        this.addOperator((OperatorProcessor)new BeginText());
        this.addOperator((OperatorProcessor)new EndText());
        this.addOperator((OperatorProcessor)new SetGraphicsStateParameters());
        this.addOperator((OperatorProcessor)new SetFontAndSize());
        this.addOperator((OperatorProcessor)new SetTextRenderingMode());
        this.addOperator((OperatorProcessor)new SetMatrix());
        this.addOperator((OperatorProcessor)new MoveText());
        this.addOperator((OperatorProcessor)new NextLine());
        this.addOperator((OperatorProcessor)new MoveTextSetLeading());
        this.addOperator((OperatorProcessor)new SetCharSpacing());
        this.addOperator((OperatorProcessor)new SetTextLeading());
        this.addOperator((OperatorProcessor)new SetTextRise());
        this.addOperator((OperatorProcessor)new SetWordSpacing());
        this.addOperator((OperatorProcessor)new SetTextHorizontalScaling());
        this.addOperator(new StubOperator("l"));
        this.addOperator(new StubOperator("re"));
        this.addOperator(new StubOperator("c"));
        this.addOperator(new StubOperator("y"));
        this.addOperator(new StubOperator("v"));
        this.addOperator(new StubOperator("n"));
        this.addOperator(new StubOperator("BI"));
        this.addOperator(new StubOperator("ID"));
        this.addOperator(new StubOperator("EI"));
        this.addOperator(new StubOperator("m"));
        this.addOperator(new StubOperator("W*"));
        this.addOperator(new StubOperator("W"));
        this.addOperator(new StubOperator("h"));
        this.addOperator(new StubOperator("Tj"));
        this.addOperator(new StubOperator("TJ"));
        this.addOperator(new StubOperator("'"));
        this.addOperator(new StubOperator("\""));
        this.addOperator(new StubOperator("b"));
        this.addOperator(new StubOperator("B"));
        this.addOperator(new StubOperator("b*"));
        this.addOperator(new StubOperator("B*"));
        this.addOperator(new StubOperator("BDC"));
        this.addOperator(new StubOperator("BMC"));
        this.addOperator(new StubOperator("DP"));
        this.addOperator(new StubOperator("EMC"));
        this.addOperator(new StubOperator("BX"));
        this.addOperator(new StubOperator("EX"));
        this.addOperator(new StubOperator("d0"));
        this.addOperator(new StubOperator("d1"));
        this.addOperator(new StubOperator("f"));
        this.addOperator(new StubOperator("F"));
        this.addOperator(new StubOperator("f*"));
        this.addOperator(new StubOperator("M"));
        this.addOperator(new StubOperator("MP"));
        this.addOperator(new StubOperator("i"));
        this.addOperator(new StubOperator("ri"));
        this.addOperator(new StubOperator("s"));
        this.addOperator(new StubOperator("S"));
        this.addOperator(new StubOperator("sh"));
    }

    protected void validateRenderingIntent(Operator operator, List<COSBase> arguments) throws ContentStreamException {
        if ("ri".equals(operator.getName())) {
            String riArgument0 = "";
            if (arguments.get(0) instanceof COSName) {
                riArgument0 = ((COSName)arguments.get(0)).getName();
            }
            if (!RenderingIntents.contains(riArgument0)) {
                this.registerError("Unexpected value '" + arguments.get(0) + "' for ri operand. ", "2.3.2");
            }
        }
    }

    protected void validateNumberOfGraphicStates(Operator operator) throws ContentStreamException {
        int numberOfGraphicStates;
        if ("q".equals(operator.getName()) && (numberOfGraphicStates = this.getGraphicsStackSize()) > 28) {
            this.registerError("Too many graphic states", "2.1.8");
        }
    }

    protected void validateInlineImageFilter(Operator operator) throws ContentStreamException {
        COSDictionary dict = operator.getImageParameters();
        COSBase filter = dict.getDictionaryObject(COSName.F, COSName.FILTER);
        FilterHelper.isAuthorizedFilter(this.context, COSUtils.getAsString(filter, this.context.getDocument().getDocument()));
    }

    protected void validateInlineImageColorSpace(Operator operator) throws IOException {
        COSDictionary dict = operator.getImageParameters();
        COSBase csInlinedBase = dict.getDictionaryObject(COSName.CS, COSName.COLORSPACE);
        ColorSpaceHelper csHelper = null;
        if (csInlinedBase != null) {
            if (COSUtils.isString(csInlinedBase, this.cosDocument)) {
                ColorSpaces cs;
                String colorSpace;
                block7: {
                    colorSpace = COSUtils.getAsString(csInlinedBase, this.cosDocument);
                    cs = null;
                    try {
                        cs = ColorSpaces.valueOf(colorSpace);
                    }
                    catch (IllegalArgumentException e) {
                        PDColorSpace pdCS = this.getResources().getColorSpace(COSName.getPDFName((String)colorSpace));
                        if (pdCS == null) break block7;
                        cs = ColorSpaces.valueOf(pdCS.getName());
                        csHelper = this.getColorSpaceHelper(pdCS);
                    }
                }
                if (cs == null) {
                    this.registerError("The ColorSpace " + colorSpace + " is unknown", "2.3.2");
                    return;
                }
            }
            if (csHelper == null) {
                COSArray srcArray;
                COSBase csType;
                if ((csInlinedBase = this.toLongName(csInlinedBase)) instanceof COSArray && ((COSArray)csInlinedBase).size() > 1 && (COSName.I.equals((Object)(csType = (srcArray = (COSArray)csInlinedBase).get(0))) || COSName.INDEXED.equals((Object)csType))) {
                    COSArray dstArray = new COSArray();
                    dstArray.addAll(srcArray);
                    dstArray.set(0, (COSBase)COSName.INDEXED);
                    dstArray.set(1, this.toLongName(srcArray.get(1)));
                    csInlinedBase = dstArray;
                }
                PDColorSpace pdCS = PDColorSpace.create((COSBase)csInlinedBase);
                csHelper = this.getColorSpaceHelper(pdCS);
            }
            csHelper.validate();
        }
    }

    private ColorSpaceHelper getColorSpaceHelper(PDColorSpace pdCS) {
        PreflightConfiguration cfg = this.context.getConfig();
        ColorSpaceHelperFactory csFact = cfg.getColorSpaceHelperFact();
        return csFact.getColorSpaceHelper(this.context, pdCS, ColorSpaceHelperFactory.ColorSpaceRestriction.ONLY_DEVICE);
    }

    private COSBase toLongName(COSBase cs) {
        if (COSName.RGB.equals((Object)cs)) {
            return COSName.DEVICERGB;
        }
        if (COSName.CMYK.equals((Object)cs)) {
            return COSName.DEVICECMYK;
        }
        if (COSName.G.equals((Object)cs)) {
            return COSName.DEVICEGRAY;
        }
        return cs;
    }

    protected void checkColorOperators(String operation) throws ContentStreamException {
        PDColorSpace cs = this.getColorSpace(operation);
        if (("rg".equals(operation) || "RG".equals(operation)) && !this.validColorSpace(cs, ColorSpaceType.RGB)) {
            this.registerError("The operator \"" + operation + "\" can't be used with CMYK Profile", "2.4.1");
            return;
        }
        if (("k".equals(operation) || "K".equals(operation)) && !this.validColorSpace(cs, ColorSpaceType.CMYK)) {
            this.registerError("The operator \"" + operation + "\" can't be used with RGB Profile", "2.4.2");
            return;
        }
        if (("g".equals(operation) || "G".equals(operation) || "f".equals(operation) || "F".equals(operation) || "f*".equals(operation) || "B".equals(operation) || "B*".equals(operation) || "b".equals(operation) || "b*".equals(operation)) && !this.validColorSpace(cs, ColorSpaceType.ALL)) {
            this.registerError("The operator \"" + operation + "\" can't be used without Color Profile", "2.4.3");
        }
    }

    private boolean validColorSpace(PDColorSpace colorSpace, ColorSpaceType expectedIccType) throws ContentStreamException {
        if (colorSpace == null) {
            return this.validColorSpaceDestOutputProfile(expectedIccType);
        }
        return this.isDeviceIndependent(colorSpace, expectedIccType) || this.validColorSpaceDestOutputProfile(expectedIccType);
    }

    private boolean validColorSpaceDestOutputProfile(ColorSpaceType expectedType) throws ContentStreamException {
        boolean result = false;
        try {
            ICCProfileWrapper profileWrapper = ICCProfileWrapper.getOrSearchICCProfile(this.context);
            if (profileWrapper != null) {
                switch (expectedType) {
                    case RGB: {
                        result = profileWrapper.isRGBColorSpace();
                        break;
                    }
                    case CMYK: {
                        result = profileWrapper.isCMYKColorSpace();
                        break;
                    }
                    default: {
                        result = true;
                    }
                }
            }
        }
        catch (ValidationException e) {
            throw new ContentStreamException(e);
        }
        return result;
    }

    private boolean isDeviceIndependent(PDColorSpace cs, ColorSpaceType expectedIccType) {
        if (cs instanceof PDICCBased) {
            int type = ((PDICCBased)cs).getColorSpaceType();
            switch (expectedIccType) {
                case RGB: {
                    return type == 5;
                }
                case CMYK: {
                    return type == 9;
                }
            }
            return true;
        }
        if (cs instanceof PDSeparation) {
            return this.isDeviceIndependent(((PDSeparation)cs).getAlternateColorSpace(), expectedIccType);
        }
        return cs instanceof PDCIEBasedColorSpace;
    }

    private PDColorSpace getColorSpace(String operation) {
        if (this.getGraphicsState() == null) {
            return null;
        }
        if (operation.equals("rg") || operation.equals("g") || operation.equals("k") || operation.equals("f") || operation.equals("F") || operation.equals("f*")) {
            return this.getGraphicsState().getNonStrokingColorSpace();
        }
        return this.getGraphicsState().getStrokingColorSpace();
    }

    protected void checkSetColorSpaceOperators(Operator operator, List<COSBase> arguments) throws IOException {
        ColorSpaces cs;
        ColorSpaceHelper csHelper;
        String colorSpaceName;
        block9: {
            if (!"CS".equals(operator.getName()) && !"cs".equals(operator.getName())) {
                return;
            }
            if (arguments.get(0) instanceof COSString) {
                colorSpaceName = arguments.get(0).toString();
            } else if (arguments.get(0) instanceof COSName) {
                colorSpaceName = ((COSName)arguments.get(0)).getName();
            } else {
                this.registerError("The operand " + arguments.get(0) + " for colorSpace operator " + operator.getName() + " doesn't have the expected type", "2.3.2");
                return;
            }
            csHelper = null;
            cs = null;
            try {
                cs = ColorSpaces.valueOf(colorSpaceName);
            }
            catch (IllegalArgumentException e) {
                PDColorSpace pdCS = this.getResources().getColorSpace(COSName.getPDFName((String)colorSpaceName));
                if (pdCS == null) break block9;
                cs = ColorSpaces.valueOf(pdCS.getName());
                PreflightConfiguration cfg = this.context.getConfig();
                ColorSpaceHelperFactory csFact = cfg.getColorSpaceHelperFact();
                csHelper = csFact.getColorSpaceHelper(this.context, pdCS, ColorSpaceHelperFactory.ColorSpaceRestriction.NO_RESTRICTION);
            }
        }
        if (cs == null) {
            this.registerError("The ColorSpace " + colorSpaceName + " is unknown", "2.3.2");
            return;
        }
        if (csHelper == null) {
            PDColorSpace pdCS = PDColorSpace.create((COSBase)COSName.getPDFName((String)colorSpaceName));
            PreflightConfiguration cfg = this.context.getConfig();
            ColorSpaceHelperFactory csFact = cfg.getColorSpaceHelperFact();
            csHelper = csFact.getColorSpaceHelper(this.context, pdCS, ColorSpaceHelperFactory.ColorSpaceRestriction.NO_RESTRICTION);
        }
        csHelper.validate();
    }

    protected void registerError(String msg, String errorCode) {
        this.registerError(msg, errorCode, null);
    }

    public void registerError(String msg, String errorCode, Throwable cause) {
        this.registerError(msg, errorCode, false, cause);
    }

    protected void registerError(String msg, String errorCode, boolean warning) {
        this.registerError(msg, errorCode, warning, null);
    }

    public void registerError(String msg, String errorCode, boolean warning, Throwable cause) {
        ValidationResult.ValidationError error = new ValidationResult.ValidationError(errorCode, msg, cause);
        error.setWarning(warning);
        this.context.addValidationError(error);
    }

    private static enum ColorSpaceType {
        RGB,
        CMYK,
        ALL;

    }
}

