/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.metadata;

import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.exception.ValidationException;
import org.apache.xmpbox.XMPMetadata;
import org.apache.xmpbox.schema.XMPSchema;
import org.apache.xmpbox.type.AbstractField;

public class UniquePropertiesValidation {
    public List<ValidationResult.ValidationError> validatePropertiesUniqueness(PDDocument document, XMPMetadata metadata) throws ValidationException {
        ArrayList<ValidationResult.ValidationError> ve = new ArrayList<ValidationResult.ValidationError>();
        if (document == null) {
            throw new ValidationException("Document provided is null");
        }
        UniquePropertiesValidation.analyzePropertyUniqueness((XMPSchema)metadata.getDublinCoreSchema(), "creator", ve);
        UniquePropertiesValidation.analyzePropertyUniqueness((XMPSchema)metadata.getDublinCoreSchema(), "title", ve);
        UniquePropertiesValidation.analyzePropertyUniqueness((XMPSchema)metadata.getDublinCoreSchema(), "description", ve);
        UniquePropertiesValidation.analyzePropertyUniqueness((XMPSchema)metadata.getAdobePDFSchema(), "Producer", ve);
        UniquePropertiesValidation.analyzePropertyUniqueness((XMPSchema)metadata.getAdobePDFSchema(), "Keywords", ve);
        UniquePropertiesValidation.analyzePropertyUniqueness((XMPSchema)metadata.getXMPBasicSchema(), "CreatorTool", ve);
        UniquePropertiesValidation.analyzePropertyUniqueness((XMPSchema)metadata.getXMPBasicSchema(), "CreateDate", ve);
        UniquePropertiesValidation.analyzePropertyUniqueness((XMPSchema)metadata.getXMPBasicSchema(), "ModifyDate", ve);
        return ve;
    }

    private static void analyzePropertyUniqueness(XMPSchema schema, String propertyName, List<ValidationResult.ValidationError> ve) {
        if (schema == null) {
            return;
        }
        int count = 0;
        for (AbstractField field : schema.getAllProperties()) {
            if (!propertyName.equals(field.getPropertyName())) continue;
            ++count;
        }
        if (count > 1) {
            ve.add(new ValidationResult.ValidationError("7.1.2", "property '" + schema.getPrefix() + ":" + propertyName + "' occurs multiple times"));
        }
    }
}

