/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.font.container;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.fontbox.ttf.CMAPEncodingEntry;
import org.apache.fontbox.ttf.CMAPTable;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.apache.pdfbox.encoding.Encoding;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.preflight.font.container.FontContainer;

public class TrueTypeContainer
extends FontContainer {
    protected TrueTypeFont ttFont;
    private CMAPEncodingEntry[] cmapEncodingEntries = null;

    public TrueTypeContainer(PDFont font) {
        super(font);
    }

    public void setTrueTypeFont(TrueTypeFont ttFont) {
        this.ttFont = ttFont;
        this.initCMapEncodingEntries();
    }

    protected void initCMapEncodingEntries() {
        if (this.cmapEncodingEntries != null) {
            return;
        }
        CMAPTable cmap = this.ttFont.getCMAP();
        this.cmapEncodingEntries = this.font.getFontDescriptor().isSymbolic() ? cmap.getCmaps() : this.orderCMapEntries(cmap);
    }

    private CMAPEncodingEntry[] orderCMapEntries(CMAPTable cmap) {
        ArrayList<CMAPEncodingEntry> res = new ArrayList<CMAPEncodingEntry>();
        boolean firstIs31 = false;
        for (CMAPEncodingEntry cmapEntry : cmap.getCmaps()) {
            if (cmapEntry.getPlatformId() == 3 && cmapEntry.getPlatformEncodingId() == 1) {
                res.add(0, cmapEntry);
                firstIs31 = true;
                continue;
            }
            if (cmapEntry.getPlatformId() == 1 && cmapEntry.getPlatformEncodingId() == 0) {
                if (firstIs31) {
                    res.add(1, cmapEntry);
                    continue;
                }
                res.add(0, cmapEntry);
                continue;
            }
            res.add(cmapEntry);
        }
        return res.toArray(new CMAPEncodingEntry[res.size()]);
    }

    protected float getFontProgramWidth(int cid) {
        float result = -1.0f;
        if (this.cmapEncodingEntries != null) {
            for (CMAPEncodingEntry entry : this.cmapEncodingEntries) {
                int glyphID = this.extractGlyphID(cid, entry);
                if (glyphID <= 0) continue;
                result = this.extractGlyphWidth(glyphID);
                break;
            }
        }
        return result;
    }

    private int extractGlyphID(int cid, CMAPEncodingEntry cmap) {
        int notFoundGlyphID = 0;
        int innerFontCid = cid;
        if (cmap.getPlatformEncodingId() == 1 && cmap.getPlatformId() == 3) {
            try {
                Encoding fontEncoding = this.font.getFontEncoding();
                String character = fontEncoding.getCharacter(cid);
                if (character == null) {
                    return notFoundGlyphID;
                }
                char[] characterArray = character.toCharArray();
                if (characterArray.length == 1) {
                    innerFontCid = characterArray[0];
                } else {
                    innerFontCid = characterArray[0];
                    for (int i = 1; i < characterArray.length; ++i) {
                        if (cmap.getGlyphId((int)characterArray[i]) != 0) continue;
                        return notFoundGlyphID;
                    }
                }
            }
            catch (IOException ioe) {
                return notFoundGlyphID;
            }
        }
        return cmap.getGlyphId(innerFontCid);
    }

    private float extractGlyphWidth(int glyphID) {
        int unitsPerEm = this.ttFont.getHeader().getUnitsPerEm();
        int[] glyphWidths = this.ttFont.getHorizontalMetrics().getAdvanceWidth();
        int numberOfLongHorMetrics = this.ttFont.getHorizontalHeader().getNumberOfHMetrics();
        float glypdWidth = glyphWidths[numberOfLongHorMetrics - 1];
        if (glyphID < numberOfLongHorMetrics) {
            glypdWidth = glyphWidths[glyphID];
        }
        return glypdWidth * 1000.0f / (float)unitsPerEm;
    }
}

