/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.graphic;

import java.io.IOException;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDIndexed;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.graphic.ColorSpaces;
import org.apache.pdfbox.preflight.graphic.StandardColorSpaceHelper;

public class DeviceColorSpaceHelper
extends StandardColorSpaceHelper {
    public DeviceColorSpaceHelper(PreflightContext _context, PDColorSpace _cs) {
        super(_context, _cs);
    }

    protected void processPatternColorSpace(PDColorSpace pdcs) {
        this.context.addValidationError(new ValidationResult.ValidationError("2.4.9", "Pattern ColorSpace is forbidden"));
    }

    protected void processDeviceNColorSpace(PDColorSpace pdcs) {
        this.context.addValidationError(new ValidationResult.ValidationError("2.4.9", "DeviceN ColorSpace is forbidden"));
    }

    protected void processIndexedColorSpace(PDColorSpace pdcs) {
        PDIndexed indexed = (PDIndexed)pdcs;
        try {
            PDColorSpace based = indexed.getBaseColorSpace();
            ColorSpaces colorSpace = ColorSpaces.valueOf(based.getName());
            switch (colorSpace) {
                case Indexed: 
                case Pattern: {
                    this.context.addValidationError(new ValidationResult.ValidationError("2.4.9", colorSpace.getLabel() + " ColorSpace is forbidden"));
                    break;
                }
                default: {
                    this.processAllColorSpace(based);
                    break;
                }
            }
        }
        catch (IOException e) {
            this.context.addValidationError(new ValidationResult.ValidationError("2.4", "Unable to read Indexed Color Space : " + e.getMessage()));
        }
    }
}

