/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.process;

import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDDocumentOutline;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDOutlineItem;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.exception.ValidationException;
import org.apache.pdfbox.preflight.process.AbstractProcess;
import org.apache.pdfbox.preflight.utils.COSUtils;
import org.apache.pdfbox.preflight.utils.ContextHelper;

public class BookmarkValidationProcess
extends AbstractProcess {
    public void validate(PreflightContext ctx) throws ValidationException {
        PDDocumentCatalog catalog = ctx.getDocument().getDocumentCatalog();
        if (catalog != null) {
            PDDocumentOutline outlineHierarchy = catalog.getDocumentOutline();
            if (outlineHierarchy != null) {
                if (!(this.isCountEntryPresent(outlineHierarchy.getCOSDictionary()) || outlineHierarchy.getFirstChild() == null && outlineHierarchy.getLastChild() == null)) {
                    this.addValidationError(ctx, new ValidationResult.ValidationError("1.4.9", "Outline Hierarchy doesn't have Count entry"));
                } else if (this.isCountEntryPositive(ctx, outlineHierarchy.getCOSDictionary()) && (outlineHierarchy.getFirstChild() == null || outlineHierarchy.getLastChild() == null)) {
                    this.addValidationError(ctx, new ValidationResult.ValidationError("1.4.9", "Outline Hierarchy doesn't have First and/or Last entry(ies)"));
                } else {
                    this.exploreOutlineLevel(ctx, outlineHierarchy.getFirstChild());
                }
            }
        } else {
            ctx.addValidationError(new ValidationResult.ValidationError("1.2.14", "There are no Catalog entry in the Document."));
        }
    }

    private boolean isCountEntryPresent(COSDictionary outline) {
        return outline.getItem(COSName.getPDFName((String)"Count")) != null;
    }

    private boolean isCountEntryPositive(PreflightContext ctx, COSDictionary outline) {
        COSDocument cosDocument;
        COSBase countBase = outline.getItem(COSName.getPDFName((String)"Count"));
        return COSUtils.isInteger(countBase, cosDocument = ctx.getDocument().getDocument()) && COSUtils.getAsInteger(countBase, cosDocument) > 0;
    }

    protected boolean exploreOutlineLevel(PreflightContext ctx, PDOutlineItem inputItem) throws ValidationException {
        for (PDOutlineItem currentItem = inputItem; currentItem != null; currentItem = currentItem.getNextSibling()) {
            if (this.validateItem(ctx, currentItem)) continue;
            return false;
        }
        return true;
    }

    protected boolean validateItem(PreflightContext ctx, PDOutlineItem inputItem) throws ValidationException {
        PDOutlineItem fChild;
        boolean isValid = true;
        COSDictionary dictionary = inputItem.getCOSDictionary();
        COSBase dest = dictionary.getItem(COSName.DEST);
        COSBase action = dictionary.getItem(COSName.A);
        if (action != null && dest != null) {
            this.addValidationError(ctx, new ValidationResult.ValidationError("1.4.9", "Dest entry isn't permitted if the A entry is present"));
            return false;
        }
        if (action != null) {
            ContextHelper.validateElement(ctx, dictionary, "actions-process");
        }
        if ((fChild = inputItem.getFirstChild()) != null) {
            if (!this.isCountEntryPresent(inputItem.getCOSDictionary())) {
                this.addValidationError(ctx, new ValidationResult.ValidationError("1.4.9", "Outline item doesn't have Count entry but has at least one descendant."));
                isValid = false;
            } else {
                isValid = isValid && this.exploreOutlineLevel(ctx, fChild);
            }
        }
        return isValid;
    }
}

