/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.process.reflect;

import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.PreflightPath;
import org.apache.pdfbox.preflight.exception.ValidationException;
import org.apache.pdfbox.preflight.font.FontValidator;
import org.apache.pdfbox.preflight.font.TrueTypeFontValidator;
import org.apache.pdfbox.preflight.font.Type0FontValidator;
import org.apache.pdfbox.preflight.font.Type1FontValidator;
import org.apache.pdfbox.preflight.font.Type3FontValidator;
import org.apache.pdfbox.preflight.font.container.FontContainer;
import org.apache.pdfbox.preflight.process.AbstractProcess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FontValidationProcess
extends AbstractProcess {
    @Override
    public void validate(PreflightContext context) throws ValidationException {
        PreflightPath vPath = context.getValidationPath();
        if (vPath.isEmpty() || !vPath.isExpectedType(PDFont.class)) {
            throw new ValidationException("Font validation process needs at least one PDFont object");
        }
        PDFont font = (PDFont)vPath.peek();
        FontContainer fontContainer = context.getFontContainer(font.getCOSObject());
        if (fontContainer == null) {
            FontValidator<? extends FontContainer> validator = this.getFontValidator(context, font);
            validator.validate();
        }
    }

    protected FontValidator<? extends FontContainer> getFontValidator(PreflightContext context, PDFont font) throws ValidationException {
        String subtype = font.getSubType();
        if ("TrueType".equals(subtype)) {
            return new TrueTypeFontValidator(context, font);
        }
        if ("MMType1".equals(subtype) || "Type1".equals(subtype)) {
            return new Type1FontValidator(context, font);
        }
        if ("Type3".equals(subtype)) {
            return new Type3FontValidator(context, font);
        }
        if ("Type0".equals(subtype)) {
            return new Type0FontValidator(context, font);
        }
        if ("CIDFontType2".equals(subtype) || "Type1C".equals(subtype) || "CIDFontType0C".equals(subtype) || "CIDFontType0".equals(subtype)) {
            return null;
        }
        throw new ValidationException("Unknown font type : " + subtype);
    }
}

