/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.content;

import java.awt.color.ColorSpace;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.graphics.color.PDCalGray;
import org.apache.pdfbox.pdmodel.graphics.color.PDCalRGB;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpaceFactory;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorState;
import org.apache.pdfbox.pdmodel.graphics.color.PDICCBased;
import org.apache.pdfbox.pdmodel.graphics.color.PDLab;
import org.apache.pdfbox.preflight.PreflightConfiguration;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.content.ContentStreamException;
import org.apache.pdfbox.preflight.content.StubOperator;
import org.apache.pdfbox.preflight.exception.ValidationException;
import org.apache.pdfbox.preflight.graphic.ColorSpaceHelper;
import org.apache.pdfbox.preflight.graphic.ColorSpaceHelperFactory;
import org.apache.pdfbox.preflight.graphic.ColorSpaces;
import org.apache.pdfbox.preflight.graphic.ICCProfileWrapper;
import org.apache.pdfbox.preflight.utils.COSUtils;
import org.apache.pdfbox.preflight.utils.FilterHelper;
import org.apache.pdfbox.preflight.utils.RenderingIntents;
import org.apache.pdfbox.util.PDFOperator;
import org.apache.pdfbox.util.PDFStreamEngine;
import org.apache.pdfbox.util.operator.BeginText;
import org.apache.pdfbox.util.operator.Concatenate;
import org.apache.pdfbox.util.operator.EndText;
import org.apache.pdfbox.util.operator.GRestore;
import org.apache.pdfbox.util.operator.GSave;
import org.apache.pdfbox.util.operator.Invoke;
import org.apache.pdfbox.util.operator.MoveText;
import org.apache.pdfbox.util.operator.MoveTextSetLeading;
import org.apache.pdfbox.util.operator.NextLine;
import org.apache.pdfbox.util.operator.OperatorProcessor;
import org.apache.pdfbox.util.operator.SetCharSpacing;
import org.apache.pdfbox.util.operator.SetHorizontalTextScaling;
import org.apache.pdfbox.util.operator.SetLineCapStyle;
import org.apache.pdfbox.util.operator.SetLineDashPattern;
import org.apache.pdfbox.util.operator.SetLineJoinStyle;
import org.apache.pdfbox.util.operator.SetLineWidth;
import org.apache.pdfbox.util.operator.SetMatrix;
import org.apache.pdfbox.util.operator.SetNonStrokingCMYKColor;
import org.apache.pdfbox.util.operator.SetNonStrokingColor;
import org.apache.pdfbox.util.operator.SetNonStrokingColorSpace;
import org.apache.pdfbox.util.operator.SetNonStrokingRGBColor;
import org.apache.pdfbox.util.operator.SetStrokingCMYKColor;
import org.apache.pdfbox.util.operator.SetStrokingColor;
import org.apache.pdfbox.util.operator.SetStrokingColorSpace;
import org.apache.pdfbox.util.operator.SetStrokingRGBColor;
import org.apache.pdfbox.util.operator.SetTextFont;
import org.apache.pdfbox.util.operator.SetTextLeading;
import org.apache.pdfbox.util.operator.SetTextRenderingMode;
import org.apache.pdfbox.util.operator.SetTextRise;
import org.apache.pdfbox.util.operator.SetWordSpacing;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ContentStreamEngine
extends PDFStreamEngine {
    protected PreflightContext context = null;
    protected COSDocument cosDocument = null;
    protected PDPage processeedPage = null;
    protected Map<String, OperatorProcessor> contentStreamEngineOperators = new HashMap<String, OperatorProcessor>();

    public ContentStreamEngine(PreflightContext _context, PDPage _page) {
        this.context = _context;
        this.cosDocument = _context.getDocument().getDocument();
        this.processeedPage = _page;
        this.registerOperatorProcessor("w", (OperatorProcessor)new SetLineWidth());
        this.registerOperatorProcessor("cm", (OperatorProcessor)new Concatenate());
        this.registerOperatorProcessor("CS", (OperatorProcessor)new SetStrokingColorSpace());
        this.registerOperatorProcessor("cs", (OperatorProcessor)new SetNonStrokingColorSpace());
        this.registerOperatorProcessor("d", (OperatorProcessor)new SetLineDashPattern());
        this.registerOperatorProcessor("Do", (OperatorProcessor)new Invoke());
        this.registerOperatorProcessor("j", (OperatorProcessor)new SetLineJoinStyle());
        this.registerOperatorProcessor("J", (OperatorProcessor)new SetLineCapStyle());
        this.registerOperatorProcessor("K", (OperatorProcessor)new SetStrokingCMYKColor());
        this.registerOperatorProcessor("k", (OperatorProcessor)new SetNonStrokingCMYKColor());
        this.registerOperatorProcessor("rg", (OperatorProcessor)new SetNonStrokingRGBColor());
        this.registerOperatorProcessor("RG", (OperatorProcessor)new SetStrokingRGBColor());
        this.registerOperatorProcessor("SC", (OperatorProcessor)new SetStrokingColor());
        this.registerOperatorProcessor("SCN", (OperatorProcessor)new SetStrokingColor());
        this.registerOperatorProcessor("sc", (OperatorProcessor)new SetNonStrokingColor());
        this.registerOperatorProcessor("scn", (OperatorProcessor)new SetNonStrokingColor());
        this.registerOperatorProcessor("Q", (OperatorProcessor)new GRestore());
        this.registerOperatorProcessor("q", (OperatorProcessor)new GSave());
        this.registerOperatorProcessor("BT", (OperatorProcessor)new BeginText());
        this.registerOperatorProcessor("ET", (OperatorProcessor)new EndText());
        this.registerOperatorProcessor("Tf", (OperatorProcessor)new SetTextFont());
        this.registerOperatorProcessor("Tr", (OperatorProcessor)new SetTextRenderingMode());
        this.registerOperatorProcessor("Tm", (OperatorProcessor)new SetMatrix());
        this.registerOperatorProcessor("Td", (OperatorProcessor)new MoveText());
        this.registerOperatorProcessor("T*", (OperatorProcessor)new NextLine());
        this.registerOperatorProcessor("TD", (OperatorProcessor)new MoveTextSetLeading());
        this.registerOperatorProcessor("Tc", (OperatorProcessor)new SetCharSpacing());
        this.registerOperatorProcessor("TL", (OperatorProcessor)new SetTextLeading());
        this.registerOperatorProcessor("Ts", (OperatorProcessor)new SetTextRise());
        this.registerOperatorProcessor("Tw", (OperatorProcessor)new SetWordSpacing());
        this.registerOperatorProcessor("Tz", (OperatorProcessor)new SetHorizontalTextScaling());
        StubOperator stubOp = new StubOperator();
        this.registerOperatorProcessor("l", stubOp);
        this.registerOperatorProcessor("re", stubOp);
        this.registerOperatorProcessor("c", stubOp);
        this.registerOperatorProcessor("y", stubOp);
        this.registerOperatorProcessor("v", stubOp);
        this.registerOperatorProcessor("n", stubOp);
        this.registerOperatorProcessor("BI", stubOp);
        this.registerOperatorProcessor("EI", stubOp);
        this.registerOperatorProcessor("m", stubOp);
        this.registerOperatorProcessor("W*", stubOp);
        this.registerOperatorProcessor("W", stubOp);
        this.registerOperatorProcessor("h", stubOp);
        this.registerOperatorProcessor("Tj", stubOp);
        this.registerOperatorProcessor("TJ", stubOp);
        this.registerOperatorProcessor("'", stubOp);
        this.registerOperatorProcessor("\"", stubOp);
        this.registerOperatorProcessor("b", stubOp);
        this.registerOperatorProcessor("B", stubOp);
        this.registerOperatorProcessor("b*", stubOp);
        this.registerOperatorProcessor("B*", stubOp);
        this.registerOperatorProcessor("BDC", stubOp);
        this.registerOperatorProcessor("BMC", stubOp);
        this.registerOperatorProcessor("DP", stubOp);
        this.registerOperatorProcessor("EMC", stubOp);
        this.registerOperatorProcessor("d0", stubOp);
        this.registerOperatorProcessor("d1", stubOp);
        this.registerOperatorProcessor("f", stubOp);
        this.registerOperatorProcessor("F", stubOp);
        this.registerOperatorProcessor("f*", stubOp);
        this.registerOperatorProcessor("g", stubOp);
        this.registerOperatorProcessor("G", stubOp);
        this.registerOperatorProcessor("M", stubOp);
        this.registerOperatorProcessor("MP", stubOp);
        this.registerOperatorProcessor("gs", stubOp);
        this.registerOperatorProcessor("h", stubOp);
        this.registerOperatorProcessor("i", stubOp);
        this.registerOperatorProcessor("ri", stubOp);
        this.registerOperatorProcessor("s", stubOp);
        this.registerOperatorProcessor("S", stubOp);
        this.registerOperatorProcessor("sh", stubOp);
    }

    public final void registerOperatorProcessor(String operator, OperatorProcessor op) {
        super.registerOperatorProcessor(operator, op);
        this.contentStreamEngineOperators.put(operator, op);
    }

    protected void validRenderingIntent(PDFOperator operator, List arguments) throws ContentStreamException {
        if ("ri".equals(operator.getOperation())) {
            String riArgument0 = "";
            if (arguments.get(0) instanceof COSName) {
                riArgument0 = ((COSName)arguments.get(0)).getName();
            } else if (arguments.get(0) instanceof String) {
                riArgument0 = (String)arguments.get(0);
            }
            if (!RenderingIntents.contains(riArgument0)) {
                this.registerError("Unexpected value '" + arguments.get(0) + "' for ri operand. ", "2.3.2");
                return;
            }
        }
    }

    protected void validNumberOfGraphicStates(PDFOperator operator) throws ContentStreamException {
        int numberOfGraphicStates;
        if ("q".equals(operator.getOperation()) && (numberOfGraphicStates = this.getGraphicsStack().size()) > 28) {
            this.registerError("Too many graphic states", "2.1.8");
            return;
        }
    }

    protected void validImageFilter(PDFOperator operator) throws ContentStreamException {
        COSDictionary dict = operator.getImageParameters().getDictionary();
        COSBase filter = dict.getDictionaryObject(COSName.F, COSName.FILTER);
        FilterHelper.isAuthorizedFilter(this.context, COSUtils.getAsString(filter, this.context.getDocument().getDocument()));
    }

    protected void validImageColorSpace(PDFOperator operator) throws ContentStreamException, IOException {
        COSDictionary dict = operator.getImageParameters().getDictionary();
        COSBase csInlinedBase = dict.getItem(COSName.CS);
        ColorSpaceHelper csHelper = null;
        if (csInlinedBase != null) {
            if (COSUtils.isString(csInlinedBase, this.cosDocument)) {
                ColorSpaces cs;
                block6: {
                    String colorSpace = COSUtils.getAsString(csInlinedBase, this.cosDocument);
                    cs = null;
                    try {
                        cs = ColorSpaces.valueOf(colorSpace);
                    }
                    catch (IllegalArgumentException e) {
                        PDColorSpace pdCS = (PDColorSpace)this.getColorSpaces().get(colorSpace);
                        if (pdCS == null) break block6;
                        cs = ColorSpaces.valueOf(pdCS.getName());
                        PreflightConfiguration cfg = this.context.getConfig();
                        ColorSpaceHelperFactory csFact = cfg.getColorSpaceHelperFact();
                        csHelper = csFact.getColorSpaceHelper(this.context, pdCS, ColorSpaceHelperFactory.ColorSpaceRestriction.ONLY_DEVICE);
                    }
                }
                if (cs == null) {
                    this.registerError("The ColorSpace is unknown", "2.3.2");
                    return;
                }
            }
            if (csHelper == null) {
                PDColorSpace pdCS = PDColorSpaceFactory.createColorSpace((COSBase)csInlinedBase);
                PreflightConfiguration cfg = this.context.getConfig();
                ColorSpaceHelperFactory csFact = cfg.getColorSpaceHelperFact();
                csHelper = csFact.getColorSpaceHelper(this.context, pdCS, ColorSpaceHelperFactory.ColorSpaceRestriction.ONLY_DEVICE);
            }
            csHelper.validate();
        }
    }

    protected void checkColorOperators(String operation) throws ContentStreamException {
        PDColorState cs = this.getColorState(operation);
        if (("rg".equals(operation) || "RG".equals(operation)) && !this.validColorSpace(cs, ColorSpaceType.RGB)) {
            this.registerError("The operator \"" + operation + "\" can't be used with CMYK Profile", "2.4.1");
            return;
        }
        if (("k".equals(operation) || "K".equals(operation)) && !this.validColorSpace(cs, ColorSpaceType.CMYK)) {
            this.registerError("The operator \"" + operation + "\" can't be used with RGB Profile", "2.4.2");
            return;
        }
        if (("g".equals(operation) || "G".equals(operation)) && !this.validColorSpace(cs, ColorSpaceType.ALL)) {
            this.registerError("The operator \"" + operation + "\" can't be used without Color Profile", "2.4.3");
            return;
        }
        if (("f".equals(operation) || "F".equals(operation) || "f*".equals(operation) || "B".equals(operation) || "B*".equals(operation) || "b".equals(operation) || "b*".equals(operation)) && !this.validColorSpace(cs, ColorSpaceType.ALL)) {
            this.registerError("The operator \"" + operation + "\" can't be used without Color Profile", "2.4.3");
            return;
        }
    }

    private boolean validColorSpace(PDColorState colorState, ColorSpaceType expectedType) throws ContentStreamException {
        PDColorSpace cs;
        boolean result = true;
        result = colorState == null ? this.validColorSpaceDestOutputProfile(expectedType) : (this.isDeviceIndependent(cs = colorState.getColorSpace(), expectedType) ? true : this.validColorSpaceDestOutputProfile(expectedType));
        return result;
    }

    private boolean validColorSpaceDestOutputProfile(ColorSpaceType expectedType) throws ContentStreamException {
        boolean result = false;
        try {
            ICCProfileWrapper profileWrapper = ICCProfileWrapper.getOrSearchICCProfile(this.context);
            if (profileWrapper != null) {
                switch (expectedType) {
                    case RGB: {
                        result = profileWrapper.isRGBColorSpace();
                        break;
                    }
                    case CMYK: {
                        result = profileWrapper.isCMYKColorSpace();
                        break;
                    }
                    default: {
                        result = true;
                    }
                }
            }
        }
        catch (ValidationException e) {
            throw new ContentStreamException(e);
        }
        return result;
    }

    private boolean isDeviceIndependent(PDColorSpace cs, ColorSpaceType expectedType) {
        boolean result;
        boolean bl = result = cs instanceof PDCalGray || cs instanceof PDCalRGB || cs instanceof PDLab;
        if (cs instanceof PDICCBased) {
            PDICCBased iccBased = (PDICCBased)cs;
            try {
                ColorSpace iccColorSpace = iccBased.getJavaColorSpace();
                switch (expectedType) {
                    case RGB: {
                        result = iccColorSpace.getType() == 5;
                        break;
                    }
                    case CMYK: {
                        result = iccColorSpace.getType() == 9;
                        break;
                    }
                    default: {
                        result = true;
                        break;
                    }
                }
            }
            catch (IOException e) {
                result = false;
            }
        }
        return result;
    }

    private PDColorState getColorState(String operation) {
        if (this.getGraphicsState() == null) {
            return null;
        }
        PDColorState colorState = operation.equals("rg") || operation.equals("g") || operation.equals("k") || operation.equals("f") || operation.equals("F") || operation.equals("f*") ? this.getGraphicsState().getNonStrokingColor() : this.getGraphicsState().getStrokingColor();
        return colorState;
    }

    protected void checkSetColorSpaceOperators(PDFOperator operator, List<?> arguments) throws IOException {
        ColorSpaces cs;
        ColorSpaceHelper csHelper;
        String colorSpaceName;
        block11: {
            if (!"CS".equals(operator.getOperation()) && !"cs".equals(operator.getOperation())) {
                return;
            }
            colorSpaceName = null;
            if (arguments.get(0) instanceof String) {
                colorSpaceName = (String)arguments.get(0);
            } else if (arguments.get(0) instanceof COSString) {
                colorSpaceName = ((COSString)arguments.get(0)).toString();
            } else if (arguments.get(0) instanceof COSName) {
                colorSpaceName = ((COSName)arguments.get(0)).getName();
            } else {
                this.registerError("The operand doesn't have the expected type", "2.3.2");
                return;
            }
            csHelper = null;
            cs = null;
            try {
                cs = ColorSpaces.valueOf(colorSpaceName);
            }
            catch (IllegalArgumentException e) {
                PDColorSpace pdCS = (PDColorSpace)this.getColorSpaces().get(colorSpaceName);
                if (pdCS == null) break block11;
                cs = ColorSpaces.valueOf(pdCS.getName());
                PreflightConfiguration cfg = this.context.getConfig();
                ColorSpaceHelperFactory csFact = cfg.getColorSpaceHelperFact();
                csHelper = csFact.getColorSpaceHelper(this.context, pdCS, ColorSpaceHelperFactory.ColorSpaceRestriction.NO_RESTRICTION);
            }
        }
        if (cs == null) {
            this.registerError("The ColorSpace is unknown", "2.3.2");
            return;
        }
        if (csHelper == null) {
            PDColorSpace pdCS = PDColorSpaceFactory.createColorSpace((COSBase)COSName.getPDFName((String)colorSpaceName));
            PreflightConfiguration cfg = this.context.getConfig();
            ColorSpaceHelperFactory csFact = cfg.getColorSpaceHelperFact();
            csHelper = csFact.getColorSpaceHelper(this.context, pdCS, ColorSpaceHelperFactory.ColorSpaceRestriction.NO_RESTRICTION);
        }
        csHelper.validate();
    }

    protected void registerError(String msg, String errorCode) {
        ValidationResult.ValidationError error = new ValidationResult.ValidationError(errorCode, msg);
        this.context.addValidationError(error);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ColorSpaceType {
        RGB,
        CMYK,
        ALL;

    }
}

