/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.process.reflect;

import java.io.IOException;
import java.util.Map;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.graphics.pattern.PDTilingPatternResources;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObject;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.PreflightPath;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.exception.ValidationException;
import org.apache.pdfbox.preflight.process.AbstractProcess;
import org.apache.pdfbox.preflight.utils.COSUtils;
import org.apache.pdfbox.preflight.utils.ContextHelper;

public class ResourcesValidationProcess
extends AbstractProcess {
    public void validate(PreflightContext ctx) throws ValidationException {
        PreflightPath vPath = ctx.getValidationPath();
        if (vPath.isEmpty() && !vPath.isExpectedType(PDResources.class)) {
            throw new ValidationException("Resources validation process needs at least one PDResources object");
        }
        PDResources resources = (PDResources)vPath.peek();
        this.validateFonts(ctx, resources);
        this.validateExtGStates(ctx, resources);
        this.validateShadingPattern(ctx, resources);
        this.validateTilingPattern(ctx, resources);
        this.validateXObjects(ctx, resources);
    }

    protected void validateFonts(PreflightContext context, PDResources resources) throws ValidationException {
        Map mapOfFonts = resources.getFonts();
        if (mapOfFonts != null) {
            for (Map.Entry entry : mapOfFonts.entrySet()) {
                ContextHelper.validateElement(context, entry.getValue(), "font-process");
            }
        }
    }

    protected void validateExtGStates(PreflightContext context, PDResources resources) throws ValidationException {
        COSBase egsEntry = resources.getCOSDictionary().getItem("ExtGState");
        COSDocument cosDocument = context.getDocument().getDocument();
        COSDictionary extGState = COSUtils.getAsDictionary(egsEntry, cosDocument);
        if (egsEntry != null) {
            ContextHelper.validateElement(context, extGState, "extgstate-process");
        }
    }

    protected void validateShadingPattern(PreflightContext context, PDResources resources) throws ValidationException {
        try {
            Map shadingResources = resources.getShadings();
            if (shadingResources != null) {
                for (Map.Entry entry : shadingResources.entrySet()) {
                    ContextHelper.validateElement(context, entry.getValue(), "shadding-pattern-process");
                }
            }
        }
        catch (IOException e) {
            context.addValidationError(new ValidationResult.ValidationError("2.4.6", e.getMessage()));
        }
    }

    protected void validateTilingPattern(PreflightContext context, PDResources resources) throws ValidationException {
        try {
            Map patternResources = resources.getPatterns();
            if (patternResources != null) {
                for (Map.Entry entry : patternResources.entrySet()) {
                    if (!(entry.getValue() instanceof PDTilingPatternResources)) continue;
                    ContextHelper.validateElement(context, entry.getValue(), "tiling-pattern-process");
                }
            }
        }
        catch (IOException e) {
            context.addValidationError(new ValidationResult.ValidationError("2.4.6", e.getMessage()));
        }
    }

    protected void validateXObjects(PreflightContext context, PDResources resources) throws ValidationException {
        COSDocument cosDocument = context.getDocument().getDocument();
        COSDictionary mapOfXObj = COSUtils.getAsDictionary(resources.getCOSDictionary().getItem(COSName.XOBJECT), cosDocument);
        if (mapOfXObj != null) {
            for (Map.Entry entry : mapOfXObj.entrySet()) {
                COSBase xobj = (COSBase)entry.getValue();
                if (xobj == null || !COSUtils.isStream(xobj, cosDocument)) continue;
                try {
                    COSStream stream = COSUtils.getAsStream(xobj, cosDocument);
                    PDXObject pdXObject = PDXObject.createXObject((COSBase)stream);
                    if (pdXObject != null) {
                        ContextHelper.validateElement(context, pdXObject, "graphic-process");
                        continue;
                    }
                    ContextHelper.validateElement(context, stream, "graphic-process");
                }
                catch (IOException e) {
                    throw new ValidationException(e.getMessage(), e);
                }
            }
        }
    }
}

