/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.font.container;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.font.util.GlyphDetail;
import org.apache.pdfbox.preflight.font.util.GlyphException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FontContainer {
    protected List<ValidationResult.ValidationError> errorBuffer = new ArrayList<ValidationResult.ValidationError>();
    protected boolean embeddedFont = true;
    protected Map<Integer, GlyphDetail> computedCid = new HashMap<Integer, GlyphDetail>();
    protected boolean errorsAleadyMerged = false;
    protected PDFont font;

    public FontContainer(PDFont font) {
        this.font = font;
    }

    public void push(ValidationResult.ValidationError error) {
        this.errorBuffer.add(error);
    }

    public void push(List<ValidationResult.ValidationError> errors) {
        this.errorBuffer.addAll(errors);
    }

    public List<ValidationResult.ValidationError> getAllErrors() {
        return this.errorBuffer;
    }

    public boolean isValid() {
        return this.errorBuffer.isEmpty() && this.isEmbeddedFont();
    }

    public boolean errorsAleadyMerged() {
        return this.errorsAleadyMerged;
    }

    public void setErrorsAleadyMerged(boolean errorsAleadyMerged) {
        this.errorsAleadyMerged = errorsAleadyMerged;
    }

    public boolean isEmbeddedFont() {
        return this.embeddedFont;
    }

    public void notEmbedded() {
        this.embeddedFont = false;
    }

    public void checkGlyphWith(int cid) throws GlyphException {
        if (this.isAlreadyComputedCid(cid)) {
            return;
        }
        float expectedWidth = this.font.getFontWidth(cid);
        float foundWidth = this.getFontProgramWidth(cid);
        this.checkWidthsConsistency(cid, expectedWidth, foundWidth);
    }

    protected boolean isAlreadyComputedCid(int cid) throws GlyphException {
        boolean already = false;
        GlyphDetail gdetail = this.computedCid.get(cid);
        if (gdetail != null) {
            gdetail.throwExceptionIfNotValid();
            already = true;
        }
        return already;
    }

    protected abstract float getFontProgramWidth(int var1);

    protected void checkWidthsConsistency(int cid, float expectedWidth, float foundWidth) throws GlyphException {
        if (foundWidth < 0.0f) {
            GlyphException e = new GlyphException("3.3.1", cid, "The character \"" + cid + "\" in the font program \"" + this.font.getBaseFont() + "\"is missing from the Charater Encoding.");
            this.markCIDAsInvalid(cid, e);
            throw e;
        }
        if (Math.abs(foundWidth - expectedWidth) > 1.0f) {
            GlyphException e = new GlyphException("3.1.6", cid, "Width of the character \"" + cid + "\" in the font program \"" + this.font.getBaseFont() + "\"is inconsistent with the width in the PDF dictionary.");
            this.markCIDAsInvalid(cid, e);
            throw e;
        }
        this.markCIDAsValid(cid);
    }

    public final void markCIDAsValid(int cid) {
        this.computedCid.put(cid, new GlyphDetail(cid));
    }

    public final void markCIDAsInvalid(int cid, GlyphException gex) {
        this.computedCid.put(cid, new GlyphDetail(cid, gex));
    }
}

