/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.signature;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.util.Hex;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.tsp.TimeStampRequest;
import org.bouncycastle.tsp.TimeStampRequestGenerator;
import org.bouncycastle.tsp.TimeStampResponse;
import org.bouncycastle.tsp.TimeStampToken;
import org.bouncycastle.tsp.TimeStampTokenInfo;

public class TSAClient {
    private static final Log LOG = LogFactory.getLog(TSAClient.class);
    private static final DigestAlgorithmIdentifierFinder ALGORITHM_OID_FINDER = new DefaultDigestAlgorithmIdentifierFinder();
    private final URL url;
    private final String username;
    private final String password;
    private final MessageDigest digest;
    private static final Random RANDOM = new SecureRandom();

    public TSAClient(URL url, String username, String password, MessageDigest digest) {
        this.url = url;
        this.username = username;
        this.password = password;
        this.digest = digest;
    }

    public TimeStampToken getTimeStampToken(InputStream content) throws IOException {
        this.digest.reset();
        DigestInputStream dis = new DigestInputStream(content, this.digest);
        while (dis.read() != -1) {
        }
        byte[] hash = this.digest.digest();
        int nonce = RANDOM.nextInt(Integer.MAX_VALUE);
        TimeStampRequestGenerator tsaGenerator = new TimeStampRequestGenerator();
        tsaGenerator.setCertReq(true);
        ASN1ObjectIdentifier oid = ALGORITHM_OID_FINDER.find(this.digest.getAlgorithm()).getAlgorithm();
        TimeStampRequest request = tsaGenerator.generate(oid, hash, BigInteger.valueOf(nonce));
        byte[] encodedRequest = request.getEncoded();
        byte[] tsaResponse = this.getTSAResponse(encodedRequest);
        TimeStampResponse response = null;
        try {
            response = new TimeStampResponse(tsaResponse);
            response.validate(request);
        }
        catch (TSPException e) {
            LOG.error((Object)("request: " + Hex.getString((byte[])encodedRequest)));
            if (response != null) {
                LOG.error((Object)("response: " + Hex.getString((byte[])tsaResponse)));
                if ("response contains wrong nonce value.".equals(e.getMessage())) {
                    TimeStampTokenInfo tsi;
                    LOG.error((Object)("request nonce: " + request.getNonce().toString(16)));
                    if (response.getTimeStampToken() != null && (tsi = response.getTimeStampToken().getTimeStampInfo()) != null && tsi.getNonce() != null) {
                        LOG.error((Object)("response nonce: " + tsi.getNonce().toString(16)));
                    }
                }
            }
            throw new IOException(e);
        }
        TimeStampToken timeStampToken = response.getTimeStampToken();
        if (timeStampToken == null) {
            throw new IOException("Response from " + this.url + " does not have a time stamp token, status: " + response.getStatus() + " (" + response.getStatusString() + ")");
        }
        return timeStampToken;
    }

    private byte[] getTSAResponse(byte[] request) throws IOException {
        byte[] response;
        LOG.debug((Object)"Opening connection to TSA server");
        URLConnection connection = this.url.openConnection();
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setRequestProperty("Content-Type", "application/timestamp-query");
        LOG.debug((Object)"Established connection to TSA server");
        if (this.username != null && this.password != null && !this.username.isEmpty() && !this.password.isEmpty()) {
            String contentEncoding = connection.getContentEncoding();
            if (contentEncoding == null) {
                contentEncoding = StandardCharsets.UTF_8.name();
            }
            connection.setRequestProperty("Authorization", "Basic " + Base64.getEncoder().encodeToString((this.username + ":" + this.password).getBytes(contentEncoding)));
        }
        try (OutputStream output = connection.getOutputStream();){
            output.write(request);
        }
        catch (IOException ex) {
            LOG.error((Object)("Exception when writing to " + this.url), (Throwable)ex);
            throw ex;
        }
        LOG.debug((Object)"Waiting for response from TSA server");
        try (InputStream input = connection.getInputStream();){
            response = IOUtils.toByteArray((InputStream)input);
        }
        catch (IOException ex) {
            LOG.error((Object)("Exception when reading from " + this.url), (Throwable)ex);
            throw ex;
        }
        LOG.debug((Object)"Received response from TSA server");
        return response;
    }
}

