/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.contentstream.PDFStreamEngine;
import org.apache.pdfbox.contentstream.operator.OperatorProcessor;
import org.apache.pdfbox.contentstream.operator.color.SetNonStrokingColor;
import org.apache.pdfbox.contentstream.operator.color.SetNonStrokingColorN;
import org.apache.pdfbox.contentstream.operator.color.SetNonStrokingColorSpace;
import org.apache.pdfbox.contentstream.operator.color.SetNonStrokingDeviceCMYKColor;
import org.apache.pdfbox.contentstream.operator.color.SetNonStrokingDeviceGrayColor;
import org.apache.pdfbox.contentstream.operator.color.SetNonStrokingDeviceRGBColor;
import org.apache.pdfbox.contentstream.operator.color.SetStrokingColor;
import org.apache.pdfbox.contentstream.operator.color.SetStrokingColorN;
import org.apache.pdfbox.contentstream.operator.color.SetStrokingColorSpace;
import org.apache.pdfbox.contentstream.operator.color.SetStrokingDeviceCMYKColor;
import org.apache.pdfbox.contentstream.operator.color.SetStrokingDeviceGrayColor;
import org.apache.pdfbox.contentstream.operator.color.SetStrokingDeviceRGBColor;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.graphics.color.PDColor;
import org.apache.pdfbox.pdmodel.graphics.state.RenderingMode;
import org.apache.pdfbox.text.PDFTextStripper;
import org.apache.pdfbox.text.TextPosition;

public class PrintTextColors
extends PDFTextStripper {
    public PrintTextColors() throws IOException {
        this.addOperator((OperatorProcessor)new SetStrokingColorSpace((PDFStreamEngine)this));
        this.addOperator((OperatorProcessor)new SetNonStrokingColorSpace((PDFStreamEngine)this));
        this.addOperator((OperatorProcessor)new SetStrokingDeviceCMYKColor((PDFStreamEngine)this));
        this.addOperator((OperatorProcessor)new SetNonStrokingDeviceCMYKColor((PDFStreamEngine)this));
        this.addOperator((OperatorProcessor)new SetNonStrokingDeviceRGBColor((PDFStreamEngine)this));
        this.addOperator((OperatorProcessor)new SetStrokingDeviceRGBColor((PDFStreamEngine)this));
        this.addOperator((OperatorProcessor)new SetNonStrokingDeviceGrayColor((PDFStreamEngine)this));
        this.addOperator((OperatorProcessor)new SetStrokingDeviceGrayColor((PDFStreamEngine)this));
        this.addOperator((OperatorProcessor)new SetStrokingColor((PDFStreamEngine)this));
        this.addOperator((OperatorProcessor)new SetStrokingColorN((PDFStreamEngine)this));
        this.addOperator((OperatorProcessor)new SetNonStrokingColor((PDFStreamEngine)this));
        this.addOperator((OperatorProcessor)new SetNonStrokingColorN((PDFStreamEngine)this));
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            PrintTextColors.usage();
        } else {
            try (PDDocument document = Loader.loadPDF((File)new File(args[0]));){
                PrintTextColors stripper = new PrintTextColors();
                stripper.setSortByPosition(true);
                stripper.setStartPage(1);
                stripper.setEndPage(document.getNumberOfPages());
                OutputStreamWriter dummy = new OutputStreamWriter(new ByteArrayOutputStream());
                stripper.writeText(document, dummy);
            }
        }
    }

    protected void processTextPosition(TextPosition text) {
        super.processTextPosition(text);
        PDColor strokingColor = this.getGraphicsState().getStrokingColor();
        PDColor nonStrokingColor = this.getGraphicsState().getNonStrokingColor();
        String unicode = text.getUnicode();
        RenderingMode renderingMode = this.getGraphicsState().getTextState().getRenderingMode();
        System.out.println("Unicode:            " + unicode);
        System.out.println("Rendering mode:     " + renderingMode);
        System.out.println("Stroking color:     " + strokingColor);
        System.out.println("Non-Stroking color: " + nonStrokingColor);
        System.out.println("Non-Stroking color: " + nonStrokingColor);
        System.out.println();
    }

    private static void usage() {
        System.err.println("Usage: java " + PrintTextColors.class.getName() + " <input-pdf>");
    }
}

