/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.pdmodel;

import java.io.File;
import java.io.IOException;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionGoTo;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDNamedDestination;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDPageDestination;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDDocumentOutline;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDOutlineItem;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDOutlineNode;

public class PrintBookmarks {
    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            PrintBookmarks.usage();
        } else {
            try (PDDocument document = Loader.loadPDF((File)new File(args[0]));){
                PrintBookmarks meta = new PrintBookmarks();
                PDDocumentOutline outline = document.getDocumentCatalog().getDocumentOutline();
                if (outline != null) {
                    meta.printBookmark(document, (PDOutlineNode)outline, "");
                } else {
                    System.out.println("This document does not contain any bookmarks");
                }
            }
        }
    }

    private static void usage() {
        System.err.println("Usage: java " + PrintBookmarks.class.getName() + " <input-pdf>");
    }

    public void printBookmark(PDDocument document, PDOutlineNode bookmark, String indentation) throws IOException {
        for (PDOutlineItem current = bookmark.getFirstChild(); current != null; current = current.getNextSibling()) {
            PDPageDestination pd;
            if (current.getDestination() instanceof PDPageDestination) {
                pd = (PDPageDestination)current.getDestination();
                System.out.println(indentation + "Destination page: " + (pd.retrievePageNumber() + 1));
            } else if (current.getDestination() instanceof PDNamedDestination) {
                pd = document.getDocumentCatalog().findNamedDestinationPage((PDNamedDestination)current.getDestination());
                if (pd != null) {
                    System.out.println(indentation + "Destination page: " + (pd.retrievePageNumber() + 1));
                }
            } else if (current.getDestination() != null) {
                System.out.println(indentation + "Destination class: " + current.getDestination().getClass().getSimpleName());
            }
            if (current.getAction() instanceof PDActionGoTo) {
                PDPageDestination pd2;
                PDActionGoTo gta = (PDActionGoTo)current.getAction();
                if (gta.getDestination() instanceof PDPageDestination) {
                    pd2 = (PDPageDestination)gta.getDestination();
                    System.out.println(indentation + "Destination page: " + (pd2.retrievePageNumber() + 1));
                } else if (gta.getDestination() instanceof PDNamedDestination) {
                    pd2 = document.getDocumentCatalog().findNamedDestinationPage((PDNamedDestination)gta.getDestination());
                    if (pd2 != null) {
                        System.out.println(indentation + "Destination page: " + (pd2.retrievePageNumber() + 1));
                    }
                } else {
                    System.out.println(indentation + "Destination class: " + gta.getDestination().getClass().getSimpleName());
                }
            } else if (current.getAction() != null) {
                System.out.println(indentation + "Action class: " + current.getAction().getClass().getSimpleName());
            }
            System.out.println(indentation + current.getTitle());
            this.printBookmark(document, (PDOutlineNode)current, indentation + "    ");
        }
    }
}

