/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.text.PDFTextStripper;
import org.apache.pdfbox.text.TextPosition;
import org.apache.pdfbox.util.Charsets;

public class PrintTextLocations
extends PDFTextStripper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            PrintTextLocations.usage();
        } else {
            PDDocument document = null;
            try {
                document = PDDocument.load((File)new File(args[0]));
                PrintTextLocations stripper = new PrintTextLocations();
                stripper.setSortByPosition(true);
                stripper.setStartPage(1);
                stripper.setEndPage(document.getNumberOfPages());
                OutputStreamWriter dummy = new OutputStreamWriter((OutputStream)new ByteArrayOutputStream(), Charsets.US_ASCII);
                stripper.writeText(document, dummy);
            }
            finally {
                if (document != null) {
                    document.close();
                }
            }
        }
    }

    protected void writeString(String string, List<TextPosition> textPositions) throws IOException {
        for (TextPosition text : textPositions) {
            System.out.println("String[" + text.getXDirAdj() + "," + text.getYDirAdj() + " font=" + text.getFont().getName() + ":" + text.getFontSize() + " xscale=" + text.getXScale() + " height=" + text.getHeightDir() + " space=" + text.getWidthOfSpace() + " width=" + text.getWidthDirAdj() + "]" + text.getUnicode());
        }
    }

    private static void usage() {
        System.err.println("Usage: java " + PrintTextLocations.class.getName() + " <input-pdf>");
    }
}

