/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.signature;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObjectKey;
import org.apache.pdfbox.examples.signature.cert.CertificateVerificationException;
import org.apache.pdfbox.examples.signature.cert.CertificateVerifier;
import org.apache.pdfbox.examples.util.ConnectedInputStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.encryption.SecurityProvider;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationVerifier;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.tsp.TimeStampToken;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.Store;

public class SigUtils {
    private static final Log LOG = LogFactory.getLog(SigUtils.class);

    private SigUtils() {
    }

    public static int getMDPPermission(PDDocument doc) {
        COSDictionary signatureDict;
        COSDictionary permsDict;
        COSBase base = doc.getDocumentCatalog().getCOSObject().getDictionaryObject(COSName.PERMS);
        if (base instanceof COSDictionary && (base = (permsDict = (COSDictionary)base).getDictionaryObject(COSName.DOCMDP)) instanceof COSDictionary && (base = (signatureDict = (COSDictionary)base).getDictionaryObject(COSName.REFERENCE)) instanceof COSArray) {
            COSArray refArray = (COSArray)base;
            for (int i = 0; i < refArray.size(); ++i) {
                COSDictionary sigRefDict;
                base = refArray.getObject(i);
                if (!(base instanceof COSDictionary) || !COSName.DOCMDP.equals((Object)(sigRefDict = (COSDictionary)base).getDictionaryObject(COSName.TRANSFORM_METHOD)) || !((base = sigRefDict.getDictionaryObject(COSName.TRANSFORM_PARAMS)) instanceof COSDictionary)) continue;
                COSDictionary transformDict = (COSDictionary)base;
                int accessPermissions = transformDict.getInt(COSName.P, 2);
                if (accessPermissions < 1 || accessPermissions > 3) {
                    accessPermissions = 2;
                }
                return accessPermissions;
            }
        }
        return 0;
    }

    public static void setMDPPermission(PDDocument doc, PDSignature signature, int accessPermissions) throws IOException {
        for (PDSignature sig : doc.getSignatureDictionaries()) {
            if (COSName.DOC_TIME_STAMP.equals((Object)sig.getCOSObject().getItem(COSName.TYPE)) || !sig.getCOSObject().containsKey(COSName.CONTENTS)) continue;
            throw new IOException("DocMDP transform method not allowed if an approval signature exists");
        }
        COSDictionary sigDict = signature.getCOSObject();
        COSDictionary transformParameters = new COSDictionary();
        transformParameters.setItem(COSName.TYPE, (COSBase)COSName.TRANSFORM_PARAMS);
        transformParameters.setInt(COSName.P, accessPermissions);
        transformParameters.setName(COSName.V, "1.2");
        transformParameters.setNeedToBeUpdated(true);
        transformParameters.setDirect(true);
        COSDictionary referenceDict = new COSDictionary();
        referenceDict.setItem(COSName.TYPE, (COSBase)COSName.SIG_REF);
        referenceDict.setItem(COSName.TRANSFORM_METHOD, (COSBase)COSName.DOCMDP);
        referenceDict.setItem(COSName.DIGEST_METHOD, (COSBase)COSName.getPDFName((String)"SHA1"));
        referenceDict.setItem(COSName.TRANSFORM_PARAMS, (COSBase)transformParameters);
        referenceDict.setNeedToBeUpdated(true);
        referenceDict.setDirect(true);
        COSArray referenceArray = new COSArray();
        referenceArray.add((COSBase)referenceDict);
        sigDict.setItem(COSName.REFERENCE, (COSBase)referenceArray);
        referenceArray.setNeedToBeUpdated(true);
        referenceArray.setDirect(true);
        COSDictionary catalogDict = doc.getDocumentCatalog().getCOSObject();
        COSDictionary permsDict = catalogDict.getCOSDictionary(COSName.PERMS);
        if (permsDict == null) {
            permsDict = new COSDictionary();
            catalogDict.setItem(COSName.PERMS, (COSBase)permsDict);
        }
        permsDict.setItem(COSName.DOCMDP, (COSObjectable)signature);
        catalogDict.setNeedToBeUpdated(true);
        permsDict.setNeedToBeUpdated(true);
    }

    public static void checkCertificateUsage(X509Certificate x509Certificate) throws CertificateParsingException {
        List<String> extendedKeyUsage;
        boolean[] keyUsage = x509Certificate.getKeyUsage();
        if (keyUsage != null && !keyUsage[0] && !keyUsage[1]) {
            LOG.error((Object)"Certificate key usage does not include digitalSignature nor nonRepudiation");
        }
        if (!((extendedKeyUsage = x509Certificate.getExtendedKeyUsage()) == null || extendedKeyUsage.contains(KeyPurposeId.id_kp_emailProtection.toString()) || extendedKeyUsage.contains(KeyPurposeId.id_kp_codeSigning.toString()) || extendedKeyUsage.contains(KeyPurposeId.anyExtendedKeyUsage.toString()) || extendedKeyUsage.contains("1.2.840.113583.1.1.5") || extendedKeyUsage.contains("1.3.6.1.4.1.311.10.3.12"))) {
            LOG.error((Object)"Certificate extended key usage does not include emailProtection, nor codeSigning, nor anyExtendedKeyUsage, nor 'Adobe Authentic Documents Trust'");
        }
    }

    public static void checkTimeStampCertificateUsage(X509Certificate x509Certificate) throws CertificateParsingException {
        List<String> extendedKeyUsage = x509Certificate.getExtendedKeyUsage();
        if (extendedKeyUsage != null && !extendedKeyUsage.contains(KeyPurposeId.id_kp_timeStamping.toString())) {
            LOG.error((Object)"Certificate extended key usage does not include timeStamping");
        }
    }

    public static void checkResponderCertificateUsage(X509Certificate x509Certificate) throws CertificateParsingException {
        List<String> extendedKeyUsage = x509Certificate.getExtendedKeyUsage();
        if (extendedKeyUsage != null && !extendedKeyUsage.contains(KeyPurposeId.id_kp_OCSPSigning.toString())) {
            LOG.error((Object)"Certificate extended key usage does not include OCSP responding");
        }
    }

    public static PDSignature getLastRelevantSignature(PDDocument document) throws IOException {
        PDSignature lastSignature;
        COSBase type;
        TreeMap<Integer, PDSignature> sortedMap = new TreeMap<Integer, PDSignature>();
        for (PDSignature signature : document.getSignatureDictionaries()) {
            int sigOffset = signature.getByteRange()[1];
            sortedMap.put(sigOffset, signature);
        }
        if (sortedMap.size() > 0 && ((type = (lastSignature = (PDSignature)sortedMap.get(sortedMap.lastKey())).getCOSObject().getItem(COSName.TYPE)) == null || COSName.SIG.equals((Object)type) || COSName.DOC_TIME_STAMP.equals((Object)type))) {
            return lastSignature;
        }
        return null;
    }

    public static TimeStampToken extractTimeStampTokenFromSignerInformation(SignerInformation signerInformation) throws CMSException, IOException, TSPException {
        if (signerInformation.getUnsignedAttributes() == null) {
            return null;
        }
        AttributeTable unsignedAttributes = signerInformation.getUnsignedAttributes();
        Attribute attribute = unsignedAttributes.get(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken);
        if (attribute == null) {
            return null;
        }
        ASN1Object obj = (ASN1Object)attribute.getAttrValues().getObjectAt(0);
        CMSSignedData signedTSTData = new CMSSignedData(obj.getEncoded());
        return new TimeStampToken(signedTSTData);
    }

    public static void validateTimestampToken(TimeStampToken timeStampToken) throws IOException, CertificateException, TSPException, OperatorCreationException {
        Collection tstMatches = timeStampToken.getCertificates().getMatches((Selector)timeStampToken.getSID());
        X509CertificateHolder certificateHolder = (X509CertificateHolder)tstMatches.iterator().next();
        SignerInformationVerifier siv = new JcaSimpleSignerInfoVerifierBuilder().setProvider(SecurityProvider.getProvider()).build(certificateHolder);
        timeStampToken.validate(siv);
    }

    public static void verifyCertificateChain(Store<X509CertificateHolder> certificatesStore, X509Certificate certFromSignedData, Date signDate) throws CertificateVerificationException, CertificateException {
        Collection certificateHolders = certificatesStore.getMatches(null);
        HashSet<X509Certificate> additionalCerts = new HashSet<X509Certificate>();
        JcaX509CertificateConverter certificateConverter = new JcaX509CertificateConverter();
        for (X509CertificateHolder certHolder : certificateHolders) {
            X509Certificate certificate = certificateConverter.getCertificate(certHolder);
            if (certificate.equals(certFromSignedData)) continue;
            additionalCerts.add(certificate);
        }
        CertificateVerifier.verifyCertificate(certFromSignedData, additionalCerts, true, signDate);
    }

    public static void checkCrossReferenceTable(PDDocument doc) {
        TreeSet set = new TreeSet(doc.getDocument().getXrefTable().keySet());
        if ((long)set.size() != ((COSObjectKey)set.last()).getNumber()) {
            long n = 0L;
            for (COSObjectKey key : set) {
                ++n;
                while (n < key.getNumber()) {
                    LOG.warn((Object)("Object " + n + " missing, signature verification may fail in Adobe Reader, see https://stackoverflow.com/questions/71267471/"));
                    ++n;
                }
            }
        }
    }

    public static InputStream openURL(String urlString) throws MalformedURLException, IOException {
        URL url = new URL(urlString);
        if (!urlString.startsWith("http")) {
            return url.openStream();
        }
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        int responseCode = con.getResponseCode();
        LOG.info((Object)(responseCode + " " + con.getResponseMessage()));
        if (responseCode == 302 || responseCode == 301 || responseCode == 303) {
            String location = con.getHeaderField("Location");
            if (urlString.startsWith("http://") && location.startsWith("https://") && urlString.substring(7).equals(location.substring(8))) {
                LOG.info((Object)("redirection to " + location + " followed"));
                con.disconnect();
                con = (HttpURLConnection)new URL(location).openConnection();
            } else {
                LOG.info((Object)("redirection to " + location + " ignored"));
            }
        }
        return new ConnectedInputStream(con, con.getInputStream());
    }
}

