/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.List;
import javax.xml.transform.TransformerException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.io.MemoryUsageSetting;
import org.apache.pdfbox.multipdf.PDFMergerUtility;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.common.PDMetadata;
import org.apache.xmpbox.XMPMetadata;
import org.apache.xmpbox.schema.DublinCoreSchema;
import org.apache.xmpbox.schema.PDFAIdentificationSchema;
import org.apache.xmpbox.schema.XMPBasicSchema;
import org.apache.xmpbox.type.BadFieldValueException;
import org.apache.xmpbox.xml.XmpSerializer;

public class PDFMergerExample {
    private static final Log LOG = LogFactory.getLog(PDFMergerExample.class);

    public InputStream merge(List<InputStream> sources) throws IOException {
        String title = "My title";
        String creator = "Alexander Kriegisch";
        String subject = "Subject with umlauts \u00c4\u00d6\u00dc";
        ByteArrayOutputStream mergedPDFOutputStream = null;
        COSStream cosStream = null;
        try {
            mergedPDFOutputStream = new ByteArrayOutputStream();
            cosStream = new COSStream();
            PDFMergerUtility pdfMerger = this.createPDFMergerUtility(sources, mergedPDFOutputStream);
            PDDocumentInformation pdfDocumentInfo = this.createPDFDocumentInfo(title, creator, subject);
            PDMetadata xmpMetadata = this.createXMPMetadata(cosStream, title, creator, subject);
            pdfMerger.setDestinationDocumentInformation(pdfDocumentInfo);
            pdfMerger.setDestinationMetadata(xmpMetadata);
            LOG.info((Object)("Merging " + sources.size() + " source documents into one PDF"));
            pdfMerger.mergeDocuments(MemoryUsageSetting.setupMainMemoryOnly());
            LOG.info((Object)("PDF merge successful, size = {" + mergedPDFOutputStream.size() + "} bytes"));
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(mergedPDFOutputStream.toByteArray());
            return byteArrayInputStream;
        }
        catch (BadFieldValueException e) {
            throw new IOException("PDF merge problem", e);
        }
        catch (TransformerException e) {
            throw new IOException("PDF merge problem", e);
        }
        finally {
            for (InputStream source : sources) {
                IOUtils.closeQuietly((Closeable)source);
            }
            IOUtils.closeQuietly((Closeable)cosStream);
            IOUtils.closeQuietly((Closeable)mergedPDFOutputStream);
        }
    }

    private PDFMergerUtility createPDFMergerUtility(List<InputStream> sources, ByteArrayOutputStream mergedPDFOutputStream) {
        LOG.info((Object)"Initialising PDF merge utility");
        PDFMergerUtility pdfMerger = new PDFMergerUtility();
        pdfMerger.addSources(sources);
        pdfMerger.setDestinationStream((OutputStream)mergedPDFOutputStream);
        return pdfMerger;
    }

    private PDDocumentInformation createPDFDocumentInfo(String title, String creator, String subject) {
        LOG.info((Object)"Setting document info (title, author, subject) for merged PDF");
        PDDocumentInformation documentInformation = new PDDocumentInformation();
        documentInformation.setTitle(title);
        documentInformation.setCreator(creator);
        documentInformation.setSubject(subject);
        return documentInformation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PDMetadata createXMPMetadata(COSStream cosStream, String title, String creator, String subject) throws BadFieldValueException, TransformerException, IOException {
        LOG.info((Object)"Setting XMP metadata (title, author, subject) for merged PDF");
        XMPMetadata xmpMetadata = XMPMetadata.createXMPMetadata();
        PDFAIdentificationSchema pdfaSchema = xmpMetadata.createAndAddPDFAIdentificationSchema();
        pdfaSchema.setPart(Integer.valueOf(1));
        pdfaSchema.setConformance("B");
        DublinCoreSchema dublinCoreSchema = xmpMetadata.createAndAddDublinCoreSchema();
        dublinCoreSchema.setTitle(title);
        dublinCoreSchema.addCreator(creator);
        dublinCoreSchema.setDescription(subject);
        XMPBasicSchema basicSchema = xmpMetadata.createAndAddXMPBasicSchema();
        Calendar creationDate = Calendar.getInstance();
        basicSchema.setCreateDate(creationDate);
        basicSchema.setModifyDate(creationDate);
        basicSchema.setMetadataDate(creationDate);
        basicSchema.setCreatorTool(creator);
        Closeable xmpOutputStream = null;
        OutputStream cosXMPStream = null;
        try {
            cosXMPStream = cosStream.createOutputStream();
            new XmpSerializer().serialize(xmpMetadata, cosXMPStream, true);
            cosStream.setName(COSName.TYPE, "Metadata");
            cosStream.setName(COSName.SUBTYPE, "XML");
            PDMetadata pDMetadata = new PDMetadata(cosStream);
            return pDMetadata;
        }
        finally {
            IOUtils.closeQuietly(xmpOutputStream);
            IOUtils.closeQuietly((Closeable)cosXMPStream);
        }
    }
}

