/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.printing;

import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.PageRanges;
import javax.print.attribute.standard.Sides;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.interactive.viewerpreferences.PDViewerPreferences;
import org.apache.pdfbox.printing.PDFPageable;
import org.apache.pdfbox.printing.PDFPrintable;

public final class Printing {
    private Printing() {
    }

    public static void main(String[] args) throws PrinterException, IOException {
        if (args.length != 1) {
            System.err.println("usage: java " + Printing.class.getName() + " <input>");
            System.exit(1);
        }
        String filename = args[0];
        PDDocument document = PDDocument.load((File)new File(filename));
        Printing.print(document);
        document.close();
    }

    private static void print(PDDocument document) throws PrinterException {
        PrinterJob job = PrinterJob.getPrinterJob();
        job.setPageable((Pageable)new PDFPageable(document));
        job.print();
    }

    private static void printWithAttributes(PDDocument document) throws PrinterException {
        PrinterJob job = PrinterJob.getPrinterJob();
        job.setPageable((Pageable)new PDFPageable(document));
        HashPrintRequestAttributeSet attr = new HashPrintRequestAttributeSet();
        attr.add(new PageRanges(1, 1));
        job.print(attr);
    }

    private static void printWithDialog(PDDocument document) throws PrinterException {
        PrinterJob job = PrinterJob.getPrinterJob();
        job.setPageable((Pageable)new PDFPageable(document));
        if (job.printDialog()) {
            job.print();
        }
    }

    private static void printWithDialogAndAttributes(PDDocument document) throws PrinterException {
        PrinterJob job = PrinterJob.getPrinterJob();
        job.setPageable((Pageable)new PDFPageable(document));
        HashPrintRequestAttributeSet attr = new HashPrintRequestAttributeSet();
        attr.add(new PageRanges(1, 1));
        PDViewerPreferences vp = document.getDocumentCatalog().getViewerPreferences();
        if (vp != null && vp.getDuplex() != null) {
            String dp = vp.getDuplex();
            if (PDViewerPreferences.DUPLEX.DuplexFlipLongEdge.toString().equals(dp)) {
                attr.add(Sides.TWO_SIDED_LONG_EDGE);
            } else if (PDViewerPreferences.DUPLEX.DuplexFlipShortEdge.toString().equals(dp)) {
                attr.add(Sides.TWO_SIDED_SHORT_EDGE);
            } else if (PDViewerPreferences.DUPLEX.Simplex.toString().equals(dp)) {
                attr.add(Sides.ONE_SIDED);
            }
        }
        if (job.printDialog(attr)) {
            job.print(attr);
        }
    }

    private static void printWithPaper(PDDocument document) throws PrinterException {
        PrinterJob job = PrinterJob.getPrinterJob();
        job.setPageable((Pageable)new PDFPageable(document));
        Paper paper = new Paper();
        paper.setSize(306.0, 396.0);
        paper.setImageableArea(0.0, 0.0, paper.getWidth(), paper.getHeight());
        PageFormat pageFormat = new PageFormat();
        pageFormat.setPaper(paper);
        Book book = new Book();
        book.append((Printable)new PDFPrintable(document), pageFormat, document.getNumberOfPages());
        job.setPageable(book);
        job.print();
    }
}

