/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.util;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.contentstream.PDContentStream;
import org.apache.pdfbox.contentstream.operator.Operator;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdfparser.PDFStreamParser;
import org.apache.pdfbox.pdfwriter.ContentStreamWriter;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.graphics.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.pdmodel.graphics.pattern.PDAbstractPattern;
import org.apache.pdfbox.pdmodel.graphics.pattern.PDTilingPattern;

public final class RemoveAllText {
    private RemoveAllText() {
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 2) {
            RemoveAllText.usage();
        } else {
            PDDocument document = PDDocument.load((File)new File(args[0]));
            if (document.isEncrypted()) {
                System.err.println("Error: Encrypted documents are not supported for this example.");
                System.exit(1);
            }
            for (PDPage page : document.getPages()) {
                List<Object> newTokens = RemoveAllText.createTokensWithoutText((PDContentStream)page);
                PDStream newContents = new PDStream(document);
                RemoveAllText.writeTokensToStream(newContents, newTokens);
                page.setContents(newContents);
                RemoveAllText.processResources(page.getResources());
            }
            document.save(args[1]);
            document.close();
        }
    }

    private static void processResources(PDResources resources) throws IOException {
        for (COSName name : resources.getXObjectNames()) {
            PDXObject xobject = resources.getXObject(name);
            if (!(xobject instanceof PDFormXObject)) continue;
            PDFormXObject formXObject = (PDFormXObject)xobject;
            RemoveAllText.writeTokensToStream(formXObject.getContentStream(), RemoveAllText.createTokensWithoutText((PDContentStream)formXObject));
            RemoveAllText.processResources(formXObject.getResources());
        }
        for (COSName name : resources.getPatternNames()) {
            PDAbstractPattern pattern = resources.getPattern(name);
            if (!(pattern instanceof PDTilingPattern)) continue;
            PDTilingPattern tilingPattern = (PDTilingPattern)pattern;
            RemoveAllText.writeTokensToStream(tilingPattern.getContentStream(), RemoveAllText.createTokensWithoutText((PDContentStream)tilingPattern));
            RemoveAllText.processResources(tilingPattern.getResources());
        }
    }

    private static void writeTokensToStream(PDStream newContents, List<Object> newTokens) throws IOException {
        OutputStream out = newContents.createOutputStream(COSName.FLATE_DECODE);
        ContentStreamWriter writer = new ContentStreamWriter(out);
        writer.writeTokens(newTokens);
        out.close();
    }

    private static List<Object> createTokensWithoutText(PDContentStream contentStream) throws IOException {
        PDFStreamParser parser = new PDFStreamParser(contentStream);
        Object token = parser.parseNextToken();
        ArrayList<Object> newTokens = new ArrayList<Object>();
        while (token != null) {
            if (token instanceof Operator) {
                Operator op = (Operator)token;
                String opName = op.getName();
                if ("TJ".equals(opName) || "Tj".equals(opName) || "'".equals(opName)) {
                    newTokens.remove(newTokens.size() - 1);
                    token = parser.parseNextToken();
                    continue;
                }
                if ("\"".equals(opName)) {
                    newTokens.remove(newTokens.size() - 1);
                    newTokens.remove(newTokens.size() - 1);
                    newTokens.remove(newTokens.size() - 1);
                    token = parser.parseNextToken();
                    continue;
                }
            }
            newTokens.add(token);
            token = parser.parseNextToken();
        }
        return newTokens;
    }

    private static void usage() {
        System.err.println("Usage: java " + RemoveAllText.class.getName() + " <input-pdf> <output-pdf>");
    }
}

