/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.printing;

import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import javax.print.PrintServiceLookup;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.contentstream.operator.MissingOperandException;
import org.apache.pdfbox.contentstream.operator.Operator;
import org.apache.pdfbox.contentstream.operator.OperatorProcessor;
import org.apache.pdfbox.contentstream.operator.graphics.GraphicsOperatorProcessor;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.MissingResourceException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.graphics.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.pdmodel.graphics.image.PDImage;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.pdmodel.graphics.state.PDExtendedGraphicsState;
import org.apache.pdfbox.printing.PDFPrintable;
import org.apache.pdfbox.printing.Scaling;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.apache.pdfbox.rendering.PageDrawer;
import org.apache.pdfbox.rendering.PageDrawerParameters;

public class OpaquePDFRenderer
extends PDFRenderer {
    public static void main(String[] args) throws IOException, PrinterException {
        InputStream is = new URL("https://github.com/qzind/tray/files/1749977/test.pdf").openStream();
        PDDocument doc = PDDocument.load((InputStream)is);
        is.close();
        OpaquePDFRenderer renderer = new OpaquePDFRenderer(doc);
        PDFPrintable printable = new PDFPrintable(doc, Scaling.SCALE_TO_FIT, false, 0.0f, true, (PDFRenderer)renderer);
        PrinterJob job = PrinterJob.getPrinterJob();
        job.setPrintService(PrintServiceLookup.lookupDefaultPrintService());
        job.setPrintable((Printable)printable);
        if (job.printDialog()) {
            job.print();
        }
        doc.close();
    }

    public OpaquePDFRenderer(PDDocument document) {
        super(document);
    }

    protected PageDrawer createPageDrawer(PageDrawerParameters parameters) throws IOException {
        return new OpaquePageDrawer(parameters);
    }

    private static class OpaqueSetGraphicsStateParameters
    extends OperatorProcessor {
        private static final Log LOG = LogFactory.getLog(OpaqueSetGraphicsStateParameters.class);

        private OpaqueSetGraphicsStateParameters() {
        }

        public void process(Operator operator, List<COSBase> arguments) throws IOException {
            if (arguments.isEmpty()) {
                throw new MissingOperandException(operator, arguments);
            }
            COSBase base0 = arguments.get(0);
            if (!(base0 instanceof COSName)) {
                return;
            }
            COSName graphicsName = (COSName)base0;
            PDExtendedGraphicsState gs = this.context.getResources().getExtGState(graphicsName);
            if (gs == null) {
                LOG.error((Object)("name for 'gs' operator not found in resources: /" + graphicsName.getName()));
                return;
            }
            gs.setNonStrokingAlphaConstant(Float.valueOf(1.0f));
            gs.setStrokingAlphaConstant(Float.valueOf(1.0f));
            gs.copyIntoGraphicsState(this.context.getGraphicsState());
        }

        public String getName() {
            return "gs";
        }
    }

    private static class OpaqueDrawObject
    extends GraphicsOperatorProcessor {
        private static final Log LOG = LogFactory.getLog(OpaqueDrawObject.class);

        private OpaqueDrawObject() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process(Operator operator, List<COSBase> operands) throws IOException {
            if (operands.isEmpty()) {
                throw new MissingOperandException(operator, operands);
            }
            COSBase base0 = operands.get(0);
            if (!(base0 instanceof COSName)) {
                return;
            }
            COSName objectName = (COSName)base0;
            PDXObject xobject = this.context.getResources().getXObject(objectName);
            if (xobject == null) {
                throw new MissingResourceException("Missing XObject: " + objectName.getName());
            }
            if (xobject instanceof PDImageXObject) {
                PDImageXObject image = (PDImageXObject)xobject;
                this.context.drawImage((PDImage)image);
            } else if (xobject instanceof PDFormXObject) {
                try {
                    this.context.increaseLevel();
                    if (this.context.getLevel() > 50) {
                        LOG.error((Object)"recursion is too deep, skipping form XObject");
                        return;
                    }
                    this.context.showForm((PDFormXObject)xobject);
                }
                finally {
                    this.context.decreaseLevel();
                }
            }
        }

        public String getName() {
            return "Do";
        }
    }

    private class OpaquePageDrawer
    extends PageDrawer {
        public OpaquePageDrawer(PageDrawerParameters parameters) throws IOException {
            super(parameters);
            this.addOperator((OperatorProcessor)new OpaqueDrawObject());
            this.addOperator(new OpaqueSetGraphicsStateParameters());
        }
    }
}

