/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.util;

import java.io.File;
import java.io.IOException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.encryption.AccessPermission;
import org.apache.pdfbox.text.PDFTextStripper;

public class ExtractTextSimple {
    private ExtractTextSimple() {
    }

    public static void main(String[] args) throws IOException {
        PDDocument document;
        AccessPermission ap;
        if (args.length != 1) {
            ExtractTextSimple.usage();
        }
        if (!(ap = (document = PDDocument.load((File)new File(args[0]))).getCurrentAccessPermission()).canExtractContent()) {
            throw new IOException("You do not have permission to extract text");
        }
        PDFTextStripper stripper = new PDFTextStripper();
        stripper.setSortByPosition(true);
        for (int p = 1; p <= document.getNumberOfPages(); ++p) {
            stripper.setStartPage(p);
            stripper.setEndPage(p);
            String text = stripper.getText(document);
            String pageStr = String.format("page %d:", p);
            System.out.println(pageStr);
            for (int i = 0; i < pageStr.length(); ++i) {
                System.out.print("-");
            }
            System.out.println();
            System.out.println(text.trim());
            System.out.println();
        }
        document.close();
    }

    private static void usage() {
        System.err.println("Usage: java " + ExtractTextSimple.class.getName() + " <input-pdf>");
        System.exit(-1);
    }
}

