/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.rendering;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.graphics.color.PDColor;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.apache.pdfbox.rendering.PageDrawer;
import org.apache.pdfbox.rendering.PageDrawerParameters;
import org.apache.pdfbox.util.Matrix;
import org.apache.pdfbox.util.Vector;

public class CustomPageDrawer {
    public static void main(String[] args) throws IOException {
        File file = new File("src/main/resources/org/apache/pdfbox/examples/rendering/", "custom-render-demo.pdf");
        PDDocument doc = PDDocument.load((File)file);
        MyPDFRenderer renderer = new MyPDFRenderer(doc);
        BufferedImage image = renderer.renderImage(0);
        ImageIO.write((RenderedImage)image, "PNG", new File("custom-render.png"));
        doc.close();
    }

    private static class MyPageDrawer
    extends PageDrawer {
        MyPageDrawer(PageDrawerParameters parameters) throws IOException {
            super(parameters);
        }

        protected Paint getPaint(PDColor color) throws IOException {
            if (this.getGraphicsState().getNonStrokingColor() == color && color.toRGB() == (Color.RED.getRGB() & 0xFFFFFF)) {
                return Color.BLUE;
            }
            return super.getPaint(color);
        }

        protected void showGlyph(Matrix textRenderingMatrix, PDFont font, int code, Vector displacement) throws IOException {
            super.showGlyph(textRenderingMatrix, font, code, displacement);
            Shape bbox = new Rectangle2D.Float(0.0f, 0.0f, font.getWidth(code) / 1000.0f, 1.0f);
            AffineTransform at = textRenderingMatrix.createAffineTransform();
            bbox = at.createTransformedShape(bbox);
            Graphics2D graphics = this.getGraphics();
            Color color = graphics.getColor();
            Stroke stroke = graphics.getStroke();
            Shape clip = graphics.getClip();
            graphics.setClip(graphics.getDeviceConfiguration().getBounds());
            graphics.setColor(Color.RED);
            graphics.setStroke(new BasicStroke(0.5f));
            graphics.draw(bbox);
            graphics.setStroke(stroke);
            graphics.setColor(color);
            graphics.setClip(clip);
        }

        public void fillPath(int windingRule) throws IOException {
            Rectangle2D bbox = this.getLinePath().getBounds2D();
            super.fillPath(windingRule);
            Graphics2D graphics = this.getGraphics();
            Color color = graphics.getColor();
            Stroke stroke = graphics.getStroke();
            Shape clip = graphics.getClip();
            graphics.setClip(graphics.getDeviceConfiguration().getBounds());
            graphics.setColor(Color.GREEN);
            graphics.setStroke(new BasicStroke(0.5f));
            graphics.draw(bbox);
            graphics.setStroke(stroke);
            graphics.setColor(color);
            graphics.setClip(clip);
        }

        public void showAnnotation(PDAnnotation annotation) throws IOException {
            this.saveGraphicsState();
            this.getGraphicsState().setNonStrokeAlphaConstant(0.35);
            super.showAnnotation(annotation);
            this.restoreGraphicsState();
        }
    }

    private static class MyPDFRenderer
    extends PDFRenderer {
        MyPDFRenderer(PDDocument document) {
            super(document);
        }

        protected PageDrawer createPageDrawer(PageDrawerParameters parameters) throws IOException {
            return new MyPageDrawer(parameters);
        }
    }
}

