/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.pdmodel;

import java.io.File;
import java.io.IOException;
import org.apache.pdfbox.pdmodel.PDDocument;

public final class RemoveFirstPage {
    private RemoveFirstPage() {
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 2) {
            RemoveFirstPage.usage();
        } else {
            PDDocument document = null;
            try {
                document = PDDocument.load((File)new File(args[0]));
                if (document.isEncrypted()) {
                    throw new IOException("Encrypted documents are not supported for this example");
                }
                if (document.getNumberOfPages() <= 1) {
                    throw new IOException("Error: A PDF document must have at least one page, cannot remove the last page!");
                }
                document.removePage(0);
                document.save(args[1]);
            }
            finally {
                if (document != null) {
                    document.close();
                }
            }
        }
    }

    private static void usage() {
        System.err.println("Usage: java " + RemoveFirstPage.class.getName() + " <input-pdf> <output-pdf>");
    }
}

