/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.interactive.form;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.graphics.color.PDColor;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceRGB;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceCharacteristicsDictionary;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceDictionary;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceEntry;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceStream;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDBorderStyleDictionary;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDRadioButton;

public class CreateRadioButtons {
    private CreateRadioButtons() {
    }

    public static void main(String[] args) throws IOException {
        PDDocument document = new PDDocument();
        PDPage page = new PDPage(PDRectangle.A4);
        document.addPage(page);
        PDAcroForm acroForm = new PDAcroForm(document);
        document.getDocumentCatalog().setAcroForm(acroForm);
        List<String> options = Arrays.asList("a", "b", "c");
        PDRadioButton radioButton = new PDRadioButton(acroForm);
        radioButton.setPartialName("MyRadioButton");
        radioButton.setExportValues(options);
        PDAppearanceCharacteristicsDictionary appearanceCharacteristics = new PDAppearanceCharacteristicsDictionary(new COSDictionary());
        appearanceCharacteristics.setBorderColour(new PDColor(new float[]{1.0f, 0.0f, 0.0f}, (PDColorSpace)PDDeviceRGB.INSTANCE));
        appearanceCharacteristics.setBackground(new PDColor(new float[]{0.0f, 1.0f, 0.3f}, (PDColorSpace)PDDeviceRGB.INSTANCE));
        ArrayList<PDAnnotationWidget> widgets = new ArrayList<PDAnnotationWidget>();
        for (int i = 0; i < options.size(); ++i) {
            PDAnnotationWidget widget = new PDAnnotationWidget();
            widget.setRectangle(new PDRectangle(30.0f, PDRectangle.A4.getHeight() - 40.0f - (float)(i * 35), 30.0f, 30.0f));
            widget.setAppearanceCharacteristics(appearanceCharacteristics);
            PDBorderStyleDictionary borderStyleDictionary = new PDBorderStyleDictionary();
            borderStyleDictionary.setWidth(2.0f);
            borderStyleDictionary.setStyle("S");
            widget.setBorderStyle(borderStyleDictionary);
            widget.setPage(page);
            COSDictionary apNDict = new COSDictionary();
            apNDict.setItem(COSName.Off, (COSObjectable)CreateRadioButtons.createAppearanceStream(document, widget, false));
            apNDict.setItem(options.get(i), (COSObjectable)CreateRadioButtons.createAppearanceStream(document, widget, true));
            PDAppearanceDictionary appearance = new PDAppearanceDictionary();
            PDAppearanceEntry appearanceNEntry = new PDAppearanceEntry((COSBase)apNDict);
            appearance.setNormalAppearance(appearanceNEntry);
            widget.setAppearance(appearance);
            widget.setAppearanceState("Off");
            widgets.add(widget);
            page.getAnnotations().add(widget);
        }
        radioButton.setWidgets(widgets);
        acroForm.getFields().add(radioButton);
        PDPageContentStream contents = new PDPageContentStream(document, page);
        for (int i = 0; i < options.size(); ++i) {
            contents.beginText();
            contents.setFont((PDFont)PDType1Font.HELVETICA, 15.0f);
            contents.newLineAtOffset(70.0f, PDRectangle.A4.getHeight() - 30.0f - (float)(i * 35));
            contents.showText(options.get(i));
            contents.endText();
        }
        contents.close();
        radioButton.setValue("c");
        document.save("target/RadioButtonsSample.pdf");
        document.close();
    }

    private static PDAppearanceStream createAppearanceStream(PDDocument document, PDAnnotationWidget widget, boolean on) throws IOException {
        PDRectangle rect = widget.getRectangle();
        PDAppearanceStream onAP = new PDAppearanceStream(document);
        onAP.setBBox(new PDRectangle(rect.getWidth(), rect.getHeight()));
        PDPageContentStream onAPCS = new PDPageContentStream(document, onAP);
        PDAppearanceCharacteristicsDictionary appearanceCharacteristics = widget.getAppearanceCharacteristics();
        PDColor backgroundColor = appearanceCharacteristics.getBackground();
        PDColor borderColor = appearanceCharacteristics.getBorderColour();
        float lineWidth = CreateRadioButtons.getLineWidth(widget);
        onAPCS.setLineWidth(lineWidth);
        onAPCS.setNonStrokingColor(backgroundColor);
        float radius = Math.min(rect.getWidth() / 2.0f, rect.getHeight() / 2.0f);
        CreateRadioButtons.drawCircle(onAPCS, rect.getWidth() / 2.0f, rect.getHeight() / 2.0f, radius);
        onAPCS.fill();
        onAPCS.setStrokingColor(borderColor);
        CreateRadioButtons.drawCircle(onAPCS, rect.getWidth() / 2.0f, rect.getHeight() / 2.0f, radius - lineWidth / 2.0f);
        onAPCS.stroke();
        if (on) {
            onAPCS.setNonStrokingColor(0.0f);
            CreateRadioButtons.drawCircle(onAPCS, rect.getWidth() / 2.0f, rect.getHeight() / 2.0f, (radius - lineWidth) / 2.0f);
            onAPCS.fill();
        }
        onAPCS.close();
        return onAP;
    }

    static float getLineWidth(PDAnnotationWidget widget) {
        PDBorderStyleDictionary bs = widget.getBorderStyle();
        if (bs != null) {
            return bs.getWidth();
        }
        return 1.0f;
    }

    static void drawCircle(PDPageContentStream cs, float x, float y, float r) throws IOException {
        float magic = r * 0.551784f;
        cs.moveTo(x, y + r);
        cs.curveTo(x + magic, y + r, x + r, y + magic, x + r, y);
        cs.curveTo(x + r, y - magic, x + magic, y - r, x, y - r);
        cs.curveTo(x - magic, y - r, x - r, y - magic, x - r, y);
        cs.curveTo(x - r, y + magic, x - magic, y + r, x, y + r);
        cs.closePath();
    }
}

