/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mail.smime.examples;

import java.io.FileInputStream;
import java.io.InputStream;
import java.security.KeyPairGenerator;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.mail.smime.validator.SignedMailValidator;
import org.bouncycastle.pkix.jcajce.PKIXCertPathReviewer;
import org.bouncycastle.pkix.util.ErrorBundle;
import org.bouncycastle.pkix.util.TextBundle;

public class ValidateSignedMail {
    public static final boolean useCaCerts = false;
    public static final int TITLE = 0;
    public static final int TEXT = 1;
    public static final int SUMMARY = 2;
    public static final int DETAIL = 3;
    static int dbgLvl = 3;
    private static final String RESOURCE_NAME = "org.bouncycastle.mail.smime.validator.SignedMailValidatorMessages";

    public static void main(String[] stringArray) throws Exception {
        Security.addProvider(new BouncyCastleProvider());
        Properties properties = System.getProperties();
        Session session = Session.getDefaultInstance((Properties)properties, null);
        MimeMessage mimeMessage = new MimeMessage(session, (InputStream)new FileInputStream("signed.message"));
        AbstractCollection abstractCollection = new HashSet<TrustAnchor>();
        Object object = ValidateSignedMail.getTrustAnchor("trustanchor");
        if (object == null) {
            System.out.println("no trustanchor file found, using a dummy trustanchor");
            object = ValidateSignedMail.getDummyTrustAnchor();
        }
        abstractCollection.add(object);
        PKIXParameters pKIXParameters = new PKIXParameters((Set<TrustAnchor>)((Object)abstractCollection));
        abstractCollection = new ArrayList();
        object = ValidateSignedMail.loadCRL("crl.file");
        if (object != null) {
            abstractCollection.add((Object)object);
        }
        CertStore certStore = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(abstractCollection), "BC");
        pKIXParameters.addCertStore(certStore);
        pKIXParameters.setRevocationEnabled(true);
        ValidateSignedMail.verifySignedMail(mimeMessage, pKIXParameters);
    }

    public static void verifySignedMail(MimeMessage mimeMessage, PKIXParameters pKIXParameters) throws Exception {
        Locale locale = Locale.ENGLISH;
        SignedMailValidator signedMailValidator = new SignedMailValidator(mimeMessage, pKIXParameters);
        for (SignerInformation signerInformation : signedMailValidator.getSignerInformationStore().getSigners()) {
            Object object;
            Iterator iterator3;
            Iterator iterator2;
            SignedMailValidator.ValidationResult validationResult = signedMailValidator.getValidationResult(signerInformation);
            if (validationResult.isValidSignature()) {
                iterator2 = new ErrorBundle(RESOURCE_NAME, "SignedMailValidator.sigValid");
                System.out.println(((TextBundle)((Object)iterator2)).getText(locale));
            } else {
                iterator2 = new ErrorBundle(RESOURCE_NAME, "SignedMailValidator.sigInvalid");
                System.out.println(((TextBundle)((Object)iterator2)).getText(locale));
                System.out.println("Errors:");
                for (Iterator iterator3 : validationResult.getErrors()) {
                    if (dbgLvl == 3) {
                        System.out.println("\t\t" + ((ErrorBundle)((Object)iterator3)).getDetail(locale));
                        continue;
                    }
                    System.out.println("\t\t" + ((TextBundle)((Object)iterator3)).getText(locale));
                }
            }
            if (!validationResult.getNotifications().isEmpty()) {
                System.out.println("Notifications:");
                iterator2 = validationResult.getNotifications().iterator();
                while (iterator2.hasNext()) {
                    Iterator iterator4 = (ErrorBundle)iterator2.next();
                    if (dbgLvl == 3) {
                        System.out.println("\t\t" + ((ErrorBundle)((Object)iterator4)).getDetail(locale));
                        continue;
                    }
                    System.out.println("\t\t" + ((TextBundle)((Object)iterator4)).getText(locale));
                }
            }
            if ((iterator2 = validationResult.getCertPathReview()) == null) continue;
            if (((PKIXCertPathReviewer)((Object)iterator2)).isValidCertPath()) {
                System.out.println("Certificate path valid");
            } else {
                System.out.println("Certificate path invalid");
            }
            System.out.println("\nCertificate path validation results:");
            System.out.println("Errors:");
            for (Iterator iterator3 : ((PKIXCertPathReviewer)((Object)iterator2)).getErrors(-1)) {
                if (dbgLvl == 3) {
                    System.out.println("\t\t" + ((ErrorBundle)((Object)iterator3)).getDetail(locale));
                    continue;
                }
                System.out.println("\t\t" + ((TextBundle)((Object)iterator3)).getText(locale));
            }
            System.out.println("Notifications:");
            iterator3 = ((PKIXCertPathReviewer)((Object)iterator2)).getNotifications(-1).iterator();
            while (iterator3.hasNext()) {
                object = (ErrorBundle)iterator3.next();
                System.out.println("\t" + ((TextBundle)object).getText(locale));
            }
            object = ((PKIXCertPathReviewer)((Object)iterator2)).getCertPath().getCertificates().iterator();
            int n = 0;
            while (object.hasNext()) {
                X509Certificate x509Certificate = (X509Certificate)object.next();
                System.out.println("\nCertificate " + n + "\n========");
                System.out.println("Issuer: " + x509Certificate.getIssuerDN().getName());
                System.out.println("Subject: " + x509Certificate.getSubjectDN().getName());
                System.out.println("\tErrors:");
                for (ErrorBundle errorBundle : ((PKIXCertPathReviewer)((Object)iterator2)).getErrors(n)) {
                    if (dbgLvl == 3) {
                        System.out.println("\t\t" + errorBundle.getDetail(locale));
                        continue;
                    }
                    System.out.println("\t\t" + errorBundle.getText(locale));
                }
                System.out.println("\tNotifications:");
                iterator3 = ((PKIXCertPathReviewer)((Object)iterator2)).getNotifications(n).iterator();
                while (iterator3.hasNext()) {
                    ErrorBundle errorBundle;
                    errorBundle = (ErrorBundle)iterator3.next();
                    if (dbgLvl == 3) {
                        System.out.println("\t\t" + errorBundle.getDetail(locale));
                        continue;
                    }
                    System.out.println("\t\t" + errorBundle.getText(locale));
                }
                ++n;
            }
        }
    }

    protected static TrustAnchor getTrustAnchor(String string) throws Exception {
        X509Certificate x509Certificate = ValidateSignedMail.loadCert(string);
        if (x509Certificate != null) {
            byte[] byArray = x509Certificate.getExtensionValue(Extension.nameConstraints.getId());
            if (byArray != null) {
                ASN1Primitive aSN1Primitive = JcaX509ExtensionUtils.parseExtensionValue(byArray);
                return new TrustAnchor(x509Certificate, aSN1Primitive.toASN1Primitive().getEncoded("DER"));
            }
            return new TrustAnchor(x509Certificate, null);
        }
        return null;
    }

    protected static X509Certificate loadCert(String string) {
        X509Certificate x509Certificate = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", "BC");
            x509Certificate = (X509Certificate)certificateFactory.generateCertificate(fileInputStream);
        }
        catch (Exception exception) {
            System.out.println("certfile \"" + string + "\" not found - classpath is " + System.getProperty("java.class.path"));
        }
        return x509Certificate;
    }

    protected static X509CRL loadCRL(String string) {
        X509CRL x509CRL = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", "BC");
            x509CRL = (X509CRL)certificateFactory.generateCRL(fileInputStream);
        }
        catch (Exception exception) {
            System.out.println("crlfile \"" + string + "\" not found - classpath is " + System.getProperty("java.class.path"));
        }
        return x509CRL;
    }

    private static TrustAnchor getDummyTrustAnchor() throws Exception {
        X500Principal x500Principal = new X500Principal("CN=Dummy Trust Anchor");
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", "BC");
        keyPairGenerator.initialize(1024, new SecureRandom());
        PublicKey publicKey = keyPairGenerator.generateKeyPair().getPublic();
        return new TrustAnchor(x500Principal, publicKey, null);
    }
}

