/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.debugger.streampane;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ExecutionException;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingWorker;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import org.apache.pdfbox.contentstream.operator.Operator;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSBoolean;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.debugger.hexviewer.HexView;
import org.apache.pdfbox.debugger.streampane.Stream;
import org.apache.pdfbox.debugger.streampane.StreamPaneView;
import org.apache.pdfbox.debugger.streampane.tooltip.ToolTipController;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.pdfparser.PDFStreamParser;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.util.Charsets;

public class StreamPane
implements ActionListener {
    @Deprecated
    public static final String BEGIN_TEXT_OBJECT = "BT";
    @Deprecated
    public static final String END_TEXT_OBJECT = "ET";
    @Deprecated
    public static final String SAVE_GRAPHICS_STATE = "q";
    @Deprecated
    public static final String RESTORE_GRAPHICS_STATE = "Q";
    @Deprecated
    public static final String INLINE_IMAGE_BEGIN = "BI";
    @Deprecated
    public static final String IMAGE_DATA = "ID";
    @Deprecated
    public static final String INLINE_IMAGE_END = "EI";
    @Deprecated
    public static final String BEGIN_MARKED_CONTENT1 = "BMC";
    @Deprecated
    public static final String BEGIN_MARKED_CONTENT2 = "BDC";
    @Deprecated
    public static final String END_MARKED_CONTENT = "EMC";
    private static final StyleContext CONTEXT = StyleContext.getDefaultStyleContext();
    private static final Style OPERATOR_STYLE = CONTEXT.addStyle("operator", null);
    private static final Style NUMBER_STYLE = CONTEXT.addStyle("number", null);
    private static final Style STRING_STYLE = CONTEXT.addStyle("string", null);
    private static final Style ESCAPE_STYLE = CONTEXT.addStyle("escape", null);
    private static final Style NAME_STYLE = CONTEXT.addStyle("name", null);
    private static final Style INLINE_IMAGE_STYLE = CONTEXT.addStyle("inline_image", null);
    private final JPanel panel;
    private final HexView hexView;
    private final JTabbedPane tabbedPane;
    private final StreamPaneView view;
    private final Stream stream;
    private ToolTipController tTController;
    private PDResources resources;
    private final boolean isContentStream;

    public StreamPane(COSStream cosStream, boolean isContentStream, boolean isThumb, COSDictionary resourcesDic) throws IOException {
        this.isContentStream = isContentStream;
        this.stream = new Stream(cosStream, isThumb);
        if (resourcesDic != null) {
            this.resources = new PDResources(resourcesDic);
            this.tTController = new ToolTipController(this.resources);
        }
        this.panel = new JPanel();
        this.panel.setPreferredSize(new Dimension(300, 500));
        this.panel.setLayout(new BoxLayout(this.panel, 1));
        this.view = new StreamPaneView();
        this.hexView = new HexView();
        if (this.stream.isImage()) {
            this.panel.add(this.createHeaderPanel(this.stream.getFilterList(), "Image", this));
            this.requestImageShowing();
        } else {
            this.panel.add(this.createHeaderPanel(this.stream.getFilterList(), "Unfiltered", this));
            this.requestStreamText("Unfiltered");
        }
        this.tabbedPane = new JTabbedPane();
        if (this.stream.isImage()) {
            this.tabbedPane.add("Image view", this.view.getStreamPanel());
        } else {
            this.tabbedPane.add("Text view", this.view.getStreamPanel());
            this.tabbedPane.add("Hex view", this.hexView.getPane());
        }
        this.panel.add(this.tabbedPane);
    }

    public JComponent getPanel() {
        return this.panel;
    }

    private JPanel createHeaderPanel(List<String> availableFilters, String i, ActionListener actionListener) {
        JComboBox<String> filters = new JComboBox<String>(new Vector<String>(availableFilters));
        filters.setSelectedItem(i);
        filters.addActionListener(actionListener);
        JPanel headerPanel = new JPanel(new FlowLayout());
        headerPanel.add(filters);
        return headerPanel;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if ("comboBoxChanged".equals(actionEvent.getActionCommand())) {
            JComboBox comboBox = (JComboBox)actionEvent.getSource();
            String currentFilter = (String)comboBox.getSelectedItem();
            try {
                if (currentFilter.equals("Image")) {
                    this.requestImageShowing();
                    this.tabbedPane.removeAll();
                    this.tabbedPane.add("Image view", this.view.getStreamPanel());
                    return;
                }
                this.tabbedPane.removeAll();
                this.tabbedPane.add("Text view", this.view.getStreamPanel());
                this.tabbedPane.add("Hex view", this.hexView.getPane());
                this.requestStreamText(currentFilter);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestImageShowing() throws IOException {
        if (this.stream.isImage()) {
            BufferedImage image;
            Stream stream = this.stream;
            synchronized (stream) {
                image = this.stream.getImage(this.resources);
            }
            if (image == null) {
                JOptionPane.showMessageDialog(this.panel, "image not available (filter missing?)");
                return;
            }
            this.view.showStreamImage(image);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestStreamText(String command) throws IOException {
        new DocumentCreator(command).execute();
        Stream stream = this.stream;
        synchronized (stream) {
            InputStream is = this.stream.getStream(command);
            if (is == null) {
                JOptionPane.showMessageDialog(this.panel, command + " text not available (filter missing?)");
                return;
            }
            this.hexView.changeData(IOUtils.toByteArray(is));
        }
    }

    static {
        StyleConstants.setForeground(OPERATOR_STYLE, new Color(25, 55, 156));
        StyleConstants.setForeground(NUMBER_STYLE, new Color(51, 86, 18));
        StyleConstants.setForeground(STRING_STYLE, new Color(128, 35, 32));
        StyleConstants.setForeground(ESCAPE_STYLE, new Color(179, 49, 36));
        StyleConstants.setForeground(NAME_STYLE, new Color(140, 38, 145));
        StyleConstants.setForeground(INLINE_IMAGE_STYLE, new Color(116, 113, 39));
    }

    private final class DocumentCreator
    extends SwingWorker<StyledDocument, Integer> {
        private final String filterKey;
        private int indent;
        private boolean needIndent;

        private DocumentCreator(String filterKey) {
            this.filterKey = filterKey;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected StyledDocument doInBackground() {
            String encoding = "ISO-8859-1";
            Stream stream = StreamPane.this.stream;
            synchronized (stream) {
                if (StreamPane.this.stream.isXmlMetadata()) {
                    encoding = "UTF-8";
                }
                InputStream inputStream = StreamPane.this.stream.getStream(this.filterKey);
                if (StreamPane.this.isContentStream && "Unfiltered".equals(this.filterKey)) {
                    StyledDocument document = this.getContentStreamDocument(inputStream);
                    if (document != null) {
                        return document;
                    }
                    return this.getDocument(StreamPane.this.stream.getStream(this.filterKey), encoding);
                }
                return this.getDocument(inputStream, encoding);
            }
        }

        @Override
        protected void done() {
            try {
                StreamPane.this.view.showStreamText((StyledDocument)this.get(), StreamPane.this.tTController);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }

        private String getStringOfStream(InputStream in, String encoding) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                IOUtils.copy(in, baos);
                return baos.toString(encoding);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }

        private StyledDocument getDocument(InputStream inputStream, String encoding) {
            DefaultStyledDocument docu = new DefaultStyledDocument();
            if (inputStream != null) {
                String data = this.getStringOfStream(inputStream, encoding);
                try {
                    docu.insertString(0, data, null);
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
            }
            return docu;
        }

        private StyledDocument getContentStreamDocument(InputStream inputStream) {
            PDFStreamParser parser;
            DefaultStyledDocument docu = new DefaultStyledDocument();
            try {
                parser = new PDFStreamParser(IOUtils.toByteArray(inputStream));
                parser.parse();
            }
            catch (IOException e) {
                return null;
            }
            for (Object obj : parser.getTokens()) {
                this.writeToken(obj, docu);
            }
            return docu;
        }

        private void writeToken(Object obj, StyledDocument docu) {
            try {
                if (obj instanceof Operator) {
                    this.addOperators(obj, docu);
                } else {
                    this.writeOperand(obj, docu);
                }
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }

        private void writeOperand(Object obj, StyledDocument docu) throws BadLocationException {
            this.writeIndent(docu);
            if (obj instanceof COSName) {
                String str = "/" + ((COSName)obj).getName();
                docu.insertString(docu.getLength(), str + " ", NAME_STYLE);
            } else if (obj instanceof COSBoolean) {
                String str = obj.toString();
                docu.insertString(docu.getLength(), str + " ", null);
            } else if (obj instanceof COSArray) {
                docu.insertString(docu.getLength(), "[ ", null);
                for (COSBase elem : (COSArray)obj) {
                    this.writeOperand(elem, docu);
                }
                docu.insertString(docu.getLength(), "] ", null);
            } else if (obj instanceof COSString) {
                byte[] bytes;
                docu.insertString(docu.getLength(), "(", null);
                for (byte b : bytes = ((COSString)obj).getBytes()) {
                    String str;
                    int chr = b & 0xFF;
                    if (chr < 32 || chr > 126) {
                        str = String.format("\\%03o", chr);
                        docu.insertString(docu.getLength(), str, ESCAPE_STYLE);
                        continue;
                    }
                    if (chr == 40 || chr == 41 || chr == 10 || chr == 13 || chr == 9 || chr == 8 || chr == 12 || chr == 92) {
                        str = "\\" + (char)chr;
                        docu.insertString(docu.getLength(), str, ESCAPE_STYLE);
                        continue;
                    }
                    str = "" + (char)chr;
                    docu.insertString(docu.getLength(), str, STRING_STYLE);
                }
                docu.insertString(docu.getLength(), ") ", null);
            } else if (obj instanceof COSNumber) {
                String str = obj instanceof COSFloat ? Float.toString(((COSFloat)obj).floatValue()) : Integer.toString(((COSNumber)obj).intValue());
                docu.insertString(docu.getLength(), str + " ", NUMBER_STYLE);
            } else if (obj instanceof COSDictionary) {
                docu.insertString(docu.getLength(), "<< ", null);
                COSDictionary dict = (COSDictionary)obj;
                for (Map.Entry<COSName, COSBase> entry : dict.entrySet()) {
                    this.writeOperand(entry.getKey(), docu);
                    this.writeOperand(entry.getValue(), docu);
                }
                docu.insertString(docu.getLength(), ">> ", null);
            } else {
                String str = obj.toString();
                str = str.substring(str.indexOf(123) + 1, str.length() - 1);
                docu.insertString(docu.getLength(), str + " ", null);
            }
        }

        private void addOperators(Object obj, StyledDocument docu) throws BadLocationException {
            Operator op = (Operator)obj;
            if (op.getName().equals(StreamPane.END_TEXT_OBJECT) || op.getName().equals(StreamPane.RESTORE_GRAPHICS_STATE) || op.getName().equals(StreamPane.END_MARKED_CONTENT)) {
                --this.indent;
            }
            this.writeIndent(docu);
            if (op.getName().equals(StreamPane.INLINE_IMAGE_BEGIN)) {
                docu.insertString(docu.getLength(), "BI\n", OPERATOR_STYLE);
                COSDictionary dic = op.getImageParameters();
                for (COSName key : dic.keySet()) {
                    COSBase value = dic.getDictionaryObject(key);
                    docu.insertString(docu.getLength(), "/" + key.getName() + " ", null);
                    this.writeToken(value, docu);
                    docu.insertString(docu.getLength(), "\n", null);
                }
                String imageString = new String(op.getImageData(), Charsets.ISO_8859_1);
                docu.insertString(docu.getLength(), "ID\n", INLINE_IMAGE_STYLE);
                docu.insertString(docu.getLength(), imageString, null);
                docu.insertString(docu.getLength(), "\n", null);
                docu.insertString(docu.getLength(), "EI\n", OPERATOR_STYLE);
            } else {
                String operator = ((Operator)obj).getName();
                docu.insertString(docu.getLength(), operator + "\n", OPERATOR_STYLE);
                if (op.getName().equals(StreamPane.BEGIN_TEXT_OBJECT) || op.getName().equals(StreamPane.SAVE_GRAPHICS_STATE) || op.getName().equals(StreamPane.BEGIN_MARKED_CONTENT1) || op.getName().equals(StreamPane.BEGIN_MARKED_CONTENT2)) {
                    ++this.indent;
                }
            }
            this.needIndent = true;
        }

        void writeIndent(StyledDocument docu) throws BadLocationException {
            if (this.needIndent) {
                for (int i = 0; i < this.indent; ++i) {
                    docu.insertString(docu.getLength(), "  ", null);
                }
                this.needIndent = false;
            }
        }
    }
}

