/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.reader;

import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.Decimal;
import org.apache.paimon.data.InternalArray;
import org.apache.paimon.data.InternalMap;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.data.variant.Variant;
import org.apache.paimon.types.RowKind;

public class DataEvolutionRow
implements InternalRow {
    private final InternalRow[] rows;
    private final int[] rowOffsets;
    private final int[] fieldOffsets;

    public DataEvolutionRow(int rowNumber, int[] rowOffsets, int[] fieldOffsets) {
        this.rows = new InternalRow[rowNumber];
        this.rowOffsets = rowOffsets;
        this.fieldOffsets = fieldOffsets;
    }

    public int rowNumber() {
        return this.rows.length;
    }

    public void setRow(int pos, InternalRow row) {
        if (pos >= this.rows.length) {
            throw new IndexOutOfBoundsException("Position " + pos + " is out of bounds for rows size " + this.rows.length);
        }
        this.rows[pos] = row;
    }

    private InternalRow chooseRow(int pos) {
        return this.rows[this.rowOffsets[pos]];
    }

    private int offsetInRow(int pos) {
        return this.fieldOffsets[pos];
    }

    @Override
    public int getFieldCount() {
        return this.fieldOffsets.length;
    }

    @Override
    public RowKind getRowKind() {
        return this.rows[0].getRowKind();
    }

    @Override
    public void setRowKind(RowKind kind) {
        this.rows[0].setRowKind(kind);
    }

    @Override
    public boolean isNullAt(int pos) {
        if (this.rowOffsets[pos] == -1) {
            return true;
        }
        return this.chooseRow(pos).isNullAt(this.offsetInRow(pos));
    }

    @Override
    public boolean getBoolean(int pos) {
        return this.chooseRow(pos).getBoolean(this.offsetInRow(pos));
    }

    @Override
    public byte getByte(int pos) {
        return this.chooseRow(pos).getByte(this.offsetInRow(pos));
    }

    @Override
    public short getShort(int pos) {
        return this.chooseRow(pos).getShort(this.offsetInRow(pos));
    }

    @Override
    public int getInt(int pos) {
        return this.chooseRow(pos).getInt(this.offsetInRow(pos));
    }

    @Override
    public long getLong(int pos) {
        return this.chooseRow(pos).getLong(this.offsetInRow(pos));
    }

    @Override
    public float getFloat(int pos) {
        return this.chooseRow(pos).getFloat(this.offsetInRow(pos));
    }

    @Override
    public double getDouble(int pos) {
        return this.chooseRow(pos).getDouble(this.offsetInRow(pos));
    }

    @Override
    public BinaryString getString(int pos) {
        return this.chooseRow(pos).getString(this.offsetInRow(pos));
    }

    @Override
    public Decimal getDecimal(int pos, int precision, int scale) {
        return this.chooseRow(pos).getDecimal(this.offsetInRow(pos), precision, scale);
    }

    @Override
    public Timestamp getTimestamp(int pos, int precision) {
        return this.chooseRow(pos).getTimestamp(this.offsetInRow(pos), precision);
    }

    @Override
    public byte[] getBinary(int pos) {
        return this.chooseRow(pos).getBinary(this.offsetInRow(pos));
    }

    @Override
    public Variant getVariant(int pos) {
        return this.chooseRow(pos).getVariant(this.offsetInRow(pos));
    }

    @Override
    public InternalArray getArray(int pos) {
        return this.chooseRow(pos).getArray(this.offsetInRow(pos));
    }

    @Override
    public InternalMap getMap(int pos) {
        return this.chooseRow(pos).getMap(this.offsetInRow(pos));
    }

    @Override
    public InternalRow getRow(int pos, int numFields) {
        return this.chooseRow(pos).getRow(this.offsetInRow(pos), numFields);
    }
}

