/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format;

import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.paimon.options.description.DescribedEnum;
import org.apache.paimon.options.description.InlineElement;
import org.apache.paimon.options.description.TextElement;

public enum HadoopCompressionType implements DescribedEnum
{
    NONE("none", "No compression.", null, null),
    GZIP("gzip", "GZIP compression using the deflate algorithm.", "org.apache.hadoop.io.compress.GzipCodec", "gz"),
    BZIP2("bzip2", "BZIP2 compression using the Burrows-Wheeler algorithm.", "org.apache.hadoop.io.compress.BZip2Codec", "bz2"),
    DEFLATE("deflate", "DEFLATE compression using the deflate algorithm.", "org.apache.hadoop.io.compress.DeflateCodec", "deflate"),
    SNAPPY("snappy", "Snappy compression for fast compression and decompression.", "org.apache.hadoop.io.compress.SnappyCodec", "snappy"),
    LZ4("lz4", "LZ4 compression for very fast compression and decompression.", "org.apache.hadoop.io.compress.Lz4Codec", "lz4"),
    ZSTD("zstd", "Zstandard compression for high compression ratio and speed.", "org.apache.hadoop.io.compress.ZStandardCodec", "zst");

    private final String value;
    private final String description;
    @Nullable
    private final String className;
    @Nullable
    private final String fileExtension;

    private HadoopCompressionType(@Nullable String value, @Nullable String description, String className, String fileExtension) {
        this.value = value;
        this.description = description;
        this.className = className;
        this.fileExtension = fileExtension;
    }

    public String toString() {
        return this.value;
    }

    public InlineElement getDescription() {
        return TextElement.text((String)this.description);
    }

    public String value() {
        return this.value;
    }

    @Nullable
    public String hadoopCodecClassName() {
        return this.className;
    }

    @Nullable
    public String fileExtension() {
        return this.fileExtension;
    }

    public static Optional<HadoopCompressionType> fromValue(String value) {
        for (HadoopCompressionType type : HadoopCompressionType.values()) {
            if (!type.value.equalsIgnoreCase(value)) continue;
            return Optional.of(type);
        }
        return Optional.empty();
    }

    public static boolean isCompressExtension(String extension) {
        for (HadoopCompressionType type : HadoopCompressionType.values()) {
            if (!extension.equalsIgnoreCase(type.fileExtension)) continue;
            return true;
        }
        return false;
    }
}

