/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.fileindex.rangebitmap.dictionary.chunked;

import java.util.Comparator;
import org.apache.paimon.fileindex.rangebitmap.dictionary.chunked.Chunk;

public abstract class AbstractChunk
implements Chunk {
    private final Comparator<Object> comparator;

    public AbstractChunk(Comparator<Object> comparator) {
        this.comparator = comparator;
    }

    @Override
    public int find(Object key) {
        if (this.comparator.compare(this.key(), key) == 0) {
            return this.code();
        }
        int low = 0;
        int high = this.size() - 1;
        int base = this.code() + 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int result = this.comparator.compare(this.get(mid), key);
            if (result > 0) {
                high = mid - 1;
                continue;
            }
            if (result < 0) {
                low = mid + 1;
                continue;
            }
            return base + mid;
        }
        return -(base + low + 1);
    }

    @Override
    public Object find(int code) {
        int current = this.code();
        if (current == code) {
            return this.key();
        }
        int index = code - current - 1;
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException("invalid code: " + code);
        }
        return this.get(index);
    }

    protected abstract int size();

    protected abstract Object get(int var1);
}

