/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.fileindex.rangebitmap;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import org.apache.paimon.fileindex.rangebitmap.BitSliceIndexBitmap;
import org.apache.paimon.fileindex.rangebitmap.dictionary.Dictionary;
import org.apache.paimon.fileindex.rangebitmap.dictionary.chunked.ChunkedDictionary;
import org.apache.paimon.fileindex.rangebitmap.dictionary.chunked.KeyFactory;
import org.apache.paimon.fs.SeekableInputStream;
import org.apache.paimon.predicate.SortValue;
import org.apache.paimon.utils.IOUtils;
import org.apache.paimon.utils.RoaringBitmap32;

public class RangeBitmap {
    public static final int VERSION_1 = 1;
    public static final byte CURRENT_VERSION = 1;
    private final int rid;
    @Nullable
    private final Object min;
    @Nullable
    private final Object max;
    private final int cardinality;
    private final int dictionaryOffset;
    private final int bsiOffset;
    private final SeekableInputStream in;
    private final KeyFactory factory;
    private final Comparator<Object> comparator;
    private Dictionary dictionary;
    private BitSliceIndexBitmap bsi;

    public RangeBitmap(SeekableInputStream in, int offset, KeyFactory factory) {
        ByteBuffer headers;
        int headerLength;
        try {
            in.seek(offset);
            byte[] headerLengthInBytes = new byte[4];
            IOUtils.readFully((InputStream)in, headerLengthInBytes);
            headerLength = ByteBuffer.wrap(headerLengthInBytes).getInt();
            byte[] headerInBytes = new byte[headerLength];
            IOUtils.readFully((InputStream)in, headerInBytes);
            headers = ByteBuffer.wrap(headerInBytes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        KeyFactory.KeyDeserializer deserializer = factory.createDeserializer();
        byte version = headers.get();
        if (version > 1) {
            throw new RuntimeException("Invalid version " + version);
        }
        this.rid = headers.getInt();
        this.cardinality = headers.getInt();
        this.min = this.cardinality <= 0 ? null : deserializer.deserialize(headers);
        this.max = this.cardinality <= 0 ? null : deserializer.deserialize(headers);
        int dictionaryLength = headers.getInt();
        this.dictionaryOffset = offset + 4 + headerLength;
        this.bsiOffset = this.dictionaryOffset + dictionaryLength;
        this.in = in;
        this.factory = factory;
        this.comparator = factory.createComparator();
    }

    public RoaringBitmap32 eq(Object key) {
        if (this.cardinality <= 0) {
            return new RoaringBitmap32();
        }
        int compareMin = this.comparator.compare(key, this.min);
        int compareMax = this.comparator.compare(key, this.max);
        if (compareMin == 0 && compareMax == 0) {
            return this.isNotNull();
        }
        if (compareMin < 0 || compareMax > 0) {
            return new RoaringBitmap32();
        }
        int code = this.getDictionary().find(key);
        if (code < 0) {
            return new RoaringBitmap32();
        }
        return this.getBitSliceIndexBitmap().eq(code);
    }

    public RoaringBitmap32 neq(Object key) {
        if (this.cardinality <= 0) {
            return new RoaringBitmap32();
        }
        return this.not(this.eq(key));
    }

    public RoaringBitmap32 lte(Object key) {
        if (this.cardinality <= 0) {
            return new RoaringBitmap32();
        }
        int compareMin = this.comparator.compare(key, this.min);
        int compareMax = this.comparator.compare(key, this.max);
        if (compareMax >= 0) {
            return this.isNotNull();
        }
        if (compareMin < 0) {
            return new RoaringBitmap32();
        }
        return this.not(this.gt(key));
    }

    public RoaringBitmap32 lt(Object key) {
        if (this.cardinality <= 0) {
            return new RoaringBitmap32();
        }
        int compareMin = this.comparator.compare(key, this.min);
        int compareMax = this.comparator.compare(key, this.max);
        if (compareMax > 0) {
            return this.isNotNull();
        }
        if (compareMin <= 0) {
            return new RoaringBitmap32();
        }
        return this.not(this.gte(key));
    }

    public RoaringBitmap32 gte(Object key) {
        if (this.cardinality <= 0) {
            return new RoaringBitmap32();
        }
        int compareMin = this.comparator.compare(key, this.min);
        int compareMax = this.comparator.compare(key, this.max);
        if (compareMin <= 0) {
            return this.isNotNull();
        }
        if (compareMax > 0) {
            return new RoaringBitmap32();
        }
        int code = this.getDictionary().find(key);
        return code < 0 ? this.getBitSliceIndexBitmap().gte(-code - 1) : this.getBitSliceIndexBitmap().gte(code);
    }

    public RoaringBitmap32 gt(Object key) {
        if (this.cardinality <= 0) {
            return new RoaringBitmap32();
        }
        int compareMin = this.comparator.compare(key, this.min);
        int compareMax = this.comparator.compare(key, this.max);
        if (compareMin < 0) {
            return this.isNotNull();
        }
        if (compareMax >= 0) {
            return new RoaringBitmap32();
        }
        int code = this.getDictionary().find(key);
        return code < 0 ? this.getBitSliceIndexBitmap().gte(-code - 1) : this.getBitSliceIndexBitmap().gt(code);
    }

    public RoaringBitmap32 in(List<Object> keys) {
        if (this.cardinality <= 0) {
            return new RoaringBitmap32();
        }
        RoaringBitmap32 bitmap = new RoaringBitmap32();
        for (Object key : keys) {
            bitmap.or(this.eq(key));
        }
        return bitmap;
    }

    public RoaringBitmap32 notIn(List<Object> keys) {
        if (this.cardinality <= 0) {
            return new RoaringBitmap32();
        }
        return this.not(this.in(keys));
    }

    public RoaringBitmap32 isNull() {
        return this.isNull(null);
    }

    public RoaringBitmap32 isNotNull() {
        if (this.cardinality <= 0) {
            return new RoaringBitmap32();
        }
        return this.getBitSliceIndexBitmap().isNotNull();
    }

    private RoaringBitmap32 isNull(@Nullable RoaringBitmap32 foundSet) {
        if (this.cardinality <= 0) {
            return this.rid > 0 ? RoaringBitmap32.bitmapOf(0, this.rid - 1) : new RoaringBitmap32();
        }
        if (foundSet != null && foundSet.isEmpty()) {
            return foundSet;
        }
        RoaringBitmap32 bitmap = this.isNotNull();
        bitmap.flip(0L, this.rid);
        if (foundSet != null) {
            bitmap.and(foundSet);
        }
        return bitmap;
    }

    public Object get(int position) {
        if (position < 0 || position >= this.rid) {
            return null;
        }
        Integer code = this.getBitSliceIndexBitmap().get(position);
        if (code == null) {
            return null;
        }
        return this.getDictionary().find(code);
    }

    private RoaringBitmap32 not(RoaringBitmap32 bitmap) {
        bitmap.flip(0L, this.rid);
        bitmap.and(this.isNotNull());
        return bitmap;
    }

    private Dictionary getDictionary() {
        if (this.dictionary == null) {
            try {
                this.dictionary = new ChunkedDictionary(this.in, this.dictionaryOffset, this.factory);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.dictionary;
    }

    private BitSliceIndexBitmap getBitSliceIndexBitmap() {
        if (this.bsi == null) {
            try {
                this.bsi = new BitSliceIndexBitmap(this.in, this.bsiOffset);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.bsi;
    }

    public RoaringBitmap32 topK(int k, SortValue.NullOrdering nullOrdering, @Nullable RoaringBitmap32 foundSet, boolean strict) {
        return this.fillNulls(k, nullOrdering, foundSet, (l, r) -> this.getBitSliceIndexBitmap().topK((int)l, (RoaringBitmap32)r, strict));
    }

    public RoaringBitmap32 bottomK(int k, SortValue.NullOrdering nullOrdering, @Nullable RoaringBitmap32 foundSet, boolean strict) {
        return this.fillNulls(k, nullOrdering, foundSet, (l, r) -> this.getBitSliceIndexBitmap().bottomK((int)l, (RoaringBitmap32)r, strict));
    }

    private RoaringBitmap32 fillNulls(int k, SortValue.NullOrdering nullOrdering, @Nullable RoaringBitmap32 foundSet, BiFunction<Integer, RoaringBitmap32, RoaringBitmap32> function) {
        RoaringBitmap32 bitmap;
        if (this.cardinality <= 0) {
            return this.rid > 0 ? RoaringBitmap32.bitmapOf(0, this.rid - 1) : new RoaringBitmap32();
        }
        if (SortValue.NullOrdering.NULLS_LAST.equals((Object)nullOrdering)) {
            bitmap = function.apply(k, foundSet);
            long cardinality = bitmap.getCardinality();
            if (cardinality >= (long)k) {
                return bitmap;
            }
            bitmap.or(this.isNull(foundSet).limit((int)((long)k - cardinality)));
        } else {
            bitmap = this.isNull(foundSet);
            long cardinality = bitmap.getCardinality();
            if (cardinality >= (long)k) {
                return bitmap.limit(k);
            }
            bitmap.or(function.apply((int)((long)k - cardinality), foundSet));
        }
        return bitmap;
    }

    public static class Appender {
        private int rid = 0;
        private final TreeMap<Object, RoaringBitmap32> bitmaps;
        private final KeyFactory factory;
        private final int limitedSerializedSizeInBytes;

        public Appender(KeyFactory factory, int limitedSerializedSizeInBytes) {
            this.bitmaps = new TreeMap(factory.createComparator());
            this.factory = factory;
            this.limitedSerializedSizeInBytes = limitedSerializedSizeInBytes;
        }

        public void append(Object key) {
            if (key != null) {
                this.bitmaps.computeIfAbsent(key, x -> new RoaringBitmap32()).add(this.rid);
            }
            ++this.rid;
        }

        public byte[] serialize() {
            int code = 0;
            BitSliceIndexBitmap.Appender bsi = new BitSliceIndexBitmap.Appender(0, this.bitmaps.size() - 1);
            ChunkedDictionary.Appender dictionary = new ChunkedDictionary.Appender(this.factory, this.limitedSerializedSizeInBytes);
            for (Map.Entry<Object, RoaringBitmap32> entry : this.bitmaps.entrySet()) {
                Object key = entry.getKey();
                RoaringBitmap32 bitmap = entry.getValue();
                dictionary.sortedAppend(key, code);
                Iterator<Integer> iterator = bitmap.iterator();
                while (iterator.hasNext()) {
                    bsi.append(iterator.next(), code);
                }
                ++code;
            }
            KeyFactory.KeySerializer serializer = this.factory.createSerializer();
            Object min = this.bitmaps.isEmpty() ? null : this.bitmaps.firstKey();
            Object max = this.bitmaps.isEmpty() ? null : this.bitmaps.lastKey();
            int headerSize = 0;
            ++headerSize;
            headerSize += 4;
            headerSize += 4;
            headerSize += min == null ? 0 : serializer.serializedSizeInBytes(min);
            headerSize += max == null ? 0 : serializer.serializedSizeInBytes(max);
            byte[] dictionarySerializeInBytes = dictionary.serialize();
            int dictionaryLength = dictionarySerializeInBytes.length;
            ByteBuffer bsiBuffer = bsi.serialize();
            int bsiLength = bsiBuffer.array().length;
            ByteBuffer buffer = ByteBuffer.allocate(4 + (headerSize += 4) + dictionaryLength + bsiLength);
            buffer.putInt(headerSize);
            buffer.put((byte)1);
            buffer.putInt(this.rid);
            buffer.putInt(this.bitmaps.size());
            if (min != null) {
                serializer.serialize(buffer, min);
            }
            if (max != null) {
                serializer.serialize(buffer, max);
            }
            buffer.putInt(dictionaryLength);
            buffer.put(dictionarySerializeInBytes);
            buffer.put(bsiBuffer.array());
            return buffer.array();
        }
    }
}

