/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.data.columnar.heap;

import org.apache.paimon.data.InternalArray;
import org.apache.paimon.data.columnar.ArrayColumnVector;
import org.apache.paimon.data.columnar.ColumnVector;
import org.apache.paimon.data.columnar.ColumnarArray;
import org.apache.paimon.data.columnar.heap.HeapArrayVector;

public class CastedArrayColumnVector
implements ArrayColumnVector {
    private final HeapArrayVector heapArrayVector;
    private final ColumnVector[] children;

    public CastedArrayColumnVector(HeapArrayVector heapArrayVector, ColumnVector[] children) {
        this.heapArrayVector = heapArrayVector;
        this.children = children;
    }

    @Override
    public InternalArray getArray(int i) {
        long offset = this.heapArrayVector.offsets[i];
        long length = this.heapArrayVector.lengths[i];
        return new ColumnarArray(this.children[0], (int)offset, (int)length);
    }

    @Override
    public ColumnVector getColumnVector() {
        return this.children[0];
    }

    @Override
    public boolean isNullAt(int i) {
        return this.heapArrayVector.isNullAt(i);
    }

    @Override
    public int getCapacity() {
        return this.heapArrayVector.getCapacity();
    }

    @Override
    public ColumnVector[] getChildren() {
        return this.children;
    }
}

