/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.casting;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.paimon.casting.AbstractCastRule;
import org.apache.paimon.casting.CastExecutor;
import org.apache.paimon.casting.CastExecutors;
import org.apache.paimon.casting.CastRulePredicate;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.GenericArray;
import org.apache.paimon.data.InternalArray;
import org.apache.paimon.types.ArrayType;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeFamily;
import org.apache.paimon.types.DataTypeRoot;
import org.apache.paimon.types.VarCharType;
import org.apache.paimon.utils.StringUtils;

class StringToArrayCastRule
extends AbstractCastRule<BinaryString, InternalArray> {
    static final StringToArrayCastRule INSTANCE = new StringToArrayCastRule();
    private static final Pattern BRACKET_ARRAY_PATTERN = Pattern.compile("^\\s*\\[(.*)\\]\\s*$");
    private static final Pattern FUNCTION_ARRAY_PATTERN = Pattern.compile("^\\s*ARRAY\\s*\\((.*)\\)\\s*$", 2);

    private StringToArrayCastRule() {
        super(CastRulePredicate.builder().input(DataTypeFamily.CHARACTER_STRING).target(DataTypeRoot.ARRAY).build());
    }

    @Override
    public CastExecutor<BinaryString, InternalArray> create(DataType inputType, DataType targetType) {
        ArrayType arrayType = (ArrayType)targetType;
        CastExecutor<?, ?> elementCastExecutor = CastExecutors.resolve((DataType)VarCharType.STRING_TYPE, arrayType.getElementType());
        if (elementCastExecutor == null) {
            throw new RuntimeException("Cannot cast string to array element type: " + arrayType.getElementType());
        }
        return value -> this.parseArray((BinaryString)value, (CastExecutor<BinaryString, Object>)elementCastExecutor);
    }

    private InternalArray parseArray(BinaryString value, CastExecutor<BinaryString, Object> elementCastExecutor) {
        try {
            String str = value.toString().trim();
            if ("[]".equals(str) || "ARRAY()".equalsIgnoreCase(str)) {
                return new GenericArray(new Object[0]);
            }
            String content = this.extractArrayContent(str);
            if (content.isEmpty()) {
                return new GenericArray(new Object[0]);
            }
            List<Object> elements = this.parseArrayElements(content, elementCastExecutor);
            return new GenericArray(elements.toArray());
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot parse '" + value + "' as ARRAY: " + e.getMessage(), e);
        }
    }

    private String extractArrayContent(String str) {
        Matcher bracketMatcher = BRACKET_ARRAY_PATTERN.matcher(str);
        if (bracketMatcher.matches()) {
            return bracketMatcher.group(1).trim();
        }
        Matcher functionMatcher = FUNCTION_ARRAY_PATTERN.matcher(str);
        if (functionMatcher.matches()) {
            return functionMatcher.group(1).trim();
        }
        throw new RuntimeException("Invalid array format: " + str + ". Expected format: [a, b, c] or ARRAY(a, b, c)");
    }

    private List<Object> parseArrayElements(String content, CastExecutor<BinaryString, Object> elementCastExecutor) {
        ArrayList<Object> elements = new ArrayList<Object>();
        for (String token : this.splitArrayElements(content)) {
            String trimmedToken = token.trim();
            Object element = "null".equals(trimmedToken) ? null : elementCastExecutor.cast(BinaryString.fromString(trimmedToken));
            elements.add(element);
        }
        return elements;
    }

    private List<String> splitArrayElements(String content) {
        ArrayList<String> elements = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        Stack<Character> bracketStack = new Stack<Character>();
        boolean inQuotes = false;
        boolean escaped = false;
        for (char c : content.toCharArray()) {
            if (escaped) {
                escaped = false;
            } else if (c == '\\') {
                escaped = true;
            } else if (c == '\"') {
                inQuotes = !inQuotes;
            } else if (!inQuotes) {
                if (StringUtils.isOpenBracket((char)c)) {
                    bracketStack.push(Character.valueOf(c));
                } else if (StringUtils.isCloseBracket((char)c) && !bracketStack.isEmpty()) {
                    bracketStack.pop();
                } else if (c == ',' && bracketStack.isEmpty()) {
                    this.addCurrentElement(elements, current);
                    continue;
                }
            }
            current.append(c);
        }
        this.addCurrentElement(elements, current);
        return elements;
    }

    private void addCurrentElement(List<String> elements, StringBuilder current) {
        if (current.length() > 0) {
            elements.add(current.toString());
            current.setLength(0);
        }
    }
}

