/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.rest;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.PagedList;
import org.apache.paimon.Snapshot;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.CatalogContext;
import org.apache.paimon.catalog.CatalogUtils;
import org.apache.paimon.catalog.Database;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.catalog.PropertyChange;
import org.apache.paimon.catalog.TableMetadata;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.function.Function;
import org.apache.paimon.function.FunctionChange;
import org.apache.paimon.options.CatalogOptions;
import org.apache.paimon.partition.Partition;
import org.apache.paimon.partition.PartitionStatistics;
import org.apache.paimon.rest.RESTApi;
import org.apache.paimon.rest.RESTCatalogLoader;
import org.apache.paimon.rest.RESTTokenFileIO;
import org.apache.paimon.rest.exceptions.AlreadyExistsException;
import org.apache.paimon.rest.exceptions.BadRequestException;
import org.apache.paimon.rest.exceptions.ForbiddenException;
import org.apache.paimon.rest.exceptions.NoSuchResourceException;
import org.apache.paimon.rest.exceptions.NotImplementedException;
import org.apache.paimon.rest.exceptions.ServiceFailureException;
import org.apache.paimon.rest.responses.GetDatabaseResponse;
import org.apache.paimon.rest.responses.GetFunctionResponse;
import org.apache.paimon.rest.responses.GetTableResponse;
import org.apache.paimon.rest.responses.GetTableTokenResponse;
import org.apache.paimon.rest.responses.GetViewResponse;
import org.apache.paimon.schema.Schema;
import org.apache.paimon.schema.SchemaChange;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.shade.org.apache.commons.lang3.StringUtils;
import org.apache.paimon.table.Instant;
import org.apache.paimon.table.Table;
import org.apache.paimon.table.TableSnapshot;
import org.apache.paimon.table.sink.BatchTableCommit;
import org.apache.paimon.table.system.SystemTableLoader;
import org.apache.paimon.utils.Pair;
import org.apache.paimon.view.View;
import org.apache.paimon.view.ViewChange;
import org.apache.paimon.view.ViewImpl;
import org.apache.paimon.view.ViewSchema;

public class RESTCatalog
implements Catalog {
    private final RESTApi api;
    private final CatalogContext context;
    private final boolean dataTokenEnabled;

    public RESTCatalog(CatalogContext context) {
        this(context, true);
    }

    public RESTCatalog(CatalogContext context, boolean configRequired) {
        this.api = new RESTApi(context.options(), configRequired);
        this.context = CatalogContext.create(this.api.options(), context.hadoopConf(), context.preferIO(), context.fallbackIO());
        this.dataTokenEnabled = this.api.options().get(RESTTokenFileIO.DATA_TOKEN_ENABLED);
    }

    @Override
    public Map<String, String> options() {
        return this.context.options().toMap();
    }

    @Override
    public RESTCatalogLoader catalogLoader() {
        return new RESTCatalogLoader(this.context);
    }

    @Override
    public List<String> listDatabases() {
        return this.api.listDatabases();
    }

    @Override
    public PagedList<String> listDatabasesPaged(@Nullable Integer maxResults, @Nullable String pageToken, @Nullable String databaseNamePattern) {
        return this.api.listDatabasesPaged(maxResults, pageToken, databaseNamePattern);
    }

    @Override
    public void createDatabase(String name, boolean ignoreIfExists, Map<String, String> properties) throws Catalog.DatabaseAlreadyExistException {
        CatalogUtils.checkNotSystemDatabase(name);
        try {
            this.api.createDatabase(name, properties);
        }
        catch (AlreadyExistsException e) {
            if (!ignoreIfExists) {
                throw new Catalog.DatabaseAlreadyExistException(name);
            }
        }
        catch (ForbiddenException e) {
            throw new Catalog.DatabaseNoPermissionException(name, e);
        }
        catch (BadRequestException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    @Override
    public Database getDatabase(String name) throws Catalog.DatabaseNotExistException {
        if (CatalogUtils.isSystemDatabase(name)) {
            return Database.of(name);
        }
        try {
            GetDatabaseResponse response = this.api.getDatabase(name);
            HashMap<String, String> options = new HashMap<String, String>(response.getOptions());
            options.put("location", response.getLocation());
            response.putAuditOptionsTo(options);
            return new Database.DatabaseImpl(name, options, (String)options.get("comment"));
        }
        catch (NoSuchResourceException e) {
            throw new Catalog.DatabaseNotExistException(name);
        }
        catch (ForbiddenException e) {
            throw new Catalog.DatabaseNoPermissionException(name, e);
        }
    }

    @Override
    public void dropDatabase(String name, boolean ignoreIfNotExists, boolean cascade) throws Catalog.DatabaseNotExistException, Catalog.DatabaseNotEmptyException {
        CatalogUtils.checkNotSystemDatabase(name);
        try {
            if (!cascade && !this.listTables(name).isEmpty()) {
                throw new Catalog.DatabaseNotEmptyException(name);
            }
            this.api.dropDatabase(name);
        }
        catch (Catalog.DatabaseNotExistException | NoSuchResourceException e) {
            if (!ignoreIfNotExists) {
                throw new Catalog.DatabaseNotExistException(name);
            }
        }
        catch (ForbiddenException e) {
            throw new Catalog.DatabaseNoPermissionException(name, e);
        }
    }

    @Override
    public void alterDatabase(String name, List<PropertyChange> changes, boolean ignoreIfNotExists) throws Catalog.DatabaseNotExistException {
        CatalogUtils.checkNotSystemDatabase(name);
        try {
            Pair<Map<String, String>, Set<String>> setPropertiesToRemoveKeys = PropertyChange.getSetPropertiesToRemoveKeys(changes);
            Map<String, String> updateProperties = setPropertiesToRemoveKeys.getLeft();
            Set<String> removeKeys = setPropertiesToRemoveKeys.getRight();
            this.api.alterDatabase(name, new ArrayList<String>(removeKeys), updateProperties);
        }
        catch (NoSuchResourceException e) {
            if (!ignoreIfNotExists) {
                throw new Catalog.DatabaseNotExistException(name);
            }
        }
        catch (ForbiddenException e) {
            throw new Catalog.DatabaseNoPermissionException(name, e);
        }
        catch (BadRequestException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    @Override
    public List<String> listTables(String databaseName) throws Catalog.DatabaseNotExistException {
        try {
            if (CatalogUtils.isSystemDatabase(databaseName)) {
                return SystemTableLoader.loadGlobalTableNames();
            }
            return this.api.listTables(databaseName);
        }
        catch (NoSuchResourceException e) {
            throw new Catalog.DatabaseNotExistException(databaseName);
        }
        catch (ForbiddenException e) {
            throw new Catalog.DatabaseNoPermissionException(databaseName, e);
        }
    }

    @Override
    public PagedList<String> listTablesPaged(String databaseName, @Nullable Integer maxResults, @Nullable String pageToken, @Nullable String tableNamePattern, @Nullable String tableType) throws Catalog.DatabaseNotExistException {
        try {
            return this.api.listTablesPaged(databaseName, maxResults, pageToken, tableNamePattern, tableType);
        }
        catch (NoSuchResourceException e) {
            throw new Catalog.DatabaseNotExistException(databaseName);
        }
    }

    @Override
    public PagedList<Table> listTableDetailsPaged(String db, @Nullable Integer maxResults, @Nullable String pageToken, @Nullable String tableNamePattern, @Nullable String tableType) throws Catalog.DatabaseNotExistException {
        try {
            PagedList<GetTableResponse> tables = this.api.listTableDetailsPaged(db, maxResults, pageToken, tableNamePattern, tableType);
            return new PagedList<Table>(tables.getElements().stream().map(t -> this.toTable(db, (GetTableResponse)t)).collect(Collectors.toList()), tables.getNextPageToken());
        }
        catch (NoSuchResourceException e) {
            throw new Catalog.DatabaseNotExistException(db);
        }
    }

    @Override
    public PagedList<Identifier> listTablesPagedGlobally(@Nullable String databaseNamePattern, @Nullable String tableNamePattern, @Nullable Integer maxResults, @Nullable String pageToken) {
        PagedList<Identifier> tables = this.api.listTablesPagedGlobally(databaseNamePattern, tableNamePattern, maxResults, pageToken);
        return new PagedList<Identifier>(tables.getElements(), tables.getNextPageToken());
    }

    @Override
    public Table getTable(Identifier identifier) throws Catalog.TableNotExistException {
        return CatalogUtils.loadTable(this, identifier, path -> this.fileIOForData((Path)path, identifier), this::fileIOFromOptions, this::loadTableMetadata, null, null);
    }

    @Override
    public Optional<TableSnapshot> loadSnapshot(Identifier identifier) throws Catalog.TableNotExistException {
        try {
            return Optional.ofNullable(this.api.loadSnapshot(identifier));
        }
        catch (NoSuchResourceException e) {
            if (StringUtils.equals(e.resourceType(), "SNAPSHOT")) {
                return Optional.empty();
            }
            throw new Catalog.TableNotExistException(identifier);
        }
        catch (ForbiddenException e) {
            throw new Catalog.TableNoPermissionException(identifier, (Throwable)e);
        }
    }

    @Override
    public Optional<Snapshot> loadSnapshot(Identifier identifier, String version) throws Catalog.TableNotExistException {
        try {
            return Optional.ofNullable(this.api.loadSnapshot(identifier, version));
        }
        catch (NoSuchResourceException e) {
            if (StringUtils.equals(e.resourceType(), "SNAPSHOT")) {
                return Optional.empty();
            }
            throw new Catalog.TableNotExistException(identifier);
        }
        catch (ForbiddenException e) {
            throw new Catalog.TableNoPermissionException(identifier, (Throwable)e);
        }
    }

    @Override
    public PagedList<Snapshot> listSnapshotsPaged(Identifier identifier, @Nullable Integer maxResults, @Nullable String pageToken) throws Catalog.TableNotExistException {
        try {
            return this.api.listSnapshotsPaged(identifier, maxResults, pageToken);
        }
        catch (NoSuchResourceException e) {
            throw new Catalog.TableNotExistException(identifier);
        }
        catch (ForbiddenException e) {
            throw new Catalog.TableNoPermissionException(identifier, (Throwable)e);
        }
    }

    @Override
    public boolean supportsListObjectsPaged() {
        return true;
    }

    @Override
    public boolean supportsListByPattern() {
        return true;
    }

    @Override
    public boolean supportsListTableByType() {
        return true;
    }

    @Override
    public boolean supportsVersionManagement() {
        return true;
    }

    @Override
    public boolean commitSnapshot(Identifier identifier, @Nullable String tableUuid, Snapshot snapshot, List<PartitionStatistics> statistics) throws Catalog.TableNotExistException {
        try {
            return this.api.commitSnapshot(identifier, tableUuid, snapshot, statistics);
        }
        catch (NoSuchResourceException e) {
            throw new Catalog.TableNotExistException(identifier, (Throwable)e);
        }
        catch (ForbiddenException e) {
            throw new Catalog.TableNoPermissionException(identifier, (Throwable)e);
        }
        catch (BadRequestException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    @Override
    public void rollbackTo(Identifier identifier, Instant instant) throws Catalog.TableNotExistException {
        try {
            this.api.rollbackTo(identifier, instant);
        }
        catch (NoSuchResourceException e) {
            if (StringUtils.equals(e.resourceType(), "SNAPSHOT")) {
                throw new IllegalArgumentException(String.format("Rollback snapshot '%s' doesn't exist.", e.resourceName()));
            }
            if (StringUtils.equals(e.resourceType(), "TAG")) {
                throw new IllegalArgumentException(String.format("Rollback tag '%s' doesn't exist.", e.resourceName()));
            }
            throw new Catalog.TableNotExistException(identifier);
        }
        catch (ForbiddenException e) {
            throw new Catalog.TableNoPermissionException(identifier, (Throwable)e);
        }
    }

    private TableMetadata loadTableMetadata(Identifier identifier) throws Catalog.TableNotExistException {
        GetTableResponse response;
        Identifier loadTableIdentifier = identifier.isSystemTable() ? new Identifier(identifier.getDatabaseName(), identifier.getTableName(), identifier.getBranchName()) : identifier;
        try {
            response = this.api.getTable(loadTableIdentifier);
        }
        catch (NoSuchResourceException e) {
            throw new Catalog.TableNotExistException(identifier);
        }
        catch (ForbiddenException e) {
            throw new Catalog.TableNoPermissionException(identifier, (Throwable)e);
        }
        return this.toTableMetadata(identifier.getDatabaseName(), response);
    }

    private TableMetadata toTableMetadata(String db, GetTableResponse response) {
        TableSchema schema = TableSchema.create(response.getSchemaId(), response.getSchema());
        HashMap<String, String> options = new HashMap<String, String>(schema.options());
        options.put(CoreOptions.PATH.key(), response.getPath());
        response.putAuditOptionsTo(options);
        Identifier identifier = Identifier.create(db, response.getName());
        if (identifier.getBranchName() != null) {
            options.put(CoreOptions.BRANCH.key(), identifier.getBranchName());
        }
        return new TableMetadata(schema.copy(options), response.isExternal(), response.getId());
    }

    private Table toTable(String db, GetTableResponse response) {
        Identifier identifier = Identifier.create(db, response.getName());
        try {
            return CatalogUtils.loadTable(this, identifier, path -> this.fileIOForData((Path)path, identifier), this::fileIOFromOptions, i -> this.toTableMetadata(db, response), null, null);
        }
        catch (Catalog.TableNotExistException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void createTable(Identifier identifier, Schema schema, boolean ignoreIfExists) throws Catalog.TableAlreadyExistException, Catalog.DatabaseNotExistException {
        try {
            CatalogUtils.checkNotBranch(identifier, "createTable");
            CatalogUtils.checkNotSystemTable(identifier, "createTable");
            CatalogUtils.validateCreateTable(schema);
            this.createExternalTablePathIfNotExist(schema);
            this.api.createTable(identifier, schema);
        }
        catch (AlreadyExistsException e) {
            if (!ignoreIfExists) {
                throw new Catalog.TableAlreadyExistException(identifier);
            }
        }
        catch (NotImplementedException e) {
            throw new RuntimeException(new UnsupportedOperationException(e.getMessage()));
        }
        catch (NoSuchResourceException e) {
            throw new Catalog.DatabaseNotExistException(identifier.getDatabaseName());
        }
        catch (BadRequestException e) {
            throw new RuntimeException(new IllegalArgumentException(e.getMessage()));
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void renameTable(Identifier fromTable, Identifier toTable, boolean ignoreIfNotExists) throws Catalog.TableNotExistException, Catalog.TableAlreadyExistException {
        CatalogUtils.checkNotBranch(fromTable, "renameTable");
        CatalogUtils.checkNotBranch(toTable, "renameTable");
        CatalogUtils.checkNotSystemTable(fromTable, "renameTable");
        CatalogUtils.checkNotSystemTable(toTable, "renameTable");
        try {
            this.api.renameTable(fromTable, toTable);
        }
        catch (NoSuchResourceException e) {
            if (!ignoreIfNotExists) {
                throw new Catalog.TableNotExistException(fromTable);
            }
        }
        catch (ForbiddenException e) {
            throw new Catalog.TableNoPermissionException(fromTable, (Throwable)e);
        }
        catch (AlreadyExistsException e) {
            throw new Catalog.TableAlreadyExistException(toTable);
        }
        catch (BadRequestException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    @Override
    public void alterTable(Identifier identifier, List<SchemaChange> changes, boolean ignoreIfNotExists) throws Catalog.TableNotExistException, Catalog.ColumnAlreadyExistException, Catalog.ColumnNotExistException {
        CatalogUtils.checkNotSystemTable(identifier, "alterTable");
        try {
            this.api.alterTable(identifier, changes);
        }
        catch (NoSuchResourceException e) {
            if (!ignoreIfNotExists) {
                if (StringUtils.equals(e.resourceType(), "TABLE")) {
                    throw new Catalog.TableNotExistException(identifier);
                }
                if (StringUtils.equals(e.resourceType(), "COLUMN")) {
                    throw new Catalog.ColumnNotExistException(identifier, e.resourceName());
                }
            }
        }
        catch (AlreadyExistsException e) {
            throw new Catalog.ColumnAlreadyExistException(identifier, e.resourceName());
        }
        catch (ForbiddenException e) {
            throw new Catalog.TableNoPermissionException(identifier, (Throwable)e);
        }
        catch (ServiceFailureException e) {
            throw new IllegalStateException(e.getMessage());
        }
        catch (NotImplementedException e) {
            throw new UnsupportedOperationException(e.getMessage());
        }
        catch (BadRequestException e) {
            throw new RuntimeException(new IllegalArgumentException(e.getMessage()));
        }
    }

    @Override
    public List<String> authTableQuery(Identifier identifier, @Nullable List<String> select) throws Catalog.TableNotExistException {
        CatalogUtils.checkNotSystemTable(identifier, "authTable");
        try {
            return this.api.authTableQuery(identifier, select);
        }
        catch (NoSuchResourceException e) {
            throw new Catalog.TableNotExistException(identifier);
        }
        catch (ForbiddenException e) {
            throw new Catalog.TableNoPermissionException(identifier, (Throwable)e);
        }
        catch (ServiceFailureException e) {
            throw new IllegalStateException(e.getMessage());
        }
        catch (NotImplementedException e) {
            throw new UnsupportedOperationException(e.getMessage());
        }
        catch (BadRequestException e) {
            throw new RuntimeException(new IllegalArgumentException(e.getMessage()));
        }
    }

    @Override
    public void dropTable(Identifier identifier, boolean ignoreIfNotExists) throws Catalog.TableNotExistException {
        CatalogUtils.checkNotBranch(identifier, "dropTable");
        CatalogUtils.checkNotSystemTable(identifier, "dropTable");
        try {
            this.api.dropTable(identifier);
        }
        catch (NoSuchResourceException e) {
            if (!ignoreIfNotExists) {
                throw new Catalog.TableNotExistException(identifier);
            }
        }
        catch (ForbiddenException e) {
            throw new Catalog.TableNoPermissionException(identifier, (Throwable)e);
        }
    }

    @Override
    public void registerTable(Identifier identifier, String path) throws Catalog.TableAlreadyExistException {
        try {
            this.api.registerTable(identifier, path);
        }
        catch (ForbiddenException e) {
            throw new Catalog.TableNoPermissionException(identifier, (Throwable)e);
        }
        catch (AlreadyExistsException e) {
            throw new Catalog.TableAlreadyExistException(identifier);
        }
        catch (ServiceFailureException e) {
            throw new IllegalStateException(e.getMessage());
        }
        catch (BadRequestException e) {
            throw new RuntimeException(new IllegalArgumentException(e.getMessage()));
        }
    }

    @Override
    public void markDonePartitions(Identifier identifier, List<Map<String, String>> partitions) throws Catalog.TableNotExistException {
        try {
            this.api.markDonePartitions(identifier, partitions);
        }
        catch (NoSuchResourceException e) {
            throw new Catalog.TableNotExistException(identifier);
        }
        catch (ForbiddenException e) {
            throw new Catalog.TableNoPermissionException(identifier, (Throwable)e);
        }
        catch (NotImplementedException notImplementedException) {
            // empty catch block
        }
    }

    @Override
    public List<Partition> listPartitions(Identifier identifier) throws Catalog.TableNotExistException {
        try {
            return this.api.listPartitions(identifier);
        }
        catch (NoSuchResourceException e) {
            throw new Catalog.TableNotExistException(identifier);
        }
        catch (ForbiddenException e) {
            throw new Catalog.TableNoPermissionException(identifier, (Throwable)e);
        }
        catch (NotImplementedException e) {
            return CatalogUtils.listPartitionsFromFileSystem(this.getTable(identifier));
        }
    }

    @Override
    public PagedList<Partition> listPartitionsPaged(Identifier identifier, @Nullable Integer maxResults, @Nullable String pageToken, @Nullable String partitionNamePattern) throws Catalog.TableNotExistException {
        try {
            return this.api.listPartitionsPaged(identifier, maxResults, pageToken, partitionNamePattern);
        }
        catch (NoSuchResourceException e) {
            throw new Catalog.TableNotExistException(identifier);
        }
        catch (ForbiddenException e) {
            throw new Catalog.TableNoPermissionException(identifier, (Throwable)e);
        }
        catch (NotImplementedException e) {
            return new PagedList<Partition>(CatalogUtils.listPartitionsFromFileSystem(this.getTable(identifier)), null);
        }
    }

    @Override
    public void createBranch(Identifier identifier, String branch, @Nullable String fromTag) throws Catalog.TableNotExistException, Catalog.BranchAlreadyExistException, Catalog.TagNotExistException {
        try {
            this.api.createBranch(identifier, branch, fromTag);
        }
        catch (NoSuchResourceException e) {
            if (StringUtils.equals(e.resourceType(), "TABLE")) {
                throw new Catalog.TableNotExistException(identifier, (Throwable)e);
            }
            if (StringUtils.equals(e.resourceType(), "TAG")) {
                throw new Catalog.TagNotExistException(identifier, fromTag, e);
            }
            throw e;
        }
        catch (AlreadyExistsException e) {
            throw new Catalog.BranchAlreadyExistException(identifier, branch, e);
        }
        catch (ForbiddenException e) {
            throw new Catalog.TableNoPermissionException(identifier, (Throwable)e);
        }
        catch (BadRequestException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    @Override
    public void dropBranch(Identifier identifier, String branch) throws Catalog.BranchNotExistException {
        try {
            this.api.dropBranch(identifier, branch);
        }
        catch (NoSuchResourceException e) {
            throw new Catalog.BranchNotExistException(identifier, branch, e);
        }
        catch (ForbiddenException e) {
            throw new Catalog.TableNoPermissionException(identifier, (Throwable)e);
        }
    }

    @Override
    public void fastForward(Identifier identifier, String branch) throws Catalog.BranchNotExistException {
        try {
            this.api.fastForward(identifier, branch);
        }
        catch (NoSuchResourceException e) {
            throw new Catalog.BranchNotExistException(identifier, branch, e);
        }
        catch (ForbiddenException e) {
            throw new Catalog.TableNoPermissionException(identifier, (Throwable)e);
        }
    }

    @Override
    public List<String> listBranches(Identifier identifier) throws Catalog.TableNotExistException {
        try {
            return this.api.listBranches(identifier);
        }
        catch (NoSuchResourceException e) {
            throw new Catalog.TableNotExistException(identifier);
        }
        catch (ForbiddenException e) {
            throw new Catalog.TableNoPermissionException(identifier, (Throwable)e);
        }
    }

    @Override
    public void createPartitions(Identifier identifier, List<Map<String, String>> partitions) throws Catalog.TableNotExistException {
    }

    @Override
    public void dropPartitions(Identifier identifier, List<Map<String, String>> partitions) throws Catalog.TableNotExistException {
        Table table = this.getTable(identifier);
        try (BatchTableCommit commit = table.newBatchWriteBuilder().newCommit();){
            commit.truncatePartitions(partitions);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void alterPartitions(Identifier identifier, List<PartitionStatistics> partitions) throws Catalog.TableNotExistException {
    }

    @Override
    public List<String> listFunctions(String databaseName) throws Catalog.DatabaseNotExistException {
        try {
            return this.api.listFunctions(databaseName);
        }
        catch (NoSuchResourceException e) {
            throw new Catalog.DatabaseNotExistException(databaseName, e);
        }
    }

    @Override
    public Function getFunction(Identifier identifier) throws Catalog.FunctionNotExistException {
        try {
            GetFunctionResponse response = this.api.getFunction(identifier);
            return response.toFunction(identifier);
        }
        catch (NoSuchResourceException e) {
            throw new Catalog.FunctionNotExistException(identifier, (Throwable)e);
        }
    }

    @Override
    public void createFunction(Identifier identifier, Function function, boolean ignoreIfExists) throws Catalog.FunctionAlreadyExistException, Catalog.DatabaseNotExistException {
        try {
            this.api.createFunction(identifier, function);
        }
        catch (NoSuchResourceException e) {
            throw new Catalog.DatabaseNotExistException(identifier.getDatabaseName(), e);
        }
        catch (AlreadyExistsException e) {
            if (ignoreIfExists) {
                return;
            }
            throw new Catalog.FunctionAlreadyExistException(identifier, (Throwable)e);
        }
    }

    @Override
    public void dropFunction(Identifier identifier, boolean ignoreIfNotExists) throws Catalog.FunctionNotExistException {
        try {
            this.api.dropFunction(identifier);
        }
        catch (NoSuchResourceException e) {
            if (ignoreIfNotExists) {
                return;
            }
            throw new Catalog.FunctionNotExistException(identifier, (Throwable)e);
        }
    }

    @Override
    public void alterFunction(Identifier identifier, List<FunctionChange> changes, boolean ignoreIfNotExists) throws Catalog.FunctionNotExistException, Catalog.DefinitionAlreadyExistException, Catalog.DefinitionNotExistException {
        try {
            this.api.alterFunction(identifier, changes);
        }
        catch (AlreadyExistsException e) {
            throw new Catalog.DefinitionAlreadyExistException(identifier, e.resourceName());
        }
        catch (NoSuchResourceException e) {
            if (StringUtils.equals(e.resourceType(), "DEFINITION")) {
                throw new Catalog.DefinitionNotExistException(identifier, e.resourceName());
            }
            if (!ignoreIfNotExists) {
                throw new Catalog.FunctionNotExistException(identifier, (Throwable)e);
            }
        }
        catch (BadRequestException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    @Override
    public PagedList<String> listFunctionsPaged(String databaseName, @Nullable Integer maxResults, @Nullable String pageToken, @Nullable String functionNamePattern) throws Catalog.DatabaseNotExistException {
        try {
            return this.api.listFunctionsPaged(databaseName, maxResults, pageToken, functionNamePattern);
        }
        catch (NoSuchResourceException e) {
            throw new Catalog.DatabaseNotExistException(databaseName);
        }
    }

    @Override
    public PagedList<Identifier> listFunctionsPagedGlobally(@Nullable String databaseNamePattern, @Nullable String functionNamePattern, @Nullable Integer maxResults, @Nullable String pageToken) {
        PagedList<Identifier> functions = this.api.listFunctionsPagedGlobally(databaseNamePattern, functionNamePattern, maxResults, pageToken);
        return new PagedList<Identifier>(functions.getElements(), functions.getNextPageToken());
    }

    @Override
    public PagedList<Function> listFunctionDetailsPaged(String databaseName, @Nullable Integer maxResults, @Nullable String pageToken, @Nullable String functionNamePattern) throws Catalog.DatabaseNotExistException {
        try {
            PagedList<GetFunctionResponse> functions = this.api.listFunctionDetailsPaged(databaseName, maxResults, pageToken, functionNamePattern);
            return new PagedList<Function>(functions.getElements().stream().map(v -> v.toFunction(Identifier.create(databaseName, v.name()))).collect(Collectors.toList()), functions.getNextPageToken());
        }
        catch (NoSuchResourceException e) {
            throw new Catalog.DatabaseNotExistException(databaseName);
        }
    }

    @Override
    public View getView(Identifier identifier) throws Catalog.ViewNotExistException {
        try {
            GetViewResponse response = this.api.getView(identifier);
            return this.toView(identifier.getDatabaseName(), response);
        }
        catch (NoSuchResourceException e) {
            throw new Catalog.ViewNotExistException(identifier);
        }
    }

    @Override
    public void dropView(Identifier identifier, boolean ignoreIfNotExists) throws Catalog.ViewNotExistException {
        block2: {
            try {
                this.api.dropView(identifier);
            }
            catch (NoSuchResourceException e) {
                if (ignoreIfNotExists) break block2;
                throw new Catalog.ViewNotExistException(identifier);
            }
        }
    }

    @Override
    public void createView(Identifier identifier, View view, boolean ignoreIfExists) throws Catalog.ViewAlreadyExistException, Catalog.DatabaseNotExistException {
        try {
            ViewSchema schema = new ViewSchema(view.rowType().getFields(), view.query(), view.dialects(), view.comment().orElse(null), view.options());
            this.api.createView(identifier, schema);
        }
        catch (NoSuchResourceException e) {
            throw new Catalog.DatabaseNotExistException(identifier.getDatabaseName());
        }
        catch (AlreadyExistsException e) {
            if (!ignoreIfExists) {
                throw new Catalog.ViewAlreadyExistException(identifier);
            }
        }
        catch (BadRequestException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    @Override
    public List<String> listViews(String databaseName) throws Catalog.DatabaseNotExistException {
        try {
            return CatalogUtils.isSystemDatabase(databaseName) ? Collections.emptyList() : this.api.listViews(databaseName);
        }
        catch (NoSuchResourceException e) {
            throw new Catalog.DatabaseNotExistException(databaseName);
        }
    }

    @Override
    public PagedList<String> listViewsPaged(String databaseName, @Nullable Integer maxResults, @Nullable String pageToken, @Nullable String viewNamePattern) throws Catalog.DatabaseNotExistException {
        try {
            return this.api.listViewsPaged(databaseName, maxResults, pageToken, viewNamePattern);
        }
        catch (NoSuchResourceException e) {
            throw new Catalog.DatabaseNotExistException(databaseName);
        }
    }

    @Override
    public PagedList<View> listViewDetailsPaged(String db, @Nullable Integer maxResults, @Nullable String pageToken, @Nullable String viewNamePattern) throws Catalog.DatabaseNotExistException {
        try {
            PagedList<GetViewResponse> views = this.api.listViewDetailsPaged(db, maxResults, pageToken, viewNamePattern);
            return new PagedList<View>(views.getElements().stream().map(v -> this.toView(db, (GetViewResponse)v)).collect(Collectors.toList()), views.getNextPageToken());
        }
        catch (NoSuchResourceException e) {
            throw new Catalog.DatabaseNotExistException(db);
        }
    }

    @Override
    public PagedList<Identifier> listViewsPagedGlobally(@Nullable String databaseNamePattern, @Nullable String viewNamePattern, @Nullable Integer maxResults, @Nullable String pageToken) {
        PagedList<Identifier> views = this.api.listViewsPagedGlobally(databaseNamePattern, viewNamePattern, maxResults, pageToken);
        return new PagedList<Identifier>(views.getElements(), views.getNextPageToken());
    }

    private ViewImpl toView(String db, GetViewResponse response) {
        ViewSchema schema = response.getSchema();
        HashMap<String, String> options = new HashMap<String, String>(schema.options());
        response.putAuditOptionsTo(options);
        return new ViewImpl(Identifier.create(db, response.getName()), schema.fields(), schema.query(), schema.dialects(), schema.comment(), options);
    }

    @Override
    public void renameView(Identifier fromView, Identifier toView, boolean ignoreIfNotExists) throws Catalog.ViewNotExistException, Catalog.ViewAlreadyExistException {
        try {
            this.api.renameView(fromView, toView);
        }
        catch (NoSuchResourceException e) {
            if (!ignoreIfNotExists) {
                throw new Catalog.ViewNotExistException(fromView);
            }
        }
        catch (AlreadyExistsException e) {
            throw new Catalog.ViewAlreadyExistException(toView);
        }
        catch (BadRequestException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    @Override
    public void alterView(Identifier identifier, List<ViewChange> viewChanges, boolean ignoreIfNotExists) throws Catalog.ViewNotExistException, Catalog.DialectAlreadyExistException, Catalog.DialectNotExistException {
        try {
            this.api.alterView(identifier, viewChanges);
        }
        catch (AlreadyExistsException e) {
            throw new Catalog.DialectAlreadyExistException(identifier, e.resourceName());
        }
        catch (NoSuchResourceException e) {
            if (StringUtils.equals(e.resourceType(), "DIALECT")) {
                throw new Catalog.DialectNotExistException(identifier, e.resourceName());
            }
            if (!ignoreIfNotExists) {
                throw new Catalog.ViewNotExistException(identifier);
            }
        }
        catch (BadRequestException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    @Override
    public boolean caseSensitive() {
        return this.context.options().getOptional(CatalogOptions.CASE_SENSITIVE).orElse(true);
    }

    @Override
    public void close() throws Exception {
    }

    @VisibleForTesting
    RESTApi api() {
        return this.api;
    }

    protected GetTableTokenResponse loadTableToken(Identifier identifier) throws Catalog.TableNotExistException {
        try {
            return this.api.loadTableToken(identifier);
        }
        catch (NoSuchResourceException e) {
            throw new Catalog.TableNotExistException(identifier);
        }
        catch (ForbiddenException e) {
            throw new Catalog.TableNoPermissionException(identifier, (Throwable)e);
        }
    }

    private FileIO fileIOForData(Path path, Identifier identifier) {
        return this.dataTokenEnabled ? new RESTTokenFileIO(this.context, this.api, identifier, path) : this.fileIOFromOptions(path);
    }

    private FileIO fileIOFromOptions(Path path) {
        try {
            return FileIO.get(path, this.context);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void createExternalTablePathIfNotExist(Schema schema) throws IOException {
        Map<String, String> options = schema.options();
        if (options.containsKey(CoreOptions.PATH.key())) {
            Path path = new Path(options.get(CoreOptions.PATH.key()));
            try (FileIO fileIO = this.fileIOFromOptions(path);){
                if (!fileIO.exists(path)) {
                    fileIO.mkdirs(path);
                }
            }
        }
    }
}

