/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.memory;

import java.util.List;
import javax.annotation.Nullable;
import org.apache.paimon.memory.MemorySegment;
import org.apache.paimon.memory.MemorySegmentPool;

public class UnlimitedSegmentPool
implements MemorySegmentPool {
    private final int pageSize;

    public UnlimitedSegmentPool(int pageSize) {
        this.pageSize = pageSize;
    }

    @Override
    public int pageSize() {
        return this.pageSize;
    }

    @Override
    public void returnAll(List<MemorySegment> memory) {
    }

    @Override
    public int freePages() {
        return Integer.MAX_VALUE;
    }

    @Override
    @Nullable
    public MemorySegment nextSegment() {
        return MemorySegment.allocateHeapMemory(this.pageSize);
    }
}

