/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.csv;

import java.io.IOException;
import java.util.Base64;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.paimon.casting.CastExecutor;
import org.apache.paimon.casting.CastExecutors;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.format.csv.CsvOptions;
import org.apache.paimon.format.text.BaseTextFileWriter;
import org.apache.paimon.fs.PositionOutputStream;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeRoot;
import org.apache.paimon.types.RowType;

public class CsvFormatWriter
extends BaseTextFileWriter {
    private static final Base64.Encoder BASE64_ENCODER = Base64.getEncoder();
    private static final Map<String, CastExecutor<?, ?>> CAST_EXECUTOR_CACHE = new ConcurrentHashMap(32);
    private final CsvOptions csvOptions;
    private boolean headerWritten = false;
    private final StringBuilder stringBuilder;

    public CsvFormatWriter(PositionOutputStream out, RowType rowType, CsvOptions options, String compression) throws IOException {
        super(out, rowType, compression);
        this.csvOptions = options;
        this.stringBuilder = new StringBuilder();
    }

    @Override
    public void addElement(InternalRow element) throws IOException {
        if (this.csvOptions.includeHeader() && !this.headerWritten) {
            this.writeHeader();
            this.headerWritten = true;
        }
        this.stringBuilder.setLength(0);
        int fieldCount = this.rowType.getFieldCount();
        for (int i = 0; i < fieldCount; ++i) {
            if (i > 0) {
                this.stringBuilder.append(this.csvOptions.fieldDelimiter());
            }
            Object value = InternalRow.createFieldGetter(this.rowType.getTypeAt(i), i).getFieldOrNull(element);
            String fieldValue = this.escapeField(this.castToStringOptimized(value, this.rowType.getTypeAt(i)));
            this.stringBuilder.append(fieldValue);
        }
        this.stringBuilder.append(this.csvOptions.lineDelimiter());
        this.writer.write(this.stringBuilder.toString());
    }

    private void writeHeader() throws IOException {
        this.stringBuilder.setLength(0);
        int fieldCount = this.rowType.getFieldCount();
        for (int i = 0; i < fieldCount; ++i) {
            if (i > 0) {
                this.stringBuilder.append(this.csvOptions.fieldDelimiter());
            }
            this.stringBuilder.append(this.escapeField(this.rowType.getFieldNames().get(i)));
        }
        this.stringBuilder.append(this.csvOptions.lineDelimiter());
        this.writer.write(this.stringBuilder.toString());
    }

    private String escapeField(String field) {
        boolean needsQuoting;
        if (field == null) {
            return this.csvOptions.nullLiteral();
        }
        boolean bl = needsQuoting = field.indexOf(this.csvOptions.fieldDelimiter().charAt(0)) >= 0 || field.indexOf(this.csvOptions.lineDelimiter().charAt(0)) >= 0 || field.indexOf(this.csvOptions.quoteCharacter().charAt(0)) >= 0;
        if (!needsQuoting) {
            return field;
        }
        String escaped = field.replace(this.csvOptions.quoteCharacter(), this.csvOptions.escapeCharacter() + this.csvOptions.quoteCharacter());
        return this.csvOptions.quoteCharacter() + escaped + this.csvOptions.quoteCharacter();
    }

    private String castToStringOptimized(Object value, DataType dataType) {
        if (value == null) {
            return null;
        }
        DataTypeRoot typeRoot = dataType.getTypeRoot();
        switch (typeRoot) {
            case INTEGER: 
            case BIGINT: 
            case FLOAT: 
            case DOUBLE: 
            case BOOLEAN: 
            case TINYINT: 
            case SMALLINT: 
            case CHAR: 
            case VARCHAR: {
                return value.toString();
            }
            case BINARY: 
            case VARBINARY: {
                return BASE64_ENCODER.encodeToString((byte[])value);
            }
        }
        return this.useCachedStringCastExecutor(value, dataType);
    }

    private String useCachedStringCastExecutor(Object value, DataType dataType) {
        String cacheKey = dataType.toString();
        CastExecutor cast = CAST_EXECUTOR_CACHE.computeIfAbsent(cacheKey, k -> CastExecutors.resolveToString(dataType));
        Object result = cast.cast(value);
        return result != null ? result.toString() : null;
    }
}

