/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.shade.hc.core5.http.nio.support.classic;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.paimon.shade.hc.core5.annotation.Contract;
import org.apache.paimon.shade.hc.core5.annotation.ThreadingBehavior;
import org.apache.paimon.shade.hc.core5.http.nio.DataStreamChannel;
import org.apache.paimon.shade.hc.core5.http.nio.support.classic.AbstractSharedBuffer;
import org.apache.paimon.shade.hc.core5.http.nio.support.classic.ContentOutputBuffer;

@Contract(threading=ThreadingBehavior.SAFE)
public final class SharedOutputBuffer
extends AbstractSharedBuffer
implements ContentOutputBuffer {
    private final AtomicBoolean endStreamPropagated = new AtomicBoolean();
    private volatile DataStreamChannel dataStreamChannel;
    private volatile boolean hasCapacity = false;

    public SharedOutputBuffer(ReentrantLock lock, int initialBufferSize) {
        super(lock, initialBufferSize);
    }

    public SharedOutputBuffer(int bufferSize) {
        this(new ReentrantLock(), bufferSize);
    }

    @Override
    public boolean isEndStream() {
        return this.endStreamPropagated.get();
    }

    public void flush(DataStreamChannel channel) throws IOException {
        this.lock.lock();
        try {
            this.dataStreamChannel = channel;
            this.hasCapacity = true;
            this.setOutputMode();
            if (this.buffer().hasRemaining()) {
                this.dataStreamChannel.write(this.buffer());
            }
            if (!this.buffer().hasRemaining() && this.endStream && this.endStreamPropagated.compareAndSet(false, true)) {
                this.dataStreamChannel.endStream();
            }
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void ensureNotAborted() throws InterruptedIOException {
        if (this.aborted) {
            throw new InterruptedIOException("Operation aborted");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        ByteBuffer src = ByteBuffer.wrap(b, off, len);
        this.lock.lock();
        try {
            this.ensureNotAborted();
            this.setInputMode();
            while (src.hasRemaining()) {
                int bytesWritten;
                if (src.remaining() < 1024 && this.buffer().remaining() > src.remaining()) {
                    this.buffer().put(src);
                    continue;
                }
                if (this.buffer().position() > 0 || this.dataStreamChannel == null) {
                    this.waitFlush();
                }
                if (this.buffer().position() != 0 || this.dataStreamChannel == null || (bytesWritten = this.dataStreamChannel.write(src)) != 0) continue;
                this.hasCapacity = false;
                this.waitFlush();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.lock.lock();
        try {
            this.ensureNotAborted();
            this.setInputMode();
            if (!this.buffer().hasRemaining()) {
                this.waitFlush();
            }
            this.buffer().put((byte)b);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void writeCompleted() throws IOException {
        if (this.endStream) {
            return;
        }
        this.lock.lock();
        try {
            if (!this.endStream) {
                this.endStream = true;
                this.waitEndStream();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void waitFlush() throws InterruptedIOException {
        if (this.dataStreamChannel != null) {
            this.dataStreamChannel.requestOutput();
        }
        this.setOutputMode();
        while (this.buffer().hasRemaining() || !this.hasCapacity) {
            this.ensureNotAborted();
            this.waitForSignal();
        }
        this.setInputMode();
    }

    private void waitEndStream() throws InterruptedIOException {
        if (this.dataStreamChannel != null) {
            this.dataStreamChannel.requestOutput();
        }
        while (!this.endStreamPropagated.get() && !this.aborted) {
            this.waitForSignal();
        }
    }

    private void waitForSignal() throws InterruptedIOException {
        try {
            this.condition.await();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new InterruptedIOException(ex.getMessage());
        }
    }
}

