/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.rest;

import org.apache.paimon.rest.ExponentialHttpRequestRetryStrategy;
import org.apache.paimon.rest.interceptor.LoggingInterceptor;
import org.apache.paimon.rest.interceptor.TimingInterceptor;
import org.apache.paimon.shade.hc.client5.http.config.RequestConfig;
import org.apache.paimon.shade.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.paimon.shade.hc.client5.http.impl.classic.HttpClients;
import org.apache.paimon.shade.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.paimon.shade.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.paimon.shade.hc.client5.http.ssl.DefaultClientTlsStrategy;
import org.apache.paimon.shade.hc.client5.http.ssl.HttpsSupport;
import org.apache.paimon.shade.hc.core5.reactor.ssl.SSLBufferMode;
import org.apache.paimon.shade.hc.core5.ssl.SSLContexts;
import org.apache.paimon.shade.hc.core5.util.Timeout;

public class HttpClientUtils {
    public static HttpClientBuilder createLoggingBuilder() {
        HttpClientBuilder clientBuilder = HttpClientUtils.createBuilder();
        clientBuilder.addRequestInterceptorFirst(new TimingInterceptor()).addResponseInterceptorLast(new LoggingInterceptor());
        return clientBuilder;
    }

    public static HttpClientBuilder createBuilder() {
        HttpClientBuilder clientBuilder = HttpClients.custom();
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(Timeout.ofMinutes(3L)).setResponseTimeout(Timeout.ofMinutes(3L)).build();
        clientBuilder.setDefaultRequestConfig(requestConfig);
        clientBuilder.setConnectionManager(HttpClientUtils.configureConnectionManager());
        clientBuilder.setRetryStrategy(new ExponentialHttpRequestRetryStrategy(5));
        return clientBuilder;
    }

    private static HttpClientConnectionManager configureConnectionManager() {
        PoolingHttpClientConnectionManagerBuilder connectionManagerBuilder = PoolingHttpClientConnectionManagerBuilder.create();
        connectionManagerBuilder.useSystemProperties().setMaxConnTotal(100).setMaxConnPerRoute(100);
        String[] tlsProtocols = new String[]{"TLSv1.2", "TLSv1.3"};
        connectionManagerBuilder.setTlsSocketStrategy(new DefaultClientTlsStrategy(SSLContexts.createDefault(), tlsProtocols, null, SSLBufferMode.STATIC, HttpsSupport.getDefaultHostnameVerifier()));
        return connectionManagerBuilder.build();
    }
}

