/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.ozone;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathIOException;
import org.apache.hadoop.fs.PathIsDirectoryException;
import org.apache.hadoop.fs.PathNotFoundException;
import org.apache.hadoop.fs.Trash;
import org.apache.hadoop.fs.shell.CommandFactory;
import org.apache.hadoop.fs.shell.CommandFormat;
import org.apache.hadoop.fs.shell.FsCommand;
import org.apache.hadoop.fs.shell.PathData;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.annotation.InterfaceStability;
import org.apache.hadoop.util.ToolRunner;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public final class OzoneFsDelete {
    private OzoneFsDelete() {
    }

    public static void registerCommands(CommandFactory factory) {
        factory.addClass(Rm.class, new String[]{"-rm"});
        factory.addClass(Rmr.class, new String[]{"-rmr"});
    }

    public static class Rm
    extends FsCommand {
        public static final String NAME = "rm";
        public static final String USAGE = "[-f] [-r|-R] [-skipTrash] [-safely] <src> ...";
        public static final String DESCRIPTION = "Delete all files that match the specified file pattern. Equivalent to the Unix command \"rm <src>\"\n-f: If the file does not exist, do not display a diagnostic message or modify the exit status to reflect an error.\n-[rR]:  Recursively deletes directories.\n-skipTrash: option bypasses trash, if enabled, and immediately deletes <src>.\n-safely: option requires safety confirmation, if enabled, requires confirmation before deleting large directory with more than <hadoop.shell.delete.limit.num.files> files. Delay is expected when walking over large directory recursively to count the number of files to be deleted before the confirmation.\n";
        private boolean skipTrash = false;
        private boolean deleteDirs = false;
        private boolean ignoreFNF = false;
        private boolean safeDelete = false;
        private boolean trailing = false;

        protected void processOptions(LinkedList<String> args) throws IOException {
            CommandFormat cf = new CommandFormat(1, Integer.MAX_VALUE, new String[]{"f", "r", "R", "skipTrash", "safely"});
            cf.parse(args);
            this.ignoreFNF = cf.getOpt("f");
            this.deleteDirs = cf.getOpt("r") || cf.getOpt("R");
            this.skipTrash = cf.getOpt("skipTrash");
            this.safeDelete = cf.getOpt("safely");
        }

        protected List<PathData> expandArgument(String arg) throws IOException {
            try {
                if (arg.endsWith("/")) {
                    this.trailing = true;
                }
                return super.expandArgument(arg);
            }
            catch (PathNotFoundException e) {
                if (!this.ignoreFNF) {
                    throw e;
                }
                return new LinkedList<PathData>();
            }
        }

        protected void processNonexistentPath(PathData item) throws IOException {
            if (!this.ignoreFNF) {
                super.processNonexistentPath(item);
            }
        }

        protected void processPath(PathData item) throws IOException {
            boolean isSymlink = false;
            if (item.fs.supportsSymlinks()) {
                boolean bl = isSymlink = item.fs.getLinkTarget(item.path) != item.path;
            }
            if (item.stat.isDirectory() && !this.deleteDirs && !isSymlink) {
                throw new PathIsDirectoryException(item.toString());
            }
            Path path = item.path;
            if (isSymlink && this.trailing) {
                path = new Path(URI.create(path.toString() + "/"));
            }
            if (this.moveToTrash(item) || !this.canBeSafelyDeleted(item)) {
                return;
            }
            if (!item.fs.delete(path, this.deleteDirs)) {
                throw new PathIOException(item.toString());
            }
            this.out.println("Deleted " + item + (this.trailing ? "/" : ""));
        }

        private boolean canBeSafelyDeleted(PathData item) throws IOException {
            ContentSummary cs;
            long numFiles;
            long deleteLimit;
            boolean shouldDelete = true;
            if (this.safeDelete && (deleteLimit = this.getConf().getLong("hadoop.shell.safely.delete.limit.num.files", 100L)) > 0L && (numFiles = (cs = item.fs.getContentSummary(item.path)).getFileCount()) > deleteLimit && !ToolRunner.confirmPrompt((String)("Proceed deleting " + numFiles + " files?"))) {
                System.err.println("Delete aborted at user request.\n");
                shouldDelete = false;
            }
            return shouldDelete;
        }

        private boolean moveToTrash(PathData item) throws IOException {
            boolean success = false;
            if (!this.skipTrash) {
                try {
                    success = Trash.moveToAppropriateTrash((FileSystem)item.fs, (Path)item.path, (Configuration)this.getConf());
                }
                catch (FileNotFoundException fnfe) {
                    throw fnfe;
                }
                catch (IOException ioe) {
                    String msg = ioe.getMessage();
                    if (ioe.getCause() != null) {
                        msg = msg + ": " + ioe.getCause().getMessage();
                    }
                    throw new IOException(msg + ". Consider using -skipTrash option", ioe);
                }
            }
            return success;
        }
    }

    static class Rmr
    extends Rm {
        public static final String NAME = "rmr";

        Rmr() {
        }

        @Override
        protected void processOptions(LinkedList<String> args) throws IOException {
            args.addFirst("-r");
            super.processOptions(args);
        }

        public String getReplacementCommand() {
            return "-rm -r";
        }
    }
}

