/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.admin.om;

import java.util.concurrent.Callable;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.ozone.admin.om.OMAdmin;
import org.apache.hadoop.ozone.om.protocolPB.OzoneManagerProtocolClientSideTranslatorPB;
import picocli.CommandLine;

@CommandLine.Command(name="updateranger", description={"Trigger Ranger sync background service task on a leader OM that pushes policies and roles updates to Ranger. This operation requires Ozone administrator privilege."}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class UpdateRangerSubcommand
implements Callable<Void> {
    @CommandLine.ParentCommand
    private OMAdmin parent;
    @CommandLine.Option(names={"-id", "--service-id"}, description={"Ozone Manager Service ID"})
    private String omServiceId;
    @CommandLine.Option(names={"-host", "--service-host"}, description={"Ozone Manager Host. If OM HA is enabled, use -id instead. If insists on using -host with OM HA, this must point directly to the leader OM. This option is required when -id is not provided or when HA is not enabled."})
    private String omHost;
    @CommandLine.Option(names={"--no-wait"}, description={"Do not wait for task completion. Exit immediately after the Ranger BG sync task is triggered on the OM."})
    private boolean noWait;

    @Override
    public Void call() throws Exception {
        if (StringUtils.isEmpty((CharSequence)this.omServiceId) && StringUtils.isEmpty((CharSequence)this.omHost)) {
            System.err.println("Error: Please specify -id or -host");
            return null;
        }
        boolean forceHA = false;
        try (OzoneManagerProtocolClientSideTranslatorPB client = this.parent.createOmClient(this.omServiceId, this.omHost, forceHA);){
            boolean res = client.triggerRangerBGSync(this.noWait);
            if (res) {
                System.out.println("Operation completed successfully");
            } else {
                System.err.println("Operation completed with errors. Check OM log for details");
            }
        }
        return null;
    }
}

