/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.protocolPB;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.protobuf.ByteString;
import com.google.protobuf.Proto2Utils;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.SafeModeAction;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.client.ECReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.common.helpers.ExcludeList;
import org.apache.hadoop.hdds.tracing.TracingUtil;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.CallerContext;
import org.apache.hadoop.ozone.ClientVersion;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.BasicOmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.DBUpdates;
import org.apache.hadoop.ozone.om.helpers.DeleteTenantState;
import org.apache.hadoop.ozone.om.helpers.ErrorInfo;
import org.apache.hadoop.ozone.om.helpers.KeyInfoWithVolumeContext;
import org.apache.hadoop.ozone.om.helpers.KeyValueUtil;
import org.apache.hadoop.ozone.om.helpers.LeaseKeyInfo;
import org.apache.hadoop.ozone.om.helpers.ListKeysLightResult;
import org.apache.hadoop.ozone.om.helpers.ListKeysResult;
import org.apache.hadoop.ozone.om.helpers.ListOpenFilesResult;
import org.apache.hadoop.ozone.om.helpers.OmBucketArgs;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmDeleteKeys;
import org.apache.hadoop.ozone.om.helpers.OmKeyArgs;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartCommitUploadPartInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartUpload;
import org.apache.hadoop.ozone.om.helpers.OmMultipartUploadCompleteInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartUploadCompleteList;
import org.apache.hadoop.ozone.om.helpers.OmMultipartUploadList;
import org.apache.hadoop.ozone.om.helpers.OmMultipartUploadListParts;
import org.apache.hadoop.ozone.om.helpers.OmRenameKeys;
import org.apache.hadoop.ozone.om.helpers.OmTenantArgs;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.om.helpers.OpenKeySession;
import org.apache.hadoop.ozone.om.helpers.OzoneFileStatus;
import org.apache.hadoop.ozone.om.helpers.OzoneFileStatusLight;
import org.apache.hadoop.ozone.om.helpers.S3SecretValue;
import org.apache.hadoop.ozone.om.helpers.S3VolumeContext;
import org.apache.hadoop.ozone.om.helpers.ServiceInfo;
import org.apache.hadoop.ozone.om.helpers.ServiceInfoEx;
import org.apache.hadoop.ozone.om.helpers.SnapshotDiffJob;
import org.apache.hadoop.ozone.om.helpers.SnapshotInfo;
import org.apache.hadoop.ozone.om.helpers.TenantStateList;
import org.apache.hadoop.ozone.om.helpers.TenantUserInfoValue;
import org.apache.hadoop.ozone.om.helpers.TenantUserList;
import org.apache.hadoop.ozone.om.protocol.S3Auth;
import org.apache.hadoop.ozone.om.protocolPB.OmTransport;
import org.apache.hadoop.ozone.om.protocolPB.OzoneManagerClientProtocol;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.protocolPB.OMPBHelper;
import org.apache.hadoop.ozone.security.OzoneTokenIdentifier;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.ozone.security.proto.SecurityProtos;
import org.apache.hadoop.ozone.snapshot.CancelSnapshotDiffResponse;
import org.apache.hadoop.ozone.snapshot.ListSnapshotResponse;
import org.apache.hadoop.ozone.snapshot.SnapshotDiffReportOzone;
import org.apache.hadoop.ozone.snapshot.SnapshotDiffResponse;
import org.apache.hadoop.ozone.upgrade.UpgradeFinalization;
import org.apache.hadoop.ozone.util.ProtobufUtils;
import org.apache.hadoop.security.token.Token;

@InterfaceAudience.Private
public final class OzoneManagerProtocolClientSideTranslatorPB
implements OzoneManagerClientProtocol {
    private final String clientID;
    private OmTransport transport;
    private ThreadLocal<S3Auth> threadLocalS3Auth = new ThreadLocal();
    private boolean s3AuthCheck;
    public static final int BLOCK_ALLOCATION_RETRY_COUNT = 90;
    public static final int BLOCK_ALLOCATION_RETRY_WAIT_TIME_MS = 1000;

    public OzoneManagerProtocolClientSideTranslatorPB(OmTransport omTransport, String clientId) {
        this.clientID = clientId;
        this.transport = omTransport;
        this.s3AuthCheck = false;
    }

    @Override
    public void close() throws IOException {
        this.transport.close();
    }

    private OzoneManagerProtocolProtos.OMRequest.Builder createOMRequest(OzoneManagerProtocolProtos.Type cmdType) {
        return OzoneManagerProtocolProtos.OMRequest.newBuilder().setCmdType(cmdType).setVersion(ClientVersion.CURRENT_VERSION).setClientId(this.clientID);
    }

    private OzoneManagerProtocolProtos.OMResponse submitRequest(OzoneManagerProtocolProtos.OMRequest omRequest) throws IOException {
        OzoneManagerProtocolProtos.OMRequest.Builder builder = OzoneManagerProtocolProtos.OMRequest.newBuilder((OzoneManagerProtocolProtos.OMRequest)omRequest);
        if (this.getThreadLocalS3Auth() != null) {
            builder.setS3Authentication(OzoneManagerProtocolProtos.S3Authentication.newBuilder().setSignature(this.threadLocalS3Auth.get().getSignature()).setStringToSign(this.threadLocalS3Auth.get().getStringTosSign()).setAccessId(this.threadLocalS3Auth.get().getAccessID()).build());
        }
        if (this.s3AuthCheck && this.getThreadLocalS3Auth() == null) {
            throw new IllegalArgumentException("S3 Auth expected to be set but is null " + omRequest.toString());
        }
        if (this.threadLocalS3Auth.get() != null && !Strings.isNullOrEmpty((String)this.threadLocalS3Auth.get().getAccessID())) {
            String caller = "S3Auth:S3G|" + this.threadLocalS3Auth.get().getAccessID();
            CallerContext callerContext = new CallerContext.Builder(caller).build();
            CallerContext.setCurrent((CallerContext)callerContext);
        }
        OzoneManagerProtocolProtos.OMResponse response = this.transport.submitRequest(builder.setTraceID(TracingUtil.exportCurrentSpan()).build());
        return response;
    }

    @Override
    public void createVolume(OmVolumeArgs args) throws IOException {
        OzoneManagerProtocolProtos.CreateVolumeRequest.Builder req = OzoneManagerProtocolProtos.CreateVolumeRequest.newBuilder();
        OzoneManagerProtocolProtos.VolumeInfo volumeInfo = args.getProtobuf();
        req.setVolumeInfo(volumeInfo);
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.CreateVolume).setCreateVolumeRequest(req).build();
        OzoneManagerProtocolProtos.OMResponse omResponse = this.submitRequest(omRequest);
        this.handleError(omResponse);
    }

    @Override
    public boolean setOwner(String volume, String owner) throws IOException {
        OzoneManagerProtocolProtos.SetVolumePropertyRequest.Builder req = OzoneManagerProtocolProtos.SetVolumePropertyRequest.newBuilder();
        req.setVolumeName(volume).setOwnerName(owner);
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.SetVolumeProperty).setSetVolumePropertyRequest(req).build();
        OzoneManagerProtocolProtos.OMResponse omResponse = this.submitRequest(omRequest);
        OzoneManagerProtocolProtos.SetVolumePropertyResponse response = this.handleError(omResponse).getSetVolumePropertyResponse();
        return response.getResponse();
    }

    @Override
    public void setQuota(String volume, long quotaInNamespace, long quotaInBytes) throws IOException {
        OzoneManagerProtocolProtos.SetVolumePropertyRequest.Builder req = OzoneManagerProtocolProtos.SetVolumePropertyRequest.newBuilder();
        req.setVolumeName(volume).setQuotaInBytes(quotaInBytes).setQuotaInNamespace(quotaInNamespace);
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.SetVolumeProperty).setSetVolumePropertyRequest(req).build();
        OzoneManagerProtocolProtos.OMResponse omResponse = this.submitRequest(omRequest);
        this.handleError(omResponse);
    }

    @Override
    public boolean checkVolumeAccess(String volume, OzoneManagerProtocolProtos.OzoneAclInfo userAcl) throws IOException {
        OzoneManagerProtocolProtos.CheckVolumeAccessRequest.Builder req = OzoneManagerProtocolProtos.CheckVolumeAccessRequest.newBuilder();
        req.setVolumeName(volume).setUserAcl(userAcl);
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.CheckVolumeAccess).setCheckVolumeAccessRequest(req).build();
        OzoneManagerProtocolProtos.OMResponse omResponse = this.submitRequest(omRequest);
        if (omResponse.getStatus() == OzoneManagerProtocolProtos.Status.ACCESS_DENIED) {
            return false;
        }
        if (omResponse.getStatus() == OzoneManagerProtocolProtos.Status.OK) {
            return true;
        }
        this.handleError(omResponse);
        return false;
    }

    @Override
    public OmVolumeArgs getVolumeInfo(String volume) throws IOException {
        OzoneManagerProtocolProtos.InfoVolumeRequest.Builder req = OzoneManagerProtocolProtos.InfoVolumeRequest.newBuilder();
        req.setVolumeName(volume);
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.InfoVolume).setInfoVolumeRequest(req).build();
        OzoneManagerProtocolProtos.InfoVolumeResponse resp = this.handleError(this.submitRequest(omRequest)).getInfoVolumeResponse();
        return OmVolumeArgs.getFromProtobuf(resp.getVolumeInfo());
    }

    @Override
    public void deleteVolume(String volume) throws IOException {
        OzoneManagerProtocolProtos.DeleteVolumeRequest.Builder req = OzoneManagerProtocolProtos.DeleteVolumeRequest.newBuilder();
        req.setVolumeName(volume);
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.DeleteVolume).setDeleteVolumeRequest(req).build();
        this.handleError(this.submitRequest(omRequest));
    }

    @Override
    public List<OmVolumeArgs> listVolumeByUser(String userName, String prefix, String prevKey, int maxKeys) throws IOException {
        OzoneManagerProtocolProtos.ListVolumeRequest.Builder builder = OzoneManagerProtocolProtos.ListVolumeRequest.newBuilder();
        if (!Strings.isNullOrEmpty((String)prefix)) {
            builder.setPrefix(prefix);
        }
        if (!Strings.isNullOrEmpty((String)prevKey)) {
            builder.setPrevKey(prevKey);
        }
        builder.setMaxKeys(maxKeys);
        builder.setUserName(userName);
        builder.setScope(OzoneManagerProtocolProtos.ListVolumeRequest.Scope.VOLUMES_BY_USER);
        return this.listVolume(builder.build());
    }

    @Override
    public List<OmVolumeArgs> listAllVolumes(String prefix, String prevKey, int maxKeys) throws IOException {
        OzoneManagerProtocolProtos.ListVolumeRequest.Builder builder = OzoneManagerProtocolProtos.ListVolumeRequest.newBuilder();
        if (!Strings.isNullOrEmpty((String)prefix)) {
            builder.setPrefix(prefix);
        }
        if (!Strings.isNullOrEmpty((String)prevKey)) {
            builder.setPrevKey(prevKey);
        }
        builder.setMaxKeys(maxKeys);
        builder.setScope(OzoneManagerProtocolProtos.ListVolumeRequest.Scope.VOLUMES_BY_CLUSTER);
        return this.listVolume(builder.build());
    }

    private List<OmVolumeArgs> listVolume(OzoneManagerProtocolProtos.ListVolumeRequest request) throws IOException {
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.ListVolume).setListVolumeRequest(request).build();
        OzoneManagerProtocolProtos.ListVolumeResponse resp = this.handleError(this.submitRequest(omRequest)).getListVolumeResponse();
        ArrayList<OmVolumeArgs> list = new ArrayList<OmVolumeArgs>(resp.getVolumeInfoList().size());
        for (OzoneManagerProtocolProtos.VolumeInfo info : resp.getVolumeInfoList()) {
            list.add(OmVolumeArgs.getFromProtobuf(info));
        }
        return list;
    }

    @Override
    public void createBucket(OmBucketInfo bucketInfo) throws IOException {
        OzoneManagerProtocolProtos.CreateBucketRequest.Builder req = OzoneManagerProtocolProtos.CreateBucketRequest.newBuilder();
        OzoneManagerProtocolProtos.BucketInfo bucketInfoProtobuf = bucketInfo.getProtobuf();
        req.setBucketInfo(bucketInfoProtobuf);
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.CreateBucket).setCreateBucketRequest(req).build();
        this.handleError(this.submitRequest(omRequest));
    }

    @Override
    public OmBucketInfo getBucketInfo(String volume, String bucket) throws IOException {
        OzoneManagerProtocolProtos.InfoBucketRequest.Builder req = OzoneManagerProtocolProtos.InfoBucketRequest.newBuilder();
        req.setVolumeName(volume);
        req.setBucketName(bucket);
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.InfoBucket).setInfoBucketRequest(req).build();
        OzoneManagerProtocolProtos.InfoBucketResponse resp = this.handleError(this.submitRequest(omRequest)).getInfoBucketResponse();
        return OmBucketInfo.getFromProtobuf(resp.getBucketInfo());
    }

    @Override
    public void setBucketProperty(OmBucketArgs args) throws IOException {
        OzoneManagerProtocolProtos.SetBucketPropertyRequest.Builder req = OzoneManagerProtocolProtos.SetBucketPropertyRequest.newBuilder();
        OzoneManagerProtocolProtos.BucketArgs bucketArgs = args.getProtobuf();
        req.setBucketArgs(bucketArgs);
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.SetBucketProperty).setSetBucketPropertyRequest(req).build();
        this.handleError(this.submitRequest(omRequest));
    }

    @Override
    public boolean setBucketOwner(OmBucketArgs args) throws IOException {
        OzoneManagerProtocolProtos.SetBucketPropertyRequest.Builder req = OzoneManagerProtocolProtos.SetBucketPropertyRequest.newBuilder();
        OzoneManagerProtocolProtos.BucketArgs bucketArgs = args.getProtobuf();
        req.setBucketArgs(bucketArgs);
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.SetBucketProperty).setSetBucketPropertyRequest(req).build();
        OzoneManagerProtocolProtos.OMResponse omResponse = this.submitRequest(omRequest);
        OzoneManagerProtocolProtos.SetBucketPropertyResponse response = this.handleError(omResponse).getSetBucketPropertyResponse();
        return response.getResponse();
    }

    @Override
    public List<OmBucketInfo> listBuckets(String volumeName, String startKey, String prefix, int count, boolean hasSnapshot) throws IOException {
        ArrayList<OmBucketInfo> buckets = new ArrayList<OmBucketInfo>();
        OzoneManagerProtocolProtos.ListBucketsRequest.Builder reqBuilder = OzoneManagerProtocolProtos.ListBucketsRequest.newBuilder();
        reqBuilder.setVolumeName(volumeName);
        reqBuilder.setCount(count);
        reqBuilder.setHasSnapshot(hasSnapshot);
        if (startKey != null) {
            reqBuilder.setStartKey(startKey);
        }
        if (prefix != null) {
            reqBuilder.setPrefix(prefix);
        }
        OzoneManagerProtocolProtos.ListBucketsRequest request = reqBuilder.build();
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.ListBuckets).setListBucketsRequest(request).build();
        OzoneManagerProtocolProtos.ListBucketsResponse resp = this.handleError(this.submitRequest(omRequest)).getListBucketsResponse();
        buckets.addAll(resp.getBucketInfoList().stream().map(OmBucketInfo::getFromProtobuf).collect(Collectors.toList()));
        return buckets;
    }

    @Override
    public OpenKeySession openKey(OmKeyArgs args) throws IOException {
        OzoneManagerProtocolProtos.CreateKeyRequest.Builder req = OzoneManagerProtocolProtos.CreateKeyRequest.newBuilder();
        OzoneManagerProtocolProtos.KeyArgs.Builder keyArgs = OzoneManagerProtocolProtos.KeyArgs.newBuilder().setVolumeName(args.getVolumeName()).setBucketName(args.getBucketName()).setKeyName(args.getKeyName());
        if (args.getOwner() != null) {
            keyArgs.setOwnerName(args.getOwner());
        }
        if (args.getAcls() != null) {
            keyArgs.addAllAcls((Iterable)args.getAcls().stream().distinct().map(a -> OzoneAcl.toProtobuf(a)).collect(Collectors.toList()));
        }
        if (args.getReplicationConfig() != null) {
            if (args.getReplicationConfig() instanceof ECReplicationConfig) {
                keyArgs.setEcReplicationConfig(((ECReplicationConfig)args.getReplicationConfig()).toProto());
            } else {
                keyArgs.setFactor(ReplicationConfig.getLegacyFactor((ReplicationConfig)args.getReplicationConfig()));
            }
            keyArgs.setType(args.getReplicationConfig().getReplicationType());
        }
        if (args.getDataSize() > 0L) {
            keyArgs.setDataSize(args.getDataSize());
        }
        if (args.getMetadata() != null && !args.getMetadata().isEmpty()) {
            keyArgs.addAllMetadata(KeyValueUtil.toProtobuf(args.getMetadata()));
        }
        if (args.getTags() != null && !args.getTags().isEmpty()) {
            keyArgs.addAllTags(KeyValueUtil.toProtobuf(args.getTags()));
        }
        if (args.getMultipartUploadID() != null) {
            keyArgs.setMultipartUploadID(args.getMultipartUploadID());
        }
        if (args.getMultipartUploadPartNumber() > 0) {
            keyArgs.setMultipartNumber(args.getMultipartUploadPartNumber());
        }
        keyArgs.setIsMultipartKey(args.getIsMultipartKey());
        keyArgs.setSortDatanodes(args.getSortDatanodes());
        if (args.getExpectedDataGeneration() != null) {
            keyArgs.setExpectedDataGeneration(args.getExpectedDataGeneration().longValue());
        }
        req.setKeyArgs(keyArgs.build());
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.CreateKey).setCreateKeyRequest(req).build();
        OzoneManagerProtocolProtos.CreateKeyResponse keyResponse = this.handleSubmitRequestAndSCMSafeModeRetry(omRequest).getCreateKeyResponse();
        return new OpenKeySession(keyResponse.getID(), OmKeyInfo.getFromProtobuf(keyResponse.getKeyInfo()), keyResponse.getOpenVersion());
    }

    private OzoneManagerProtocolProtos.OMResponse handleError(OzoneManagerProtocolProtos.OMResponse resp) throws OMException {
        if (resp.getStatus() != OzoneManagerProtocolProtos.Status.OK) {
            throw new OMException(resp.getMessage(), OMException.ResultCodes.values()[resp.getStatus().ordinal()]);
        }
        return resp;
    }

    @Override
    public OmKeyLocationInfo allocateBlock(OmKeyArgs args, long clientId, ExcludeList excludeList) throws IOException {
        OzoneManagerProtocolProtos.AllocateBlockRequest.Builder req = OzoneManagerProtocolProtos.AllocateBlockRequest.newBuilder();
        OzoneManagerProtocolProtos.KeyArgs.Builder keyArgs = OzoneManagerProtocolProtos.KeyArgs.newBuilder().setVolumeName(args.getVolumeName()).setBucketName(args.getBucketName()).setKeyName(args.getKeyName()).setDataSize(args.getDataSize()).setSortDatanodes(args.getSortDatanodes());
        if (args.getReplicationConfig() != null) {
            if (args.getReplicationConfig() instanceof ECReplicationConfig) {
                keyArgs.setEcReplicationConfig(((ECReplicationConfig)args.getReplicationConfig()).toProto());
            } else {
                keyArgs.setFactor(ReplicationConfig.getLegacyFactor((ReplicationConfig)args.getReplicationConfig()));
            }
            keyArgs.setType(args.getReplicationConfig().getReplicationType());
        }
        req.setKeyArgs(keyArgs);
        req.setClientID(clientId);
        req.setExcludeList(excludeList.getProtoBuf());
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.AllocateBlock).setAllocateBlockRequest(req).build();
        OzoneManagerProtocolProtos.AllocateBlockResponse resp = this.handleSubmitRequestAndSCMSafeModeRetry(omRequest).getAllocateBlockResponse();
        return OmKeyLocationInfo.getFromProtobuf(resp.getKeyLocation());
    }

    @Override
    public void hsyncKey(OmKeyArgs args, long clientId) throws IOException {
        this.updateKey(args, clientId, true, false);
    }

    @Override
    public void commitKey(OmKeyArgs args, long clientId) throws IOException {
        this.updateKey(args, clientId, false, false);
    }

    @Override
    public void recoverKey(OmKeyArgs args, long clientId) throws IOException {
        this.updateKey(args, clientId, false, true);
    }

    public static void setReplicationConfig(ReplicationConfig replication, OzoneManagerProtocolProtos.KeyArgs.Builder b) {
        if (replication == null) {
            return;
        }
        if (replication instanceof ECReplicationConfig) {
            b.setEcReplicationConfig(((ECReplicationConfig)replication).toProto());
        } else {
            b.setFactor(ReplicationConfig.getLegacyFactor((ReplicationConfig)replication));
        }
        b.setType(replication.getReplicationType());
    }

    private void updateKey(OmKeyArgs args, long clientId, boolean hsync, boolean recovery) throws IOException {
        OzoneManagerProtocolProtos.CommitKeyRequest.Builder req = OzoneManagerProtocolProtos.CommitKeyRequest.newBuilder();
        List<OmKeyLocationInfo> locationInfoList = args.getLocationInfoList();
        Preconditions.checkNotNull(locationInfoList);
        OzoneManagerProtocolProtos.KeyArgs.Builder keyArgsBuilder = OzoneManagerProtocolProtos.KeyArgs.newBuilder().setVolumeName(args.getVolumeName()).setBucketName(args.getBucketName()).setKeyName(args.getKeyName()).setDataSize(args.getDataSize()).addAllMetadata(KeyValueUtil.toProtobuf(args.getMetadata())).addAllKeyLocations((Iterable)locationInfoList.stream().map(info -> info.getProtobuf(ClientVersion.CURRENT_VERSION)).collect(Collectors.toList()));
        OzoneManagerProtocolClientSideTranslatorPB.setReplicationConfig(args.getReplicationConfig(), keyArgsBuilder);
        req.setKeyArgs(keyArgsBuilder.build());
        req.setClientID(clientId);
        req.setHsync(hsync);
        req.setRecovery(recovery);
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.CommitKey).setCommitKeyRequest(req).build();
        this.handleError(this.submitRequest(omRequest));
    }

    @Override
    public OmKeyInfo lookupKey(OmKeyArgs args) throws IOException {
        OzoneManagerProtocolProtos.LookupKeyRequest.Builder req = OzoneManagerProtocolProtos.LookupKeyRequest.newBuilder();
        req.setKeyArgs(args.toProtobuf());
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.LookupKey).setLookupKeyRequest(req).build();
        OzoneManagerProtocolProtos.LookupKeyResponse resp = this.handleError(this.submitRequest(omRequest)).getLookupKeyResponse();
        return OmKeyInfo.getFromProtobuf(resp.getKeyInfo());
    }

    @Override
    public KeyInfoWithVolumeContext getKeyInfo(OmKeyArgs args, boolean assumeS3Context) throws IOException {
        OzoneManagerProtocolProtos.GetKeyInfoRequest.Builder req = OzoneManagerProtocolProtos.GetKeyInfoRequest.newBuilder();
        req.setKeyArgs(args.toProtobuf());
        req.setAssumeS3Context(assumeS3Context);
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.GetKeyInfo).setGetKeyInfoRequest(req).build();
        OzoneManagerProtocolProtos.GetKeyInfoResponse resp = this.handleError(this.submitRequest(omRequest)).getGetKeyInfoResponse();
        return KeyInfoWithVolumeContext.fromProtobuf(resp);
    }

    @Override
    @Deprecated
    public void renameKeys(OmRenameKeys omRenameKeys) throws IOException {
        ArrayList<OzoneManagerProtocolProtos.RenameKeysMap> renameKeyList = new ArrayList<OzoneManagerProtocolProtos.RenameKeysMap>();
        for (Map.Entry<String, String> entry : omRenameKeys.getFromAndToKey().entrySet()) {
            OzoneManagerProtocolProtos.RenameKeysMap.Builder renameKey = OzoneManagerProtocolProtos.RenameKeysMap.newBuilder().setFromKeyName(entry.getKey()).setToKeyName(entry.getValue());
            renameKeyList.add(renameKey.build());
        }
        OzoneManagerProtocolProtos.RenameKeysArgs.Builder renameKeyArgs = OzoneManagerProtocolProtos.RenameKeysArgs.newBuilder().setVolumeName(omRenameKeys.getVolume()).setBucketName(omRenameKeys.getBucket()).addAllRenameKeysMap(renameKeyList);
        OzoneManagerProtocolProtos.RenameKeysRequest.Builder reqKeys = OzoneManagerProtocolProtos.RenameKeysRequest.newBuilder().setRenameKeysArgs(renameKeyArgs.build());
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.RenameKeys).setRenameKeysRequest(reqKeys.build()).build();
        this.handleError(this.submitRequest(omRequest));
    }

    @Override
    public void renameKey(OmKeyArgs args, String toKeyName) throws IOException {
        OzoneManagerProtocolProtos.RenameKeyRequest.Builder req = OzoneManagerProtocolProtos.RenameKeyRequest.newBuilder();
        OzoneManagerProtocolProtos.KeyArgs keyArgs = OzoneManagerProtocolProtos.KeyArgs.newBuilder().setVolumeName(args.getVolumeName()).setBucketName(args.getBucketName()).setKeyName(args.getKeyName()).setDataSize(args.getDataSize()).build();
        req.setKeyArgs(keyArgs);
        req.setToKeyName(toKeyName);
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.RenameKey).setRenameKeyRequest(req).build();
        this.handleError(this.submitRequest(omRequest));
    }

    @Override
    public void deleteKey(OmKeyArgs args) throws IOException {
        OzoneManagerProtocolProtos.DeleteKeyRequest.Builder req = OzoneManagerProtocolProtos.DeleteKeyRequest.newBuilder();
        OzoneManagerProtocolProtos.KeyArgs keyArgs = OzoneManagerProtocolProtos.KeyArgs.newBuilder().setVolumeName(args.getVolumeName()).setBucketName(args.getBucketName()).setKeyName(args.getKeyName()).setRecursive(args.isRecursive()).build();
        req.setKeyArgs(keyArgs);
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.DeleteKey).setDeleteKeyRequest(req).build();
        this.handleError(this.submitRequest(omRequest));
    }

    @Override
    public void deleteKeys(OmDeleteKeys deleteKeys) throws IOException {
        this.deleteKeys(deleteKeys, false);
    }

    @Override
    public Map<String, ErrorInfo> deleteKeys(OmDeleteKeys deleteKeys, boolean quiet) throws IOException {
        OzoneManagerProtocolProtos.DeleteKeysRequest.Builder req = OzoneManagerProtocolProtos.DeleteKeysRequest.newBuilder();
        OzoneManagerProtocolProtos.DeleteKeyArgs deletedKeys = OzoneManagerProtocolProtos.DeleteKeyArgs.newBuilder().setBucketName(deleteKeys.getBucket()).setVolumeName(deleteKeys.getVolume()).addAllKeys(deleteKeys.getKeyNames()).build();
        req.setDeleteKeys(deletedKeys);
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.DeleteKeys).setDeleteKeysRequest(req).build();
        OzoneManagerProtocolProtos.OMResponse omResponse = this.submitRequest(omRequest);
        HashMap<String, ErrorInfo> keyToErrors = new HashMap<String, ErrorInfo>();
        if (quiet) {
            List errors = omResponse.getDeleteKeysResponse().getErrorsList();
            for (OzoneManagerProtocolProtos.DeleteKeyError deleteKeyError : errors) {
                keyToErrors.put(deleteKeyError.getKey(), new ErrorInfo(deleteKeyError.getErrorCode(), deleteKeyError.getErrorMsg()));
            }
        } else {
            this.handleError(omResponse);
        }
        return keyToErrors;
    }

    @Override
    public void deleteBucket(String volume, String bucket) throws IOException {
        OzoneManagerProtocolProtos.DeleteBucketRequest.Builder req = OzoneManagerProtocolProtos.DeleteBucketRequest.newBuilder();
        req.setVolumeName(volume);
        req.setBucketName(bucket);
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.DeleteBucket).setDeleteBucketRequest(req).build();
        this.handleError(this.submitRequest(omRequest));
    }

    @Override
    public ListKeysResult listKeys(String volumeName, String bucketName, String startKey, String prefix, int maxKeys) throws IOException {
        ArrayList<OmKeyInfo> keys = new ArrayList<OmKeyInfo>();
        OzoneManagerProtocolProtos.ListKeysRequest.Builder reqBuilder = OzoneManagerProtocolProtos.ListKeysRequest.newBuilder();
        reqBuilder.setVolumeName(volumeName);
        reqBuilder.setBucketName(bucketName);
        reqBuilder.setCount(maxKeys);
        if (startKey != null) {
            reqBuilder.setStartKey(startKey);
        }
        if (prefix != null) {
            reqBuilder.setPrefix(prefix);
        }
        OzoneManagerProtocolProtos.ListKeysRequest req = reqBuilder.build();
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.ListKeys).setListKeysRequest(req).build();
        OzoneManagerProtocolProtos.ListKeysResponse resp = this.handleError(this.submitRequest(omRequest)).getListKeysResponse();
        ArrayList<OmKeyInfo> list = new ArrayList<OmKeyInfo>();
        for (OzoneManagerProtocolProtos.KeyInfo keyInfo : resp.getKeyInfoList()) {
            OmKeyInfo fromProtobuf = OmKeyInfo.getFromProtobuf(keyInfo);
            list.add(fromProtobuf);
        }
        keys.addAll(list);
        return new ListKeysResult(keys, resp.getIsTruncated());
    }

    @Override
    public ListKeysLightResult listKeysLight(String volumeName, String bucketName, String startKey, String prefix, int maxKeys) throws IOException {
        ArrayList<BasicOmKeyInfo> keys = new ArrayList<BasicOmKeyInfo>();
        OzoneManagerProtocolProtos.ListKeysRequest.Builder reqBuilder = OzoneManagerProtocolProtos.ListKeysRequest.newBuilder();
        reqBuilder.setVolumeName(volumeName);
        reqBuilder.setBucketName(bucketName);
        reqBuilder.setCount(maxKeys);
        if (startKey != null) {
            reqBuilder.setStartKey(startKey);
        }
        if (prefix != null) {
            reqBuilder.setPrefix(prefix);
        }
        OzoneManagerProtocolProtos.ListKeysRequest req = reqBuilder.build();
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.ListKeysLight).setListKeysRequest(req).build();
        OzoneManagerProtocolProtos.ListKeysLightResponse resp = this.handleError(this.submitRequest(omRequest)).getListKeysLightResponse();
        for (OzoneManagerProtocolProtos.BasicKeyInfo basicKeyInfo : resp.getBasicKeyInfoList()) {
            BasicOmKeyInfo fromProtobuf = BasicOmKeyInfo.getFromProtobuf(basicKeyInfo, req);
            keys.add(fromProtobuf);
        }
        return new ListKeysLightResult(keys, resp.getIsTruncated());
    }

    @Override
    @Nonnull
    public S3SecretValue getS3Secret(String kerberosID) throws IOException {
        OzoneManagerProtocolProtos.GetS3SecretRequest request = OzoneManagerProtocolProtos.GetS3SecretRequest.newBuilder().setKerberosID(kerberosID).build();
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.GetS3Secret).setGetS3SecretRequest(request).build();
        OzoneManagerProtocolProtos.GetS3SecretResponse resp = this.handleError(this.submitRequest(omRequest)).getGetS3SecretResponse();
        return S3SecretValue.fromProtobuf(resp.getS3Secret());
    }

    @Override
    public S3SecretValue getS3Secret(String kerberosID, boolean createIfNotExist) throws IOException {
        OzoneManagerProtocolProtos.GetS3SecretRequest request = OzoneManagerProtocolProtos.GetS3SecretRequest.newBuilder().setKerberosID(kerberosID).setCreateIfNotExist(createIfNotExist).build();
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.GetS3Secret).setGetS3SecretRequest(request).build();
        OzoneManagerProtocolProtos.GetS3SecretResponse resp = this.handleError(this.submitRequest(omRequest)).getGetS3SecretResponse();
        return S3SecretValue.fromProtobuf(resp.getS3Secret());
    }

    @Override
    public S3SecretValue setS3Secret(String accessId, String secretKey) throws IOException {
        OzoneManagerProtocolProtos.SetS3SecretRequest request = OzoneManagerProtocolProtos.SetS3SecretRequest.newBuilder().setAccessId(accessId).setSecretKey(secretKey).build();
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.SetS3Secret).setSetS3SecretRequest(request).build();
        OzoneManagerProtocolProtos.SetS3SecretResponse resp = this.handleError(this.submitRequest(omRequest)).getSetS3SecretResponse();
        OzoneManagerProtocolProtos.S3Secret accessIdSecretKeyPair = OzoneManagerProtocolProtos.S3Secret.newBuilder().setKerberosID(resp.getAccessId()).setAwsSecret(resp.getSecretKey()).build();
        return S3SecretValue.fromProtobuf(accessIdSecretKeyPair);
    }

    @Override
    public void revokeS3Secret(String kerberosID) throws IOException {
        OzoneManagerProtocolProtos.RevokeS3SecretRequest request = OzoneManagerProtocolProtos.RevokeS3SecretRequest.newBuilder().setKerberosID(kerberosID).build();
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.RevokeS3Secret).setRevokeS3SecretRequest(request).build();
        this.handleError(this.submitRequest(omRequest));
    }

    @Override
    public void createTenant(OmTenantArgs omTenantArgs) throws IOException {
        OzoneManagerProtocolProtos.CreateTenantRequest.Builder requestBuilder = OzoneManagerProtocolProtos.CreateTenantRequest.newBuilder().setTenantId(omTenantArgs.getTenantId()).setVolumeName(omTenantArgs.getVolumeName()).setForceCreationWhenVolumeExists(omTenantArgs.getForceCreationWhenVolumeExists());
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.CreateTenant).setCreateTenantRequest(requestBuilder).build();
        OzoneManagerProtocolProtos.OMResponse omResponse = this.submitRequest(omRequest);
        this.handleError(omResponse);
    }

    @Override
    public DeleteTenantState deleteTenant(String tenantId) throws IOException {
        OzoneManagerProtocolProtos.DeleteTenantRequest.Builder requestBuilder = OzoneManagerProtocolProtos.DeleteTenantRequest.newBuilder().setTenantId(tenantId);
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.DeleteTenant).setDeleteTenantRequest(requestBuilder).build();
        OzoneManagerProtocolProtos.OMResponse omResponse = this.submitRequest(omRequest);
        OzoneManagerProtocolProtos.DeleteTenantResponse resp = this.handleError(omResponse).getDeleteTenantResponse();
        return DeleteTenantState.fromProtobuf(resp);
    }

    @Override
    public S3SecretValue tenantAssignUserAccessId(String username, String tenantId, String accessId) throws IOException {
        OzoneManagerProtocolProtos.TenantAssignUserAccessIdRequest.Builder requestBuilder = OzoneManagerProtocolProtos.TenantAssignUserAccessIdRequest.newBuilder().setUserPrincipal(username).setTenantId(tenantId).setAccessId(accessId);
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.TenantAssignUserAccessId).setTenantAssignUserAccessIdRequest(requestBuilder).build();
        OzoneManagerProtocolProtos.OMResponse omResponse = this.submitRequest(omRequest);
        OzoneManagerProtocolProtos.TenantAssignUserAccessIdResponse resp = this.handleError(omResponse).getTenantAssignUserAccessIdResponse();
        return S3SecretValue.fromProtobuf(resp.getS3Secret());
    }

    @Override
    public void tenantRevokeUserAccessId(String accessId) throws IOException {
        OzoneManagerProtocolProtos.TenantRevokeUserAccessIdRequest.Builder requestBuilder = OzoneManagerProtocolProtos.TenantRevokeUserAccessIdRequest.newBuilder().setAccessId(accessId);
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.TenantRevokeUserAccessId).setTenantRevokeUserAccessIdRequest(requestBuilder).build();
        OzoneManagerProtocolProtos.OMResponse omResponse = this.submitRequest(omRequest);
        this.handleError(omResponse);
    }

    @Override
    public String createSnapshot(String volumeName, String bucketName, String snapshotName) throws IOException {
        OzoneManagerProtocolProtos.CreateSnapshotRequest.Builder requestBuilder = OzoneManagerProtocolProtos.CreateSnapshotRequest.newBuilder().setVolumeName(volumeName).setBucketName(bucketName);
        if (!StringUtils.isBlank((CharSequence)snapshotName)) {
            requestBuilder.setSnapshotName(snapshotName);
        }
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.CreateSnapshot).setCreateSnapshotRequest(requestBuilder).build();
        OzoneManagerProtocolProtos.OMResponse omResponse = this.submitRequest(omRequest);
        this.handleError(omResponse);
        SnapshotInfo snapshotInfo = SnapshotInfo.getFromProtobuf(omResponse.getCreateSnapshotResponse().getSnapshotInfo());
        return snapshotInfo.getName();
    }

    @Override
    public void renameSnapshot(String volumeName, String bucketName, String snapshotOldName, String snapshotNewName) throws IOException {
        OzoneManagerProtocolProtos.RenameSnapshotRequest.Builder requestBuilder = OzoneManagerProtocolProtos.RenameSnapshotRequest.newBuilder().setVolumeName(volumeName).setBucketName(bucketName).setSnapshotOldName(snapshotOldName).setSnapshotNewName(snapshotNewName);
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.RenameSnapshot).setRenameSnapshotRequest(requestBuilder).build();
        OzoneManagerProtocolProtos.OMResponse omResponse = this.submitRequest(omRequest);
        this.handleError(omResponse);
    }

    @Override
    public void deleteSnapshot(String volumeName, String bucketName, String snapshotName) throws IOException {
        OzoneManagerProtocolProtos.DeleteSnapshotRequest.Builder requestBuilder = OzoneManagerProtocolProtos.DeleteSnapshotRequest.newBuilder().setVolumeName(volumeName).setBucketName(bucketName).setSnapshotName(snapshotName);
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.DeleteSnapshot).setDeleteSnapshotRequest(requestBuilder).build();
        OzoneManagerProtocolProtos.OMResponse omResponse = this.submitRequest(omRequest);
        this.handleError(omResponse);
    }

    @Override
    public SnapshotInfo getSnapshotInfo(String volumeName, String bucketName, String snapshotName) throws IOException {
        OzoneManagerProtocolProtos.SnapshotInfoRequest.Builder requestBuilder = OzoneManagerProtocolProtos.SnapshotInfoRequest.newBuilder().setVolumeName(volumeName).setBucketName(bucketName).setSnapshotName(snapshotName);
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.GetSnapshotInfo).setSnapshotInfoRequest(requestBuilder).build();
        OzoneManagerProtocolProtos.OMResponse omResponse = this.submitRequest(omRequest);
        this.handleError(omResponse);
        return SnapshotInfo.getFromProtobuf(omResponse.getSnapshotInfoResponse().getSnapshotInfo());
    }

    @Override
    public String printCompactionLogDag(String fileNamePrefix, String graphType) throws IOException {
        OzoneManagerProtocolProtos.PrintCompactionLogDagRequest.Builder request = OzoneManagerProtocolProtos.PrintCompactionLogDagRequest.newBuilder();
        if (fileNamePrefix != null) {
            request.setFileNamePrefix(fileNamePrefix);
        }
        if (graphType != null) {
            request.setGraphType(graphType);
        }
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.PrintCompactionLogDag).setPrintCompactionLogDagRequest(request.build()).build();
        OzoneManagerProtocolProtos.OMResponse omResponse = this.submitRequest(omRequest);
        this.handleError(omResponse);
        return omResponse.getPrintCompactionLogDagResponse().getMessage();
    }

    @Override
    public ListSnapshotResponse listSnapshot(String volumeName, String bucketName, String snapshotPrefix, String prevSnapshot, int maxListResult) throws IOException {
        OzoneManagerProtocolProtos.ListSnapshotRequest.Builder requestBuilder = OzoneManagerProtocolProtos.ListSnapshotRequest.newBuilder().setVolumeName(volumeName).setBucketName(bucketName).setMaxListResult(maxListResult);
        if (prevSnapshot != null) {
            requestBuilder.setPrevSnapshot(prevSnapshot);
        }
        if (snapshotPrefix != null) {
            requestBuilder.setPrefix(snapshotPrefix);
        }
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.ListSnapshot).setListSnapshotRequest(requestBuilder).build();
        OzoneManagerProtocolProtos.OMResponse omResponse = this.submitRequest(omRequest);
        this.handleError(omResponse);
        OzoneManagerProtocolProtos.ListSnapshotResponse response = omResponse.getListSnapshotResponse();
        List<SnapshotInfo> snapshotInfos = response.getSnapshotInfoList().stream().map(snapshotInfo -> SnapshotInfo.getFromProtobuf(snapshotInfo)).collect(Collectors.toList());
        String lastSnapshot = null;
        if (response.hasLastSnapshot()) {
            lastSnapshot = response.getLastSnapshot();
        } else if (snapshotInfos.size() == maxListResult) {
            lastSnapshot = snapshotInfos.get(maxListResult - 1).getName();
        }
        return new ListSnapshotResponse(snapshotInfos, lastSnapshot);
    }

    @Override
    public SnapshotDiffResponse snapshotDiff(String volumeName, String bucketName, String fromSnapshot, String toSnapshot, String token, int pageSize, boolean forceFullDiff, boolean disableNativeDiff) throws IOException {
        OzoneManagerProtocolProtos.SnapshotDiffRequest.Builder requestBuilder = OzoneManagerProtocolProtos.SnapshotDiffRequest.newBuilder().setVolumeName(volumeName).setBucketName(bucketName).setFromSnapshot(fromSnapshot).setToSnapshot(toSnapshot).setPageSize(pageSize).setForceFullDiff(forceFullDiff).setDisableNativeDiff(disableNativeDiff);
        if (!StringUtils.isBlank((CharSequence)token)) {
            requestBuilder.setToken(token);
        }
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.SnapshotDiff).setSnapshotDiffRequest(requestBuilder).build();
        OzoneManagerProtocolProtos.OMResponse omResponse = this.submitRequest(omRequest);
        this.handleError(omResponse);
        OzoneManagerProtocolProtos.SnapshotDiffResponse diffResponse = omResponse.getSnapshotDiffResponse();
        return new SnapshotDiffResponse(SnapshotDiffReportOzone.fromProtobuf(diffResponse.getSnapshotDiffReport()), SnapshotDiffResponse.JobStatus.fromProtobuf(diffResponse.getJobStatus()), diffResponse.getWaitTimeInMs(), diffResponse.getReason());
    }

    @Override
    public CancelSnapshotDiffResponse cancelSnapshotDiff(String volumeName, String bucketName, String fromSnapshot, String toSnapshot) throws IOException {
        OzoneManagerProtocolProtos.CancelSnapshotDiffRequest.Builder requestBuilder = OzoneManagerProtocolProtos.CancelSnapshotDiffRequest.newBuilder().setVolumeName(volumeName).setBucketName(bucketName).setFromSnapshot(fromSnapshot).setToSnapshot(toSnapshot);
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.CancelSnapshotDiff).setCancelSnapshotDiffRequest(requestBuilder).build();
        OzoneManagerProtocolProtos.OMResponse omResponse = this.submitRequest(omRequest);
        this.handleError(omResponse);
        OzoneManagerProtocolProtos.CancelSnapshotDiffResponse diffResponse = omResponse.getCancelSnapshotDiffResponse();
        return new CancelSnapshotDiffResponse(diffResponse.getReason());
    }

    @Override
    public List<SnapshotDiffJob> listSnapshotDiffJobs(String volumeName, String bucketName, String jobStatus, boolean listAll) throws IOException {
        OzoneManagerProtocolProtos.ListSnapshotDiffJobRequest.Builder requestBuilder = OzoneManagerProtocolProtos.ListSnapshotDiffJobRequest.newBuilder().setVolumeName(volumeName).setBucketName(bucketName).setJobStatus(jobStatus).setListAll(listAll);
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.ListSnapshotDiffJobs).setListSnapshotDiffJobRequest(requestBuilder).build();
        OzoneManagerProtocolProtos.OMResponse omResponse = this.submitRequest(omRequest);
        this.handleError(omResponse);
        return omResponse.getListSnapshotDiffJobResponse().getSnapshotDiffJobList().stream().map(SnapshotDiffJob::getFromProtoBuf).collect(Collectors.toList());
    }

    @Override
    public void tenantAssignAdmin(String accessId, String tenantId, boolean delegated) throws IOException {
        OzoneManagerProtocolProtos.TenantAssignAdminRequest.Builder requestBuilder = OzoneManagerProtocolProtos.TenantAssignAdminRequest.newBuilder().setAccessId(accessId).setDelegated(delegated);
        if (tenantId != null) {
            requestBuilder.setTenantId(tenantId);
        }
        OzoneManagerProtocolProtos.TenantAssignAdminRequest request = requestBuilder.build();
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.TenantAssignAdmin).setTenantAssignAdminRequest(request).build();
        OzoneManagerProtocolProtos.OMResponse omResponse = this.submitRequest(omRequest);
        this.handleError(omResponse);
    }

    @Override
    public void tenantRevokeAdmin(String accessId, String tenantId) throws IOException {
        OzoneManagerProtocolProtos.TenantRevokeAdminRequest.Builder requestBuilder = OzoneManagerProtocolProtos.TenantRevokeAdminRequest.newBuilder().setAccessId(accessId);
        if (tenantId != null) {
            requestBuilder.setTenantId(tenantId);
        }
        OzoneManagerProtocolProtos.TenantRevokeAdminRequest request = requestBuilder.build();
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.TenantRevokeAdmin).setTenantRevokeAdminRequest(request).build();
        OzoneManagerProtocolProtos.OMResponse omResponse = this.submitRequest(omRequest);
        this.handleError(omResponse);
    }

    @Override
    public TenantUserInfoValue tenantGetUserInfo(String userPrincipal) throws IOException {
        OzoneManagerProtocolProtos.TenantGetUserInfoRequest.Builder requestBuilder = OzoneManagerProtocolProtos.TenantGetUserInfoRequest.newBuilder().setUserPrincipal(userPrincipal);
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.TenantGetUserInfo).setTenantGetUserInfoRequest(requestBuilder).build();
        OzoneManagerProtocolProtos.OMResponse omResponse = this.submitRequest(omRequest);
        OzoneManagerProtocolProtos.TenantGetUserInfoResponse resp = this.handleError(omResponse).getTenantGetUserInfoResponse();
        return TenantUserInfoValue.fromProtobuf(resp);
    }

    @Override
    public TenantUserList listUsersInTenant(String tenantId, String prefix) throws IOException {
        OzoneManagerProtocolProtos.TenantListUserRequest.Builder requestBuilder = OzoneManagerProtocolProtos.TenantListUserRequest.newBuilder().setTenantId(tenantId);
        if (prefix != null) {
            requestBuilder.setPrefix(prefix);
        }
        OzoneManagerProtocolProtos.TenantListUserRequest request = requestBuilder.build();
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.TenantListUser).setTenantListUserRequest(request).build();
        OzoneManagerProtocolProtos.OMResponse response = this.submitRequest(omRequest);
        OzoneManagerProtocolProtos.TenantListUserResponse resp = this.handleError(response).getTenantListUserResponse();
        return TenantUserList.fromProtobuf(resp);
    }

    @Override
    public TenantStateList listTenant() throws IOException {
        OzoneManagerProtocolProtos.ListTenantRequest.Builder requestBuilder = OzoneManagerProtocolProtos.ListTenantRequest.newBuilder();
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.ListTenant).setListTenantRequest(requestBuilder).build();
        OzoneManagerProtocolProtos.OMResponse omResponse = this.submitRequest(omRequest);
        OzoneManagerProtocolProtos.ListTenantResponse resp = this.handleError(omResponse).getListTenantResponse();
        return TenantStateList.fromProtobuf(resp.getTenantStateList());
    }

    @Override
    public S3VolumeContext getS3VolumeContext() throws IOException {
        OzoneManagerProtocolProtos.GetS3VolumeContextRequest.Builder requestBuilder = OzoneManagerProtocolProtos.GetS3VolumeContextRequest.newBuilder();
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.GetS3VolumeContext).setGetS3VolumeContextRequest(requestBuilder).build();
        OzoneManagerProtocolProtos.OMResponse omResponse = this.submitRequest(omRequest);
        OzoneManagerProtocolProtos.GetS3VolumeContextResponse resp = this.handleError(omResponse).getGetS3VolumeContextResponse();
        return S3VolumeContext.fromProtobuf(resp);
    }

    @Override
    public UUID refetchSecretKey() throws IOException {
        OzoneManagerProtocolProtos.RefetchSecretKeyRequest.Builder requestBuilder = OzoneManagerProtocolProtos.RefetchSecretKeyRequest.newBuilder();
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.RefetchSecretKey).setRefetchSecretKeyRequest(requestBuilder).build();
        OzoneManagerProtocolProtos.OMResponse omResponse = this.submitRequest(omRequest);
        OzoneManagerProtocolProtos.RefetchSecretKeyResponse resp = this.handleError(omResponse).getRefetchSecretKeyResponse();
        return ProtobufUtils.fromProtobuf((HddsProtos.UUID)resp.getId());
    }

    @Override
    public OmMultipartInfo initiateMultipartUpload(OmKeyArgs omKeyArgs) throws IOException {
        OzoneManagerProtocolProtos.MultipartInfoInitiateRequest.Builder multipartInfoInitiateRequest = OzoneManagerProtocolProtos.MultipartInfoInitiateRequest.newBuilder();
        OzoneManagerProtocolProtos.KeyArgs.Builder keyArgs = OzoneManagerProtocolProtos.KeyArgs.newBuilder().setVolumeName(omKeyArgs.getVolumeName()).setBucketName(omKeyArgs.getBucketName()).setKeyName(omKeyArgs.getKeyName()).addAllMetadata(KeyValueUtil.toProtobuf(omKeyArgs.getMetadata())).setOwnerName(omKeyArgs.getOwner()).addAllTags(KeyValueUtil.toProtobuf(omKeyArgs.getTags()));
        if (omKeyArgs.getAcls() != null) {
            keyArgs.addAllAcls((Iterable)omKeyArgs.getAcls().stream().map(a -> OzoneAcl.toProtobuf(a)).collect(Collectors.toList()));
        }
        OzoneManagerProtocolClientSideTranslatorPB.setReplicationConfig(omKeyArgs.getReplicationConfig(), keyArgs);
        multipartInfoInitiateRequest.setKeyArgs(keyArgs.build());
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.InitiateMultiPartUpload).setInitiateMultiPartUploadRequest(multipartInfoInitiateRequest.build()).build();
        OzoneManagerProtocolProtos.MultipartInfoInitiateResponse resp = this.handleError(this.submitRequest(omRequest)).getInitiateMultiPartUploadResponse();
        return new OmMultipartInfo(resp.getVolumeName(), resp.getBucketName(), resp.getKeyName(), resp.getMultipartUploadID());
    }

    @Override
    public OmMultipartCommitUploadPartInfo commitMultipartUploadPart(OmKeyArgs omKeyArgs, long clientId) throws IOException {
        List<OmKeyLocationInfo> locationInfoList = omKeyArgs.getLocationInfoList();
        Preconditions.checkNotNull(locationInfoList);
        OzoneManagerProtocolProtos.MultipartCommitUploadPartRequest.Builder multipartCommitUploadPartRequest = OzoneManagerProtocolProtos.MultipartCommitUploadPartRequest.newBuilder();
        OzoneManagerProtocolProtos.KeyArgs.Builder keyArgs = OzoneManagerProtocolProtos.KeyArgs.newBuilder().setVolumeName(omKeyArgs.getVolumeName()).setBucketName(omKeyArgs.getBucketName()).setKeyName(omKeyArgs.getKeyName()).setMultipartUploadID(omKeyArgs.getMultipartUploadID()).setIsMultipartKey(omKeyArgs.getIsMultipartKey()).setMultipartNumber(omKeyArgs.getMultipartUploadPartNumber()).setDataSize(omKeyArgs.getDataSize()).addAllMetadata(KeyValueUtil.toProtobuf(omKeyArgs.getMetadata())).addAllKeyLocations((Iterable)locationInfoList.stream().map(info -> info.getProtobuf(ClientVersion.CURRENT_VERSION)).collect(Collectors.toList()));
        multipartCommitUploadPartRequest.setClientID(clientId);
        multipartCommitUploadPartRequest.setKeyArgs(keyArgs.build());
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.CommitMultiPartUpload).setCommitMultiPartUploadRequest(multipartCommitUploadPartRequest.build()).build();
        OzoneManagerProtocolProtos.MultipartCommitUploadPartResponse response = this.handleError(this.submitRequest(omRequest)).getCommitMultiPartUploadResponse();
        OmMultipartCommitUploadPartInfo info2 = new OmMultipartCommitUploadPartInfo(response.getPartName(), response.getETag());
        return info2;
    }

    @Override
    public OmMultipartUploadCompleteInfo completeMultipartUpload(OmKeyArgs omKeyArgs, OmMultipartUploadCompleteList multipartUploadList) throws IOException {
        OzoneManagerProtocolProtos.MultipartUploadCompleteRequest.Builder multipartUploadCompleteRequest = OzoneManagerProtocolProtos.MultipartUploadCompleteRequest.newBuilder();
        OzoneManagerProtocolProtos.KeyArgs.Builder keyArgs = OzoneManagerProtocolProtos.KeyArgs.newBuilder().setVolumeName(omKeyArgs.getVolumeName()).setBucketName(omKeyArgs.getBucketName()).setKeyName(omKeyArgs.getKeyName()).setOwnerName(omKeyArgs.getOwner()).setMultipartUploadID(omKeyArgs.getMultipartUploadID());
        if (omKeyArgs.getAcls() != null) {
            keyArgs.addAllAcls((Iterable)omKeyArgs.getAcls().stream().map(a -> OzoneAcl.toProtobuf(a)).collect(Collectors.toList()));
        }
        multipartUploadCompleteRequest.setKeyArgs(keyArgs.build());
        multipartUploadCompleteRequest.addAllPartsList(multipartUploadList.getPartsList());
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.CompleteMultiPartUpload).setCompleteMultiPartUploadRequest(multipartUploadCompleteRequest.build()).build();
        OzoneManagerProtocolProtos.MultipartUploadCompleteResponse response = this.handleError(this.submitRequest(omRequest)).getCompleteMultiPartUploadResponse();
        OmMultipartUploadCompleteInfo info = new OmMultipartUploadCompleteInfo(response.getVolume(), response.getBucket(), response.getKey(), response.getHash());
        return info;
    }

    @Override
    public void abortMultipartUpload(OmKeyArgs omKeyArgs) throws IOException {
        OzoneManagerProtocolProtos.KeyArgs.Builder keyArgs = OzoneManagerProtocolProtos.KeyArgs.newBuilder().setVolumeName(omKeyArgs.getVolumeName()).setBucketName(omKeyArgs.getBucketName()).setKeyName(omKeyArgs.getKeyName()).setMultipartUploadID(omKeyArgs.getMultipartUploadID());
        OzoneManagerProtocolProtos.MultipartUploadAbortRequest.Builder multipartUploadAbortRequest = OzoneManagerProtocolProtos.MultipartUploadAbortRequest.newBuilder();
        multipartUploadAbortRequest.setKeyArgs(keyArgs);
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.AbortMultiPartUpload).setAbortMultiPartUploadRequest(multipartUploadAbortRequest.build()).build();
        this.handleError(this.submitRequest(omRequest));
    }

    @Override
    public OmMultipartUploadListParts listParts(String volumeName, String bucketName, String keyName, String uploadID, int partNumberMarker, int maxParts) throws IOException {
        OzoneManagerProtocolProtos.MultipartUploadListPartsRequest.Builder multipartUploadListPartsRequest = OzoneManagerProtocolProtos.MultipartUploadListPartsRequest.newBuilder();
        multipartUploadListPartsRequest.setVolume(volumeName).setBucket(bucketName).setKey(keyName).setUploadID(uploadID).setPartNumbermarker(partNumberMarker).setMaxParts(maxParts);
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.ListMultiPartUploadParts).setListMultipartUploadPartsRequest(multipartUploadListPartsRequest.build()).build();
        OzoneManagerProtocolProtos.MultipartUploadListPartsResponse response = this.handleError(this.submitRequest(omRequest)).getListMultipartUploadPartsResponse();
        OmMultipartUploadListParts omMultipartUploadListParts = new OmMultipartUploadListParts(ReplicationConfig.fromProto((HddsProtos.ReplicationType)response.getType(), (HddsProtos.ReplicationFactor)response.getFactor(), (HddsProtos.ECReplicationConfig)response.getEcReplicationConfig()), response.getNextPartNumberMarker(), response.getIsTruncated());
        omMultipartUploadListParts.addProtoPartList(response.getPartsListList());
        return omMultipartUploadListParts;
    }

    @Override
    public OmMultipartUploadList listMultipartUploads(String volumeName, String bucketName, String prefix, String keyMarker, String uploadIdMarker, int maxUploads, boolean withPagination) throws IOException {
        OzoneManagerProtocolProtos.ListMultipartUploadsRequest request = OzoneManagerProtocolProtos.ListMultipartUploadsRequest.newBuilder().setVolume(volumeName).setBucket(bucketName).setPrefix(prefix == null ? "" : prefix).setKeyMarker(keyMarker == null ? "" : keyMarker).setUploadIdMarker(uploadIdMarker == null ? "" : uploadIdMarker).setMaxUploads(maxUploads).setWithPagination(withPagination).build();
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.ListMultipartUploads).setListMultipartUploadsRequest(request).build();
        OzoneManagerProtocolProtos.ListMultipartUploadsResponse listMultipartUploadsResponse = this.handleError(this.submitRequest(omRequest)).getListMultipartUploadsResponse();
        List<OmMultipartUpload> uploadList = listMultipartUploadsResponse.getUploadsListList().stream().map(proto -> new OmMultipartUpload(proto.getVolumeName(), proto.getBucketName(), proto.getKeyName(), proto.getUploadId(), Instant.ofEpochMilli(proto.getCreationTime()), ReplicationConfig.fromProto((HddsProtos.ReplicationType)proto.getType(), (HddsProtos.ReplicationFactor)proto.getFactor(), (HddsProtos.ECReplicationConfig)proto.getEcReplicationConfig()))).collect(Collectors.toList());
        OmMultipartUploadList response = OmMultipartUploadList.newBuilder().setUploads(uploadList).setNextKeyMarker(listMultipartUploadsResponse.getNextKeyMarker()).setNextUploadIdMarker(listMultipartUploadsResponse.getNextUploadIdMarker()).setIsTruncated(listMultipartUploadsResponse.getIsTruncated()).build();
        return response;
    }

    @Override
    public List<ServiceInfo> getServiceList() throws IOException {
        OzoneManagerProtocolProtos.ServiceListRequest req = OzoneManagerProtocolProtos.ServiceListRequest.newBuilder().build();
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.ServiceList).setServiceListRequest(req).build();
        OzoneManagerProtocolProtos.ServiceListResponse resp = this.handleError(this.submitRequest(omRequest)).getServiceListResponse();
        return resp.getServiceInfoList().stream().map(ServiceInfo::getFromProtobuf).collect(Collectors.toList());
    }

    @Override
    public ServiceInfoEx getServiceInfo() throws IOException {
        OzoneManagerProtocolProtos.ServiceListRequest req = OzoneManagerProtocolProtos.ServiceListRequest.newBuilder().build();
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.ServiceList).setServiceListRequest(req).build();
        OzoneManagerProtocolProtos.ServiceListResponse resp = this.handleError(this.submitRequest(omRequest)).getServiceListResponse();
        return new ServiceInfoEx(resp.getServiceInfoList().stream().map(ServiceInfo::getFromProtobuf).collect(Collectors.toList()), resp.getCaCertificate(), resp.getCaCertsList());
    }

    @Override
    public ListOpenFilesResult listOpenFiles(String path, int maxKeys, String contToken) throws IOException {
        OzoneManagerProtocolProtos.ListOpenFilesRequest req = OzoneManagerProtocolProtos.ListOpenFilesRequest.newBuilder().setPath(path).setCount(maxKeys).setToken(contToken).build();
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.ListOpenFiles).setListOpenFilesRequest(req).build();
        OzoneManagerProtocolProtos.ListOpenFilesResponse resp = this.handleError(this.submitRequest(omRequest)).getListOpenFilesResponse();
        return new ListOpenFilesResult(resp.getTotalOpenKeyCount(), resp.getHasMore(), resp.hasContinuationToken() ? resp.getContinuationToken() : null, resp.getClientIDList(), resp.getKeyInfoList());
    }

    @Override
    public void transferLeadership(String newLeaderId) throws IOException {
        HddsProtos.TransferLeadershipRequestProto.Builder builder = HddsProtos.TransferLeadershipRequestProto.newBuilder();
        builder.setNewLeaderId(newLeaderId);
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.TransferLeadership).setTransferOmLeadershipRequest(builder.build()).build();
        this.handleError(this.submitRequest(omRequest));
    }

    @Override
    public boolean triggerRangerBGSync(boolean noWait) throws IOException {
        OzoneManagerProtocolProtos.RangerBGSyncRequest req = OzoneManagerProtocolProtos.RangerBGSyncRequest.newBuilder().setNoWait(noWait).build();
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.RangerBGSync).setRangerBGSyncRequest(req).build();
        OzoneManagerProtocolProtos.RangerBGSyncResponse resp = this.handleError(this.submitRequest(omRequest)).getRangerBGSyncResponse();
        return resp.getRunSuccess();
    }

    @Override
    public UpgradeFinalization.StatusAndMessages finalizeUpgrade(String upgradeClientID) throws IOException {
        OzoneManagerProtocolProtos.FinalizeUpgradeRequest req = OzoneManagerProtocolProtos.FinalizeUpgradeRequest.newBuilder().setUpgradeClientId(upgradeClientID).build();
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.FinalizeUpgrade).setFinalizeUpgradeRequest(req).build();
        OzoneManagerProtocolProtos.FinalizeUpgradeResponse response = this.handleError(this.submitRequest(omRequest)).getFinalizeUpgradeResponse();
        HddsProtos.UpgradeFinalizationStatus status = response.getStatus();
        return new UpgradeFinalization.StatusAndMessages(UpgradeFinalization.Status.valueOf((String)status.getStatus().name()), (Collection)status.getMessagesList());
    }

    @Override
    public UpgradeFinalization.StatusAndMessages queryUpgradeFinalizationProgress(String upgradeClientID, boolean takeover, boolean readonly) throws IOException {
        OzoneManagerProtocolProtos.FinalizeUpgradeProgressRequest req = OzoneManagerProtocolProtos.FinalizeUpgradeProgressRequest.newBuilder().setUpgradeClientId(upgradeClientID).setTakeover(takeover).setReadonly(readonly).build();
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.FinalizeUpgradeProgress).setFinalizeUpgradeProgressRequest(req).build();
        OzoneManagerProtocolProtos.FinalizeUpgradeProgressResponse response = this.handleError(this.submitRequest(omRequest)).getFinalizeUpgradeProgressResponse();
        HddsProtos.UpgradeFinalizationStatus status = response.getStatus();
        return new UpgradeFinalization.StatusAndMessages(UpgradeFinalization.Status.valueOf((String)status.getStatus().name()), (Collection)status.getMessagesList());
    }

    @Override
    public Token<OzoneTokenIdentifier> getDelegationToken(Text renewer) throws OMException {
        SecurityProtos.GetDelegationTokenRequestProto req = SecurityProtos.GetDelegationTokenRequestProto.newBuilder().setRenewer(renewer == null ? "" : renewer.toString()).build();
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.GetDelegationToken).setGetDelegationTokenRequest(req).build();
        try {
            OzoneManagerProtocolProtos.GetDelegationTokenResponseProto resp = this.handleError(this.submitRequest(omRequest)).getGetDelegationTokenResponse();
            return resp.getResponse().hasToken() ? OMPBHelper.tokenFromProto(resp.getResponse().getToken()) : null;
        }
        catch (IOException e) {
            if (e instanceof OMException) {
                throw (OMException)e;
            }
            throw new OMException("Get delegation token failed.", e, OMException.ResultCodes.TOKEN_ERROR_OTHER);
        }
    }

    @Override
    public long renewDelegationToken(Token<OzoneTokenIdentifier> token) throws OMException {
        SecurityProtos.RenewDelegationTokenRequestProto req = SecurityProtos.RenewDelegationTokenRequestProto.newBuilder().setToken(OMPBHelper.protoFromToken(token)).build();
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.RenewDelegationToken).setRenewDelegationTokenRequest(req).build();
        try {
            OzoneManagerProtocolProtos.RenewDelegationTokenResponseProto resp = this.handleError(this.submitRequest(omRequest)).getRenewDelegationTokenResponse();
            return resp.getResponse().getNewExpiryTime();
        }
        catch (IOException e) {
            if (e instanceof OMException) {
                throw (OMException)e;
            }
            throw new OMException("Renew delegation token failed.", e, OMException.ResultCodes.TOKEN_ERROR_OTHER);
        }
    }

    @Override
    public void cancelDelegationToken(Token<OzoneTokenIdentifier> token) throws OMException {
        SecurityProtos.CancelDelegationTokenRequestProto req = SecurityProtos.CancelDelegationTokenRequestProto.newBuilder().setToken(OMPBHelper.protoFromToken(token)).build();
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.CancelDelegationToken).setCancelDelegationTokenRequest(req).build();
        try {
            this.handleError(this.submitRequest(omRequest));
        }
        catch (IOException e) {
            if (e instanceof OMException) {
                throw (OMException)e;
            }
            throw new OMException("Cancel delegation token failed.", e, OMException.ResultCodes.TOKEN_ERROR_OTHER);
        }
    }

    @Override
    public void setThreadLocalS3Auth(S3Auth s3Auth) {
        this.threadLocalS3Auth.set(s3Auth);
    }

    @Override
    public void clearThreadLocalS3Auth() {
        this.threadLocalS3Auth.remove();
    }

    @Override
    public ThreadLocal<S3Auth> getS3CredentialsProvider() {
        return this.threadLocalS3Auth;
    }

    @Override
    public S3Auth getThreadLocalS3Auth() {
        return this.threadLocalS3Auth.get();
    }

    @Override
    public OzoneFileStatus getFileStatus(OmKeyArgs args) throws IOException {
        OzoneManagerProtocolProtos.KeyArgs keyArgs = OzoneManagerProtocolProtos.KeyArgs.newBuilder().setVolumeName(args.getVolumeName()).setBucketName(args.getBucketName()).setKeyName(args.getKeyName()).setSortDatanodes(args.getSortDatanodes()).setLatestVersionLocation(args.getLatestVersionLocation()).build();
        OzoneManagerProtocolProtos.GetFileStatusRequest req = OzoneManagerProtocolProtos.GetFileStatusRequest.newBuilder().setKeyArgs(keyArgs).build();
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.GetFileStatus).setGetFileStatusRequest(req).build();
        OzoneManagerProtocolProtos.GetFileStatusResponse resp = this.handleError(this.submitRequest(omRequest)).getGetFileStatusResponse();
        return OzoneFileStatus.getFromProtobuf(resp.getStatus());
    }

    @Override
    public void createDirectory(OmKeyArgs args) throws IOException {
        OzoneManagerProtocolProtos.KeyArgs.Builder keyArgsBuilder = OzoneManagerProtocolProtos.KeyArgs.newBuilder().setVolumeName(args.getVolumeName()).setBucketName(args.getBucketName()).setKeyName(args.getKeyName()).setOwnerName(args.getOwner());
        if (args.getAcls() != null) {
            keyArgsBuilder.addAllAcls((Iterable)args.getAcls().stream().map(a -> OzoneAcl.toProtobuf(a)).collect(Collectors.toList()));
        }
        OzoneManagerProtocolProtos.CreateDirectoryRequest request = OzoneManagerProtocolProtos.CreateDirectoryRequest.newBuilder().setKeyArgs(keyArgsBuilder.build()).build();
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.CreateDirectory).setCreateDirectoryRequest(request).build();
        OzoneManagerProtocolProtos.OMResponse omResponse = this.submitRequest(omRequest);
        if (!omResponse.getStatus().equals((Object)OzoneManagerProtocolProtos.Status.DIRECTORY_ALREADY_EXISTS)) {
            this.handleError(omResponse);
        }
    }

    @Override
    public OmKeyInfo lookupFile(OmKeyArgs args) throws IOException {
        OzoneManagerProtocolProtos.KeyArgs keyArgs = OzoneManagerProtocolProtos.KeyArgs.newBuilder().setVolumeName(args.getVolumeName()).setBucketName(args.getBucketName()).setKeyName(args.getKeyName()).setSortDatanodes(args.getSortDatanodes()).setLatestVersionLocation(args.getLatestVersionLocation()).build();
        OzoneManagerProtocolProtos.LookupFileRequest lookupFileRequest = OzoneManagerProtocolProtos.LookupFileRequest.newBuilder().setKeyArgs(keyArgs).build();
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.LookupFile).setLookupFileRequest(lookupFileRequest).build();
        OzoneManagerProtocolProtos.LookupFileResponse resp = this.handleError(this.submitRequest(omRequest)).getLookupFileResponse();
        return OmKeyInfo.getFromProtobuf(resp.getKeyInfo());
    }

    @Override
    public boolean addAcl(OzoneObj obj, OzoneAcl acl) throws IOException {
        OzoneManagerProtocolProtos.AddAclRequest req = OzoneManagerProtocolProtos.AddAclRequest.newBuilder().setObj(OzoneObj.toProtobuf(obj)).setAcl(OzoneAcl.toProtobuf(acl)).build();
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.AddAcl).setAddAclRequest(req).build();
        OzoneManagerProtocolProtos.AddAclResponse addAclResponse = this.handleError(this.submitRequest(omRequest)).getAddAclResponse();
        return addAclResponse.getResponse();
    }

    @Override
    public boolean removeAcl(OzoneObj obj, OzoneAcl acl) throws IOException {
        OzoneManagerProtocolProtos.RemoveAclRequest req = OzoneManagerProtocolProtos.RemoveAclRequest.newBuilder().setObj(OzoneObj.toProtobuf(obj)).setAcl(OzoneAcl.toProtobuf(acl)).build();
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.RemoveAcl).setRemoveAclRequest(req).build();
        OzoneManagerProtocolProtos.RemoveAclResponse response = this.handleError(this.submitRequest(omRequest)).getRemoveAclResponse();
        return response.getResponse();
    }

    @Override
    public boolean setAcl(OzoneObj obj, List<OzoneAcl> acls) throws IOException {
        OzoneManagerProtocolProtos.SetAclRequest.Builder builder = OzoneManagerProtocolProtos.SetAclRequest.newBuilder().setObj(OzoneObj.toProtobuf(obj));
        acls.forEach(a -> builder.addAcl(OzoneAcl.toProtobuf(a)));
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.SetAcl).setSetAclRequest(builder.build()).build();
        OzoneManagerProtocolProtos.SetAclResponse response = this.handleError(this.submitRequest(omRequest)).getSetAclResponse();
        return response.getResponse();
    }

    @Override
    public List<OzoneAcl> getAcl(OzoneObj obj) throws IOException {
        OzoneManagerProtocolProtos.GetAclRequest req = OzoneManagerProtocolProtos.GetAclRequest.newBuilder().setObj(OzoneObj.toProtobuf(obj)).build();
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.GetAcl).setGetAclRequest(req).build();
        OzoneManagerProtocolProtos.GetAclResponse response = this.handleError(this.submitRequest(omRequest)).getGetAclResponse();
        ArrayList<OzoneAcl> acls = new ArrayList<OzoneAcl>();
        response.getAclsList().stream().forEach(a -> acls.add(OzoneAcl.fromProtobuf(a)));
        return acls;
    }

    @Override
    public DBUpdates getDBUpdates(OzoneManagerProtocolProtos.DBUpdatesRequest dbUpdatesRequest) throws IOException {
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.DBUpdates).setDbUpdatesRequest(dbUpdatesRequest).build();
        OzoneManagerProtocolProtos.DBUpdatesResponse dbUpdatesResponse = this.handleError(this.submitRequest(omRequest)).getDbUpdatesResponse();
        DBUpdates dbUpdatesWrapper = new DBUpdates();
        for (ByteString byteString : dbUpdatesResponse.getDataList()) {
            dbUpdatesWrapper.addWriteBatch(byteString.toByteArray(), 0L);
        }
        dbUpdatesWrapper.setCurrentSequenceNumber(dbUpdatesResponse.getSequenceNumber());
        dbUpdatesWrapper.setLatestSequenceNumber(dbUpdatesResponse.getLatestSequenceNumber());
        dbUpdatesWrapper.setDBUpdateSuccess(dbUpdatesResponse.getDbUpdateSuccess());
        return dbUpdatesWrapper;
    }

    @Override
    public OpenKeySession createFile(OmKeyArgs args, boolean overWrite, boolean recursive) throws IOException {
        OzoneManagerProtocolProtos.KeyArgs.Builder keyArgsBuilder = OzoneManagerProtocolProtos.KeyArgs.newBuilder().setVolumeName(args.getVolumeName()).setBucketName(args.getBucketName()).setKeyName(args.getKeyName()).setDataSize(args.getDataSize()).setOwnerName(args.getOwner());
        if (args.getAcls() != null) {
            keyArgsBuilder.addAllAcls((Iterable)args.getAcls().stream().map(a -> OzoneAcl.toProtobuf(a)).collect(Collectors.toList()));
        }
        if (args.getReplicationConfig() != null) {
            if (args.getReplicationConfig() instanceof ECReplicationConfig) {
                keyArgsBuilder.setEcReplicationConfig(((ECReplicationConfig)args.getReplicationConfig()).toProto());
            } else {
                keyArgsBuilder.setFactor(ReplicationConfig.getLegacyFactor((ReplicationConfig)args.getReplicationConfig()));
            }
            keyArgsBuilder.setType(args.getReplicationConfig().getReplicationType());
        }
        OzoneManagerProtocolProtos.CreateFileRequest createFileRequest = OzoneManagerProtocolProtos.CreateFileRequest.newBuilder().setKeyArgs(keyArgsBuilder.build()).setIsOverwrite(overWrite).setIsRecursive(recursive).build();
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.CreateFile).setCreateFileRequest(createFileRequest).build();
        OzoneManagerProtocolProtos.CreateFileResponse resp = this.handleSubmitRequestAndSCMSafeModeRetry(omRequest).getCreateFileResponse();
        return new OpenKeySession(resp.getID(), OmKeyInfo.getFromProtobuf(resp.getKeyInfo()), resp.getOpenVersion());
    }

    @Nonnull
    private OzoneManagerProtocolProtos.OMResponse handleSubmitRequestAndSCMSafeModeRetry(OzoneManagerProtocolProtos.OMRequest omRequest) throws IOException {
        int retryCount = 90;
        while (true) {
            try {
                return this.handleError(this.submitRequest(omRequest));
            }
            catch (OMException e) {
                if (e.getResult().equals((Object)OMException.ResultCodes.SCM_IN_SAFE_MODE) && retryCount > 0) {
                    System.err.println("SCM is in safe mode. Will retry in 1000ms");
                    --retryCount;
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ex) {
                        throw new OMException(ex.getMessage(), OMException.ResultCodes.SCM_IN_SAFE_MODE);
                    }
                    continue;
                }
                if (e.getResult().equals((Object)OMException.ResultCodes.SCM_IN_SAFE_MODE) && retryCount == 0) {
                    throw new OMException(e.getMessage(), OMException.ResultCodes.SCM_IN_SAFE_MODE);
                }
                throw e;
            }
            break;
        }
    }

    @Override
    public List<OzoneFileStatus> listStatus(OmKeyArgs args, boolean recursive, String startKey, long numEntries, boolean allowPartialPrefixes) throws IOException {
        OzoneManagerProtocolProtos.KeyArgs keyArgs = OzoneManagerProtocolProtos.KeyArgs.newBuilder().setVolumeName(args.getVolumeName()).setBucketName(args.getBucketName()).setKeyName(args.getKeyName()).setSortDatanodes(args.getSortDatanodes()).setLatestVersionLocation(args.getLatestVersionLocation()).build();
        OzoneManagerProtocolProtos.ListStatusRequest.Builder listStatusRequestBuilder = this.createListStatusRequestBuilder(keyArgs, recursive, startKey, numEntries, allowPartialPrefixes);
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.ListStatus).setListStatusRequest(listStatusRequestBuilder.build()).build();
        OzoneManagerProtocolProtos.ListStatusResponse listStatusResponse = this.handleError(this.submitRequest(omRequest)).getListStatusResponse();
        ArrayList<OzoneFileStatus> statusList = new ArrayList<OzoneFileStatus>(listStatusResponse.getStatusesCount());
        for (OzoneManagerProtocolProtos.OzoneFileStatusProto fileStatus : listStatusResponse.getStatusesList()) {
            statusList.add(OzoneFileStatus.getFromProtobuf(fileStatus));
        }
        return statusList;
    }

    @Override
    public List<OzoneFileStatusLight> listStatusLight(OmKeyArgs args, boolean recursive, String startKey, long numEntries, boolean allowPartialPrefixes) throws IOException {
        OzoneManagerProtocolProtos.KeyArgs keyArgs = OzoneManagerProtocolProtos.KeyArgs.newBuilder().setVolumeName(args.getVolumeName()).setBucketName(args.getBucketName()).setKeyName(args.getKeyName()).setSortDatanodes(false).setLatestVersionLocation(true).build();
        OzoneManagerProtocolProtos.ListStatusRequest.Builder listStatusRequestBuilder = this.createListStatusRequestBuilder(keyArgs, recursive, startKey, numEntries, allowPartialPrefixes);
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.ListStatusLight).setListStatusRequest(listStatusRequestBuilder.build()).build();
        OzoneManagerProtocolProtos.ListStatusLightResponse listStatusLightResponse = this.handleError(this.submitRequest(omRequest)).getListStatusLightResponse();
        ArrayList<OzoneFileStatusLight> statusList = new ArrayList<OzoneFileStatusLight>(listStatusLightResponse.getStatusesCount());
        for (OzoneManagerProtocolProtos.OzoneFileStatusProtoLight fileStatus : listStatusLightResponse.getStatusesList()) {
            statusList.add(OzoneFileStatusLight.getFromProtobuf(fileStatus));
        }
        return statusList;
    }

    private OzoneManagerProtocolProtos.ListStatusRequest.Builder createListStatusRequestBuilder(OzoneManagerProtocolProtos.KeyArgs keyArgs, boolean recursive, String startKey, long numEntries, boolean allowPartialPrefixes) {
        OzoneManagerProtocolProtos.ListStatusRequest.Builder listStatusRequestBuilder = OzoneManagerProtocolProtos.ListStatusRequest.newBuilder().setKeyArgs(keyArgs).setRecursive(recursive).setNumEntries(numEntries);
        if (startKey != null) {
            listStatusRequestBuilder.setStartKey(startKey);
        } else {
            listStatusRequestBuilder.setStartKey("");
        }
        if (allowPartialPrefixes) {
            listStatusRequestBuilder.setAllowPartialPrefix(allowPartialPrefixes);
        }
        return listStatusRequestBuilder;
    }

    @Override
    public List<OzoneFileStatus> listStatus(OmKeyArgs args, boolean recursive, String startKey, long numEntries) throws IOException {
        return this.listStatus(args, recursive, startKey, numEntries, false);
    }

    @Override
    public long prepareOzoneManager(long txnApplyWaitTimeoutSeconds, long txnApplyCheckIntervalSeconds) throws IOException {
        Preconditions.checkArgument((txnApplyWaitTimeoutSeconds > 0L ? 1 : 0) != 0, (Object)"txnApplyWaitTimeoutSeconds has to be > zero");
        Preconditions.checkArgument((txnApplyCheckIntervalSeconds > 0L && txnApplyCheckIntervalSeconds < txnApplyWaitTimeoutSeconds / 2L ? 1 : 0) != 0, (Object)"txnApplyCheckIntervalSeconds has to be > zero and < half of txnApplyWaitTimeoutSeconds to make sense.");
        OzoneManagerProtocolProtos.PrepareRequest prepareRequest = OzoneManagerProtocolProtos.PrepareRequest.newBuilder().setArgs(OzoneManagerProtocolProtos.PrepareRequestArgs.newBuilder().setTxnApplyWaitTimeoutSeconds(txnApplyWaitTimeoutSeconds).setTxnApplyCheckIntervalSeconds(txnApplyCheckIntervalSeconds).build()).build();
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.Prepare).setPrepareRequest(prepareRequest).build();
        OzoneManagerProtocolProtos.PrepareResponse prepareResponse = this.handleError(this.submitRequest(omRequest)).getPrepareResponse();
        return prepareResponse.getTxnID();
    }

    @Override
    public OzoneManagerProtocolProtos.PrepareStatusResponse getOzoneManagerPrepareStatus(long txnId) throws IOException {
        OzoneManagerProtocolProtos.PrepareStatusRequest prepareStatusRequest = OzoneManagerProtocolProtos.PrepareStatusRequest.newBuilder().setTxnID(txnId).build();
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.PrepareStatus).setPrepareStatusRequest(prepareStatusRequest).build();
        OzoneManagerProtocolProtos.PrepareStatusResponse prepareStatusResponse = this.handleError(this.submitRequest(omRequest)).getPrepareStatusResponse();
        return prepareStatusResponse;
    }

    @Override
    public OzoneManagerProtocolProtos.CancelPrepareResponse cancelOzoneManagerPrepare() throws IOException {
        OzoneManagerProtocolProtos.CancelPrepareRequest cancelPrepareRequest = OzoneManagerProtocolProtos.CancelPrepareRequest.newBuilder().build();
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.CancelPrepare).setCancelPrepareRequest(cancelPrepareRequest).build();
        return this.handleError(this.submitRequest(omRequest)).getCancelPrepareResponse();
    }

    @Override
    public OzoneManagerProtocolProtos.EchoRPCResponse echoRPCReq(byte[] payloadReq, int payloadSizeRespBytes, boolean writeToRatis) throws IOException {
        OzoneManagerProtocolProtos.EchoRPCRequest echoRPCRequest = OzoneManagerProtocolProtos.EchoRPCRequest.newBuilder().setPayloadReq(Proto2Utils.unsafeByteString((byte[])payloadReq)).setPayloadSizeResp(payloadSizeRespBytes).setReadOnly(!writeToRatis).build();
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.EchoRPC).setEchoRPCRequest(echoRPCRequest).build();
        OzoneManagerProtocolProtos.EchoRPCResponse echoRPCResponse = this.handleError(this.submitRequest(omRequest)).getEchoRPCResponse();
        return echoRPCResponse;
    }

    @Override
    public LeaseKeyInfo recoverLease(String volumeName, String bucketName, String keyName, boolean force) throws IOException {
        OzoneManagerProtocolProtos.RecoverLeaseRequest recoverLeaseRequest = OzoneManagerProtocolProtos.RecoverLeaseRequest.newBuilder().setVolumeName(volumeName).setBucketName(bucketName).setKeyName(keyName).setForce(force).build();
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.RecoverLease).setRecoverLeaseRequest(recoverLeaseRequest).build();
        OzoneManagerProtocolProtos.RecoverLeaseResponse recoverLeaseResponse = this.handleError(this.submitRequest(omRequest)).getRecoverLeaseResponse();
        return new LeaseKeyInfo(OmKeyInfo.getFromProtobuf(recoverLeaseResponse.getKeyInfo()), OmKeyInfo.getFromProtobuf(recoverLeaseResponse.getOpenKeyInfo()));
    }

    @Override
    public void setTimes(OmKeyArgs args, long mtime, long atime) throws IOException {
        OzoneManagerProtocolProtos.KeyArgs keyArgs = OzoneManagerProtocolProtos.KeyArgs.newBuilder().setVolumeName(args.getVolumeName()).setBucketName(args.getBucketName()).setKeyName(args.getKeyName()).build();
        OzoneManagerProtocolProtos.SetTimesRequest setTimesRequest = OzoneManagerProtocolProtos.SetTimesRequest.newBuilder().setKeyArgs(keyArgs).setMtime(mtime).setAtime(atime).build();
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.SetTimes).setSetTimesRequest(setTimesRequest).build();
        this.handleError(this.submitRequest(omRequest));
    }

    @Override
    public boolean setSafeMode(SafeModeAction action, boolean isChecked) throws IOException {
        OzoneManagerProtocolProtos.SetSafeModeRequest setSafeModeRequest = OzoneManagerProtocolProtos.SetSafeModeRequest.newBuilder().setSafeMode(this.toProtoBuf(action)).build();
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.SetSafeMode).setSetSafeModeRequest(setSafeModeRequest).build();
        OzoneManagerProtocolProtos.SetSafeModeResponse setSafeModeResponse = this.handleError(this.submitRequest(omRequest)).getSetSafeModeResponse();
        return setSafeModeResponse.getResponse();
    }

    @Override
    public String getQuotaRepairStatus() throws IOException {
        OzoneManagerProtocolProtos.GetQuotaRepairStatusRequest quotaRepairStatusRequest = OzoneManagerProtocolProtos.GetQuotaRepairStatusRequest.newBuilder().build();
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.GetQuotaRepairStatus).setGetQuotaRepairStatusRequest(quotaRepairStatusRequest).build();
        OzoneManagerProtocolProtos.GetQuotaRepairStatusResponse quotaRepairStatusResponse = this.handleError(this.submitRequest(omRequest)).getGetQuotaRepairStatusResponse();
        return quotaRepairStatusResponse.getStatus();
    }

    @Override
    public void startQuotaRepair(List<String> buckets) throws IOException {
        OzoneManagerProtocolProtos.StartQuotaRepairRequest startQuotaRepairRequest = OzoneManagerProtocolProtos.StartQuotaRepairRequest.newBuilder().build();
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.StartQuotaRepair).setStartQuotaRepairRequest(startQuotaRepairRequest).build();
        this.handleError(this.submitRequest(omRequest));
    }

    @Override
    public Map<String, String> getObjectTagging(OmKeyArgs args) throws IOException {
        OzoneManagerProtocolProtos.KeyArgs keyArgs = OzoneManagerProtocolProtos.KeyArgs.newBuilder().setVolumeName(args.getVolumeName()).setBucketName(args.getBucketName()).setKeyName(args.getKeyName()).build();
        OzoneManagerProtocolProtos.GetObjectTaggingRequest req = OzoneManagerProtocolProtos.GetObjectTaggingRequest.newBuilder().setKeyArgs(keyArgs).build();
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.GetObjectTagging).setGetObjectTaggingRequest(req).build();
        OzoneManagerProtocolProtos.GetObjectTaggingResponse resp = this.handleError(this.submitRequest(omRequest)).getGetObjectTaggingResponse();
        return KeyValueUtil.getFromProtobuf(resp.getTagsList());
    }

    @Override
    public void putObjectTagging(OmKeyArgs args) throws IOException {
        OzoneManagerProtocolProtos.KeyArgs keyArgs = OzoneManagerProtocolProtos.KeyArgs.newBuilder().setVolumeName(args.getVolumeName()).setBucketName(args.getBucketName()).setKeyName(args.getKeyName()).addAllTags(KeyValueUtil.toProtobuf(args.getTags())).build();
        OzoneManagerProtocolProtos.PutObjectTaggingRequest req = OzoneManagerProtocolProtos.PutObjectTaggingRequest.newBuilder().setKeyArgs(keyArgs).build();
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.PutObjectTagging).setPutObjectTaggingRequest(req).build();
        OzoneManagerProtocolProtos.OMResponse omResponse = this.submitRequest(omRequest);
        this.handleError(omResponse);
    }

    @Override
    public void deleteObjectTagging(OmKeyArgs args) throws IOException {
        OzoneManagerProtocolProtos.KeyArgs keyArgs = OzoneManagerProtocolProtos.KeyArgs.newBuilder().setVolumeName(args.getVolumeName()).setBucketName(args.getBucketName()).setKeyName(args.getKeyName()).build();
        OzoneManagerProtocolProtos.DeleteObjectTaggingRequest req = OzoneManagerProtocolProtos.DeleteObjectTaggingRequest.newBuilder().setKeyArgs(keyArgs).build();
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.DeleteObjectTagging).setDeleteObjectTaggingRequest(req).build();
        OzoneManagerProtocolProtos.OMResponse omResponse = this.submitRequest(omRequest);
        this.handleError(omResponse);
    }

    private OzoneManagerProtocolProtos.SafeMode toProtoBuf(SafeModeAction action) {
        switch (action) {
            case ENTER: {
                return OzoneManagerProtocolProtos.SafeMode.ENTER;
            }
            case LEAVE: {
                return OzoneManagerProtocolProtos.SafeMode.LEAVE;
            }
            case FORCE_EXIT: {
                return OzoneManagerProtocolProtos.SafeMode.FORCE_EXIT;
            }
            case GET: {
                return OzoneManagerProtocolProtos.SafeMode.GET;
            }
        }
        throw new IllegalArgumentException("Unsupported safe mode action " + action);
    }

    @VisibleForTesting
    public OmTransport getTransport() {
        return this.transport;
    }

    public boolean isS3AuthCheck() {
        return this.s3AuthCheck;
    }

    public void setS3AuthCheck(boolean s3AuthCheck) {
        this.s3AuthCheck = s3AuthCheck;
    }
}

