/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.client.checksum;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.client.StandaloneReplicationConfig;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.OzoneClientConfig;
import org.apache.hadoop.hdds.scm.XceiverClientSpi;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.storage.ContainerProtocolCalls;
import org.apache.hadoop.ozone.client.OzoneBucket;
import org.apache.hadoop.ozone.client.OzoneVolume;
import org.apache.hadoop.ozone.client.checksum.AbstractBlockChecksumComputer;
import org.apache.hadoop.ozone.client.checksum.BaseFileChecksumHelper;
import org.apache.hadoop.ozone.client.checksum.ReplicatedBlockChecksumComputer;
import org.apache.hadoop.ozone.client.protocol.ClientProtocol;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.security.token.Token;

public class ReplicatedFileChecksumHelper
extends BaseFileChecksumHelper {
    public ReplicatedFileChecksumHelper(OzoneVolume volume, OzoneBucket bucket, String keyName, long length, OzoneClientConfig.ChecksumCombineMode checksumCombineMode, ClientProtocol rpcClient) throws IOException {
        super(volume, bucket, keyName, length, checksumCombineMode, rpcClient);
    }

    public ReplicatedFileChecksumHelper(OzoneVolume volume, OzoneBucket bucket, String keyName, long length, OzoneClientConfig.ChecksumCombineMode checksumCombineMode, ClientProtocol rpcClient, OmKeyInfo keyInfo) throws IOException {
        super(volume, bucket, keyName, length, checksumCombineMode, rpcClient, keyInfo);
    }

    @Override
    protected AbstractBlockChecksumComputer getBlockChecksumComputer(List<ContainerProtos.ChunkInfo> chunkInfos, long blockLength) {
        return new ReplicatedBlockChecksumComputer(chunkInfos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<ContainerProtos.ChunkInfo> getChunkInfos(OmKeyLocationInfo keyLocationInfo) throws IOException {
        List chunks;
        Token token = keyLocationInfo.getToken();
        Pipeline pipeline = keyLocationInfo.getPipeline();
        BlockID blockID = keyLocationInfo.getBlockID();
        if (pipeline.getType() != HddsProtos.ReplicationType.STAND_ALONE) {
            pipeline = Pipeline.newBuilder((Pipeline)pipeline).setReplicationConfig((ReplicationConfig)StandaloneReplicationConfig.getInstance((HddsProtos.ReplicationFactor)ReplicationConfig.getLegacyFactor((ReplicationConfig)pipeline.getReplicationConfig()))).build();
        }
        XceiverClientSpi xceiverClientSpi = null;
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Initializing BlockInputStream for get key to access {}", (Object)blockID.getContainerID());
            }
            xceiverClientSpi = this.getXceiverClientFactory().acquireClientForReadData(pipeline);
            ContainerProtos.GetBlockResponseProto response = ContainerProtocolCalls.getBlock((XceiverClientSpi)xceiverClientSpi, (BlockID)blockID, (Token)token, (Map)pipeline.getReplicaIndexes());
            chunks = response.getBlockData().getChunksList();
        }
        finally {
            if (xceiverClientSpi != null) {
                this.getXceiverClientFactory().releaseClientForReadData(xceiverClientSpi, false);
            }
        }
        return chunks;
    }
}

