/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shell.bucket;

import java.io.IOException;
import java.time.Instant;
import org.apache.hadoop.ozone.client.OzoneBucket;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.shell.OzoneAddress;
import org.apache.hadoop.ozone.shell.bucket.BucketHandler;
import picocli.CommandLine;

@CommandLine.Command(name="info", description={"returns information about a bucket"})
public class InfoBucketHandler
extends BucketHandler {
    @Override
    public void execute(OzoneClient client, OzoneAddress address) throws IOException {
        OzoneBucket bucket = client.getObjectStore().getVolume(address.getVolumeName()).getBucket(address.getBucketName());
        if (bucket.getSourceBucket() != null && bucket.getSourceVolume() != null) {
            this.printObjectAsJson(new LinkBucket(bucket));
        } else {
            this.printObjectAsJson(bucket);
        }
    }

    public static class LinkBucket {
        private String volumeName;
        private String name;
        private String sourceVolume;
        private String sourceBucket;
        private Instant creationTime;
        private Instant modificationTime;
        private String owner;
        private Boolean link;

        LinkBucket(OzoneBucket ozoneBucket) {
            this.volumeName = ozoneBucket.getVolumeName();
            this.name = ozoneBucket.getName();
            this.sourceVolume = ozoneBucket.getSourceVolume();
            this.sourceBucket = ozoneBucket.getSourceBucket();
            this.creationTime = ozoneBucket.getCreationTime();
            this.modificationTime = ozoneBucket.getModificationTime();
            this.owner = ozoneBucket.getOwner();
            this.link = ozoneBucket.isLink();
        }

        public String getVolumeName() {
            return this.volumeName;
        }

        public String getName() {
            return this.name;
        }

        public String getSourceVolume() {
            return this.sourceVolume;
        }

        public String getSourceBucket() {
            return this.sourceBucket;
        }

        public Instant getCreationTime() {
            return this.creationTime;
        }

        public Instant getModificationTime() {
            return this.modificationTime;
        }

        public String getOwner() {
            return this.owner;
        }

        public Boolean getLink() {
            return this.link;
        }
    }
}

