/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.safemode;

import org.apache.hadoop.hdds.scm.safemode.SCMSafeModeManager;
import org.apache.hadoop.hdds.scm.safemode.SafeModeMetrics;
import org.apache.hadoop.hdds.server.events.EventHandler;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.apache.hadoop.hdds.server.events.EventQueue;
import org.apache.hadoop.hdds.server.events.TypedEvent;

public abstract class SafeModeExitRule<T>
implements EventHandler<T> {
    private final SCMSafeModeManager safeModeManager;
    private final String ruleName;
    protected static final int SAMPLE_CONTAINER_DISPLAY_LIMIT = 5;
    protected static final int SAMPLE_PIPELINE_DISPLAY_LIMIT = 5;
    private boolean validateBasedOnReportProcessing = true;

    public SafeModeExitRule(SCMSafeModeManager safeModeManager, EventQueue eventQueue) {
        this.safeModeManager = safeModeManager;
        this.ruleName = this.getClass().getSimpleName();
        eventQueue.addHandler(this.getEventType(), (EventHandler)this);
    }

    public void setValidateBasedOnReportProcessing(boolean newValue) {
        this.validateBasedOnReportProcessing = newValue;
    }

    protected boolean validateBasedOnReportProcessing() {
        return this.validateBasedOnReportProcessing;
    }

    public String getRuleName() {
        return this.ruleName;
    }

    protected abstract TypedEvent<T> getEventType();

    protected abstract boolean validate();

    protected abstract void process(T var1);

    protected abstract void cleanup();

    public final void onMessage(T report, EventPublisher publisher) {
        if (this.scmInSafeMode()) {
            if (this.validate()) {
                this.safeModeManager.validateSafeModeExitRules(this.ruleName);
                this.cleanup();
                return;
            }
            this.process(report);
            if (this.validate()) {
                this.safeModeManager.validateSafeModeExitRules(this.ruleName);
                this.cleanup();
            }
        }
    }

    protected boolean scmInSafeMode() {
        return this.safeModeManager.getInSafeMode();
    }

    protected SafeModeMetrics getSafeModeMetrics() {
        return this.safeModeManager.getSafeModeMetrics();
    }

    abstract String getStatusText();

    protected abstract void refresh(boolean var1);
}

