/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.reconciliation;

import java.util.EnumSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerManager;
import org.apache.hadoop.hdds.scm.container.ContainerNotFoundException;
import org.apache.hadoop.hdds.scm.container.ContainerReplica;

public final class ReconciliationEligibilityHandler {
    public static final Set<HddsProtos.LifeCycleState> ELIGIBLE_CONTAINER_STATES = EnumSet.of(HddsProtos.LifeCycleState.CLOSED, HddsProtos.LifeCycleState.QUASI_CLOSED);
    public static final Set<StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State> ELIGIBLE_REPLICA_STATES = EnumSet.of(StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.CLOSED, StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.QUASI_CLOSED, StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.UNHEALTHY);

    private ReconciliationEligibilityHandler() {
    }

    public static EligibilityResult isEligibleForReconciliation(ContainerID containerID, ContainerManager containerManager) {
        Set<ContainerReplica> replicas;
        ContainerInfo container;
        try {
            container = containerManager.getContainer(containerID);
            replicas = containerManager.getContainerReplicas(containerID);
        }
        catch (ContainerNotFoundException ex) {
            return new EligibilityResult(Result.CONTAINER_NOT_FOUND, String.format("Container %s not found for reconciliation.", containerID));
        }
        if (!ELIGIBLE_CONTAINER_STATES.contains(container.getState())) {
            return new EligibilityResult(Result.INELIGIBLE_CONTAINER_STATE, String.format("Cannot reconcile container %d in state %s.", container.getContainerID(), container.getState()));
        }
        if (replicas.isEmpty()) {
            return new EligibilityResult(Result.NO_REPLICAS_FOUND, String.format("Cannot reconcile container %d because no replicas could be found.", container.getContainerID()));
        }
        boolean replicasValid = replicas.stream().map(ContainerReplica::getState).allMatch(ELIGIBLE_REPLICA_STATES::contains);
        if (!replicasValid) {
            return new EligibilityResult(Result.INELIGIBLE_REPLICA_STATES, String.format("Cannot reconcile container %s in state %s with replica states: %s", containerID, container.getState(), replicas.stream().map(r -> r.getState().toString()).collect(Collectors.joining(", "))));
        }
        ReplicationConfig repConfig = container.getReplicationConfig();
        if (repConfig.getReplicationType() != HddsProtos.ReplicationType.RATIS) {
            return new EligibilityResult(Result.INELIGIBLE_REPLICATION_TYPE, String.format("Cannot reconcile container %s with replication type %s. Reconciliation is currently only supported for Ratis containers.", containerID, repConfig.getReplicationType()));
        }
        int requiredNodes = repConfig.getRequiredNodes();
        if (requiredNodes <= 1) {
            return new EligibilityResult(Result.NOT_ENOUGH_REQUIRED_NODES, String.format("Cannot reconcile container %s with %d required nodes. Reconciliation is only supported for containers with more than 1 required node.", containerID, repConfig.getRequiredNodes()));
        }
        return new EligibilityResult(Result.OK, "Container %s is eligible for reconciliation." + containerID);
    }

    public static final class EligibilityResult {
        private final Result result;
        private final String message;

        private EligibilityResult(Result result, String message) {
            this.result = result;
            this.message = message;
        }

        public Result getResult() {
            return this.result;
        }

        public boolean isOk() {
            return this.result == Result.OK;
        }

        public String toString() {
            return this.message;
        }
    }

    public static enum Result {
        OK,
        CONTAINER_NOT_FOUND,
        INELIGIBLE_CONTAINER_STATE,
        INELIGIBLE_REPLICA_STATES,
        INELIGIBLE_REPLICATION_TYPE,
        NOT_ENOUGH_REQUIRED_NODES,
        NO_REPLICAS_FOUND;

    }
}

