/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.protocol;

import com.google.protobuf.ProtocolMessageEnum;
import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.client.ECReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerLocationProtocolProtos;
import org.apache.hadoop.hdds.scm.DatanodeAdminError;
import org.apache.hadoop.hdds.scm.ScmInfo;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerListResult;
import org.apache.hadoop.hdds.scm.container.common.helpers.ContainerWithPipeline;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;
import org.apache.hadoop.hdds.scm.ha.RatisUtil;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.protocol.StorageContainerLocationProtocol;
import org.apache.hadoop.hdds.scm.protocolPB.OzonePBHelper;
import org.apache.hadoop.hdds.scm.protocolPB.StorageContainerLocationProtocolPB;
import org.apache.hadoop.hdds.scm.server.StorageContainerManager;
import org.apache.hadoop.hdds.server.OzoneProtocolMessageDispatcher;
import org.apache.hadoop.hdds.upgrade.HDDSLayoutFeature;
import org.apache.hadoop.hdds.utils.ProtocolMessageMetrics;
import org.apache.hadoop.ozone.ClientVersion;
import org.apache.hadoop.ozone.upgrade.LayoutFeature;
import org.apache.hadoop.ozone.upgrade.UpgradeFinalization;
import org.apache.hadoop.ozone.util.ProtobufUtils;
import org.apache.hadoop.security.token.Token;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class StorageContainerLocationProtocolServerSideTranslatorPB
implements StorageContainerLocationProtocolPB {
    private static final Logger LOG = LoggerFactory.getLogger(StorageContainerLocationProtocolServerSideTranslatorPB.class);
    private static final String ERROR_LIST_CONTAINS_EC_REPLICATION_CONFIG = "The returned list of containers contains containers with Erasure Coded replication type, which the client won't be able to understand. Please upgrade the client to a version that supports Erasure Coded data, and retry!";
    private static final String ERROR_RESPONSE_CONTAINS_EC_REPLICATION_CONFIG = "The returned container data contains Erasure Coded replication information, which the client won't be able to understand. Please upgrade the client to a version that supports Erasure Coded data, and retry!";
    private final StorageContainerLocationProtocol impl;
    private final StorageContainerManager scm;
    private static final String ROLE_TYPE = "SCM";
    private OzoneProtocolMessageDispatcher<StorageContainerLocationProtocolProtos.ScmContainerLocationRequest, StorageContainerLocationProtocolProtos.ScmContainerLocationResponse, ProtocolMessageEnum> dispatcher;

    public StorageContainerLocationProtocolServerSideTranslatorPB(StorageContainerLocationProtocol impl, StorageContainerManager scm, ProtocolMessageMetrics<ProtocolMessageEnum> protocolMetrics) throws IOException {
        this.impl = impl;
        this.scm = scm;
        this.dispatcher = new OzoneProtocolMessageDispatcher("ScmContainerLocation", protocolMetrics, LOG);
    }

    public StorageContainerLocationProtocolProtos.ScmContainerLocationResponse submitRequest(RpcController controller, StorageContainerLocationProtocolProtos.ScmContainerLocationRequest request) throws ServiceException {
        if (!this.scm.checkLeader() && !StorageContainerLocationProtocol.ADMIN_COMMAND_TYPE.contains(request.getCmdType())) {
            RatisUtil.checkRatisException((IOException)((Object)this.scm.getScmHAManager().getRatisServer().triggerNotLeaderException()), this.scm.getClientRpcPort(), this.scm.getScmId(), this.scm.getHostname(), ROLE_TYPE);
        }
        boolean checkResponseForECRepConfig = false;
        if (request.getVersion() < ClientVersion.ERASURE_CODING_SUPPORT.toProtoValue() && (request.getCmdType() == StorageContainerLocationProtocolProtos.Type.GetContainer || request.getCmdType() == StorageContainerLocationProtocolProtos.Type.ListContainer || request.getCmdType() == StorageContainerLocationProtocolProtos.Type.GetContainerWithPipeline || request.getCmdType() == StorageContainerLocationProtocolProtos.Type.GetContainerWithPipelineBatch || request.getCmdType() == StorageContainerLocationProtocolProtos.Type.GetExistContainerWithPipelinesInBatch || request.getCmdType() == StorageContainerLocationProtocolProtos.Type.ListPipelines || request.getCmdType() == StorageContainerLocationProtocolProtos.Type.GetPipeline)) {
            checkResponseForECRepConfig = true;
        }
        StorageContainerLocationProtocolProtos.ScmContainerLocationResponse response = (StorageContainerLocationProtocolProtos.ScmContainerLocationResponse)this.dispatcher.processRequest((Object)request, this::processRequest, (Object)request.getCmdType(), request.getTraceID());
        if (checkResponseForECRepConfig) {
            try {
                switch (response.getCmdType()) {
                    case GetContainer: {
                        this.disallowECReplicationConfigInGetContainerResponse(response);
                        break;
                    }
                    case ListContainer: {
                        this.disallowECReplicationConfigInListContainerResponse(response);
                        break;
                    }
                    case GetContainerWithPipeline: {
                        this.disallowECReplicationConfigInGetContainerWithPipelineResponse(response);
                        break;
                    }
                    case GetContainerWithPipelineBatch: {
                        this.disallowECReplicationConfigInGetContainerWithPipelineBatchResponse(response);
                        break;
                    }
                    case GetExistContainerWithPipelinesInBatch: {
                        this.disallowECReplicationConfigInGetExistContainerWithPipelineBatchResp(response);
                        break;
                    }
                    case ListPipelines: {
                        this.disallowECReplicationConfigInListPipelinesResponse(response);
                        break;
                    }
                    case GetPipeline: {
                        this.disallowECReplicationConfigInGetPipelineResponse(response);
                        break;
                    }
                }
            }
            catch (SCMException e) {
                throw new ServiceException((Throwable)e);
            }
        }
        return response;
    }

    private void disallowECReplicationConfigInListContainerResponse(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse response) throws SCMException {
        if (!response.hasScmListContainerResponse()) {
            return;
        }
        for (HddsProtos.ContainerInfoProto containerInfo : response.getScmListContainerResponse().getContainersList()) {
            if (!containerInfo.hasEcReplicationConfig()) continue;
            throw new SCMException(ERROR_LIST_CONTAINS_EC_REPLICATION_CONFIG, SCMException.ResultCodes.INTERNAL_ERROR);
        }
    }

    private void disallowECReplicationConfigInGetContainerResponse(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse response) throws SCMException {
        if (!response.hasGetContainerResponse()) {
            return;
        }
        if (!response.getGetContainerResponse().hasContainerInfo()) {
            return;
        }
        if (response.getGetContainerResponse().getContainerInfo().hasEcReplicationConfig()) {
            throw new SCMException(ERROR_RESPONSE_CONTAINS_EC_REPLICATION_CONFIG, SCMException.ResultCodes.INTERNAL_ERROR);
        }
    }

    private void disallowECReplicationConfigInGetContainerWithPipelineResponse(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse response) throws SCMException {
        HddsProtos.Pipeline pipeline;
        HddsProtos.ContainerInfoProto containerInfo;
        if (!response.hasGetContainerWithPipelineResponse()) {
            return;
        }
        if (!response.getGetContainerWithPipelineResponse().hasContainerWithPipeline()) {
            return;
        }
        if (response.getGetContainerWithPipelineResponse().getContainerWithPipeline().hasContainerInfo() && (containerInfo = response.getGetContainerWithPipelineResponse().getContainerWithPipeline().getContainerInfo()).hasEcReplicationConfig()) {
            throw new SCMException(ERROR_RESPONSE_CONTAINS_EC_REPLICATION_CONFIG, SCMException.ResultCodes.INTERNAL_ERROR);
        }
        if (response.getGetContainerWithPipelineResponse().getContainerWithPipeline().hasPipeline() && (pipeline = response.getGetContainerWithPipelineResponse().getContainerWithPipeline().getPipeline()).hasEcReplicationConfig()) {
            throw new SCMException(ERROR_RESPONSE_CONTAINS_EC_REPLICATION_CONFIG, SCMException.ResultCodes.INTERNAL_ERROR);
        }
    }

    private void disallowECReplicationConfigInGetContainerWithPipelineBatchResponse(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse response) throws SCMException {
        if (!response.hasGetContainerWithPipelineBatchResponse()) {
            return;
        }
        List cwps = response.getGetContainerWithPipelineBatchResponse().getContainerWithPipelinesList();
        this.checkForECReplicationConfigIn(cwps);
    }

    private void disallowECReplicationConfigInGetExistContainerWithPipelineBatchResp(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse response) throws SCMException {
        if (!response.hasGetExistContainerWithPipelinesInBatchResponse()) {
            return;
        }
        List cwps = response.getGetExistContainerWithPipelinesInBatchResponse().getContainerWithPipelinesList();
        this.checkForECReplicationConfigIn(cwps);
    }

    private void checkForECReplicationConfigIn(List<HddsProtos.ContainerWithPipeline> cwps) throws SCMException {
        for (HddsProtos.ContainerWithPipeline cwp : cwps) {
            if (cwp.hasContainerInfo() && cwp.getContainerInfo().hasEcReplicationConfig()) {
                throw new SCMException(ERROR_LIST_CONTAINS_EC_REPLICATION_CONFIG, SCMException.ResultCodes.INTERNAL_ERROR);
            }
            if (!cwp.hasPipeline() || !cwp.getPipeline().hasEcReplicationConfig()) continue;
            throw new SCMException(ERROR_LIST_CONTAINS_EC_REPLICATION_CONFIG, SCMException.ResultCodes.INTERNAL_ERROR);
        }
    }

    private void disallowECReplicationConfigInListPipelinesResponse(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse response) throws SCMException {
        if (!response.hasListPipelineResponse()) {
            return;
        }
        for (HddsProtos.Pipeline pipeline : response.getListPipelineResponse().getPipelinesList()) {
            if (!pipeline.hasEcReplicationConfig()) continue;
            throw new SCMException("The returned list of pipelines contains pipelines with Erasure Coded replication type, which the client won't be able to understand. Please upgrade the client to a version that supports Erasure Coded data, and retry!", SCMException.ResultCodes.INTERNAL_ERROR);
        }
    }

    private void disallowECReplicationConfigInGetPipelineResponse(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse response) throws SCMException {
        if (!response.hasGetPipelineResponse()) {
            return;
        }
        if (response.getPipelineResponse().getPipeline().hasEcReplicationConfig()) {
            throw new SCMException("The returned pipeline data contains Erasure Coded replication information, which the client won't be able to understand. Please upgrade the client to a version that supports Erasure Coded data, and retry!", SCMException.ResultCodes.INTERNAL_ERROR);
        }
    }

    public StorageContainerLocationProtocolProtos.ScmContainerLocationResponse processRequest(StorageContainerLocationProtocolProtos.ScmContainerLocationRequest request) throws ServiceException {
        try {
            switch (request.getCmdType()) {
                case AllocateContainer: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setContainerResponse(this.allocateContainer(request.getContainerRequest(), request.getVersion())).build();
                }
                case GetContainer: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setGetContainerResponse(this.getContainer(request.getGetContainerRequest())).build();
                }
                case GetContainerToken: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setContainerTokenResponse(this.getContainerToken(request.getContainerTokenRequest())).build();
                }
                case GetContainerWithPipeline: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setGetContainerWithPipelineResponse(this.getContainerWithPipeline(request.getGetContainerWithPipelineRequest(), request.getVersion())).build();
                }
                case GetContainerWithPipelineBatch: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setGetContainerWithPipelineBatchResponse(this.getContainerWithPipelineBatch(request.getGetContainerWithPipelineBatchRequest(), request.getVersion())).build();
                }
                case GetExistContainerWithPipelinesInBatch: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setGetExistContainerWithPipelinesInBatchResponse(this.getExistContainerWithPipelinesInBatch(request.getGetExistContainerWithPipelinesInBatchRequest(), request.getVersion())).build();
                }
                case ListContainer: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setScmListContainerResponse(this.listContainer(request.getScmListContainerRequest())).build();
                }
                case QueryNode: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setNodeQueryResponse(this.queryNode(request.getNodeQueryRequest(), request.getVersion())).build();
                }
                case SingleNodeQuery: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setSingleNodeQueryResponse(this.querySingleNode(request.getSingleNodeQueryRequest())).build();
                }
                case CloseContainer: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setScmCloseContainerResponse(this.closeContainer(request.getScmCloseContainerRequest())).build();
                }
                case AllocatePipeline: {
                    if (this.scm.getLayoutVersionManager().needsFinalization() && !this.scm.getLayoutVersionManager().isAllowed((LayoutFeature)HDDSLayoutFeature.ERASURE_CODED_STORAGE_SUPPORT) && request.getPipelineRequest().getReplicationType() == HddsProtos.ReplicationType.EC) {
                        throw new SCMException("Cluster is not finalized yet, it is not enabled to create pipelines with Erasure Coded replication type.", SCMException.ResultCodes.INTERNAL_ERROR);
                    }
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setPipelineResponse(this.allocatePipeline(request.getPipelineRequest(), request.getVersion())).build();
                }
                case ListPipelines: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setListPipelineResponse(this.listPipelines(request.getListPipelineRequest(), request.getVersion())).build();
                }
                case ActivatePipeline: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setActivatePipelineResponse(this.activatePipeline(request.getActivatePipelineRequest())).build();
                }
                case DeactivatePipeline: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setDeactivatePipelineResponse(this.deactivatePipeline(request.getDeactivatePipelineRequest())).build();
                }
                case ClosePipeline: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setClosePipelineResponse(this.closePipeline(request.getClosePipelineRequest())).build();
                }
                case GetScmInfo: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setGetScmInfoResponse(this.getScmInfo(request.getGetScmInfoRequest())).build();
                }
                case InSafeMode: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setInSafeModeResponse(this.inSafeMode(request.getInSafeModeRequest())).build();
                }
                case ForceExitSafeMode: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setForceExitSafeModeResponse(this.forceExitSafeMode(request.getForceExitSafeModeRequest())).build();
                }
                case StartReplicationManager: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setStartReplicationManagerResponse(this.startReplicationManager(request.getStartReplicationManagerRequest())).build();
                }
                case StopReplicationManager: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setStopReplicationManagerResponse(this.stopReplicationManager(request.getStopReplicationManagerRequest())).build();
                }
                case GetReplicationManagerStatus: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setReplicationManagerStatusResponse(this.getReplicationManagerStatus(request.getSeplicationManagerStatusRequest())).build();
                }
                case GetReplicationManagerReport: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setGetReplicationManagerReportResponse(this.getReplicationManagerReport(request.getReplicationManagerReportRequest())).build();
                }
                case StartContainerBalancer: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setStartContainerBalancerResponse(this.startContainerBalancer(request.getStartContainerBalancerRequest())).build();
                }
                case StopContainerBalancer: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setStopContainerBalancerResponse(this.stopContainerBalancer(request.getStopContainerBalancerRequest())).build();
                }
                case GetContainerBalancerStatus: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setContainerBalancerStatusResponse(this.getContainerBalancerStatus(request.getContainerBalancerStatusRequest())).build();
                }
                case GetContainerBalancerStatusInfo: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setContainerBalancerStatusInfoResponse(this.getContainerBalancerStatusInfo(request.getContainerBalancerStatusInfoRequest())).build();
                }
                case GetPipeline: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setGetPipelineResponse(this.getPipeline(request.getGetPipelineRequest(), request.getVersion())).build();
                }
                case GetSafeModeRuleStatuses: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setGetSafeModeRuleStatusesResponse(this.getSafeModeRuleStatues(request.getGetSafeModeRuleStatusesRequest())).build();
                }
                case DecommissionNodes: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setDecommissionNodesResponse(this.decommissionNodes(request.getDecommissionNodesRequest())).build();
                }
                case GetContainersOnDecomNode: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setGetContainersOnDecomNodeResponse(this.getContainersOnDecomNode(request.getGetContainersOnDecomNodeRequest())).build();
                }
                case RecommissionNodes: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setRecommissionNodesResponse(this.recommissionNodes(request.getRecommissionNodesRequest())).build();
                }
                case StartMaintenanceNodes: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setStartMaintenanceNodesResponse(this.startMaintenanceNodes(request.getStartMaintenanceNodesRequest())).build();
                }
                case FinalizeScmUpgrade: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setFinalizeScmUpgradeResponse(this.getFinalizeScmUpgrade(request.getFinalizeScmUpgradeRequest())).build();
                }
                case QueryUpgradeFinalizationProgress: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setQueryUpgradeFinalizationProgressResponse(this.getQueryUpgradeFinalizationProgress(request.getQueryUpgradeFinalizationProgressRequest())).build();
                }
                case DatanodeUsageInfo: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setDatanodeUsageInfoResponse(this.getDatanodeUsageInfo(request.getDatanodeUsageInfoRequest(), request.getVersion())).build();
                }
                case GetContainerCount: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setGetContainerCountResponse(this.getContainerCount(request.getGetContainerCountRequest())).build();
                }
                case GetClosedContainerCount: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setGetContainerCountResponse(this.getClosedContainerCount(request.getGetContainerCountRequest())).build();
                }
                case GetContainerReplicas: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setGetContainerReplicasResponse(this.getContainerReplicas(request.getGetContainerReplicasRequest(), request.getVersion())).build();
                }
                case GetFailedDeletedBlocksTransaction: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setGetFailedDeletedBlocksTxnResponse(this.getFailedDeletedBlocksTxn(request.getGetFailedDeletedBlocksTxnRequest())).build();
                }
                case ResetDeletedBlockRetryCount: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setResetDeletedBlockRetryCountResponse(this.getResetDeletedBlockRetryCount(request.getResetDeletedBlockRetryCountRequest())).build();
                }
                case TransferLeadership: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setTransferScmLeadershipResponse(this.transferScmLeadership(request.getTransferScmLeadershipRequest())).build();
                }
                case DecommissionScm: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setDecommissionScmResponse(this.decommissionScm(request.getDecommissionScmRequest())).build();
                }
                case GetMetrics: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setGetMetricsResponse(this.getMetrics(request.getGetMetricsRequest())).build();
                }
            }
            throw new IllegalArgumentException("Unknown command type: " + request.getCmdType());
        }
        catch (IOException e) {
            RatisUtil.checkRatisException(e, this.scm.getClientRpcPort(), this.scm.getScmId(), this.scm.getHostname(), ROLE_TYPE);
            throw new ServiceException((Throwable)e);
        }
    }

    public StorageContainerLocationProtocolProtos.GetContainerReplicasResponseProto getContainerReplicas(StorageContainerLocationProtocolProtos.GetContainerReplicasRequestProto request, int clientVersion) throws IOException {
        List replicas = this.impl.getContainerReplicas(request.getContainerID(), clientVersion);
        return StorageContainerLocationProtocolProtos.GetContainerReplicasResponseProto.newBuilder().addAllContainerReplica((Iterable)replicas).build();
    }

    public StorageContainerLocationProtocolProtos.ContainerResponseProto allocateContainer(StorageContainerLocationProtocolProtos.ContainerRequestProto request, int clientVersion) throws IOException {
        ContainerWithPipeline cp = this.impl.allocateContainer(request.getReplicationType(), request.getReplicationFactor(), request.getOwner());
        return StorageContainerLocationProtocolProtos.ContainerResponseProto.newBuilder().setContainerWithPipeline(cp.getProtobuf(clientVersion)).setErrorCode(StorageContainerLocationProtocolProtos.ContainerResponseProto.Error.success).build();
    }

    public StorageContainerLocationProtocolProtos.GetContainerResponseProto getContainer(StorageContainerLocationProtocolProtos.GetContainerRequestProto request) throws IOException {
        ContainerInfo container = this.impl.getContainer(request.getContainerID());
        return StorageContainerLocationProtocolProtos.GetContainerResponseProto.newBuilder().setContainerInfo(container.getProtobuf()).build();
    }

    public StorageContainerLocationProtocolProtos.GetContainerTokenResponseProto getContainerToken(StorageContainerLocationProtocolProtos.GetContainerTokenRequestProto request) throws IOException {
        ContainerID containerID = ContainerID.getFromProtobuf((HddsProtos.ContainerID)request.getContainerID());
        HddsProtos.TokenProto token = OzonePBHelper.protoFromToken((Token)this.impl.getContainerToken(containerID));
        return StorageContainerLocationProtocolProtos.GetContainerTokenResponseProto.newBuilder().setToken(token).build();
    }

    public StorageContainerLocationProtocolProtos.GetContainerWithPipelineResponseProto getContainerWithPipeline(StorageContainerLocationProtocolProtos.GetContainerWithPipelineRequestProto request, int clientVersion) throws IOException {
        ContainerWithPipeline container = this.impl.getContainerWithPipeline(request.getContainerID());
        return StorageContainerLocationProtocolProtos.GetContainerWithPipelineResponseProto.newBuilder().setContainerWithPipeline(container.getProtobuf(clientVersion)).build();
    }

    public StorageContainerLocationProtocolProtos.GetContainerWithPipelineBatchResponseProto getContainerWithPipelineBatch(StorageContainerLocationProtocolProtos.GetContainerWithPipelineBatchRequestProto request, int clientVersion) throws IOException {
        List containers = this.impl.getContainerWithPipelineBatch((Iterable)request.getContainerIDsList());
        StorageContainerLocationProtocolProtos.GetContainerWithPipelineBatchResponseProto.Builder builder = StorageContainerLocationProtocolProtos.GetContainerWithPipelineBatchResponseProto.newBuilder();
        for (ContainerWithPipeline container : containers) {
            builder.addContainerWithPipelines(container.getProtobuf(clientVersion));
        }
        return builder.build();
    }

    public StorageContainerLocationProtocolProtos.GetExistContainerWithPipelinesInBatchResponseProto getExistContainerWithPipelinesInBatch(StorageContainerLocationProtocolProtos.GetExistContainerWithPipelinesInBatchRequestProto request, int clientVersion) throws IOException {
        List containers = this.impl.getExistContainerWithPipelinesInBatch(request.getContainerIDsList());
        StorageContainerLocationProtocolProtos.GetExistContainerWithPipelinesInBatchResponseProto.Builder builder = StorageContainerLocationProtocolProtos.GetExistContainerWithPipelinesInBatchResponseProto.newBuilder();
        for (ContainerWithPipeline container : containers) {
            builder.addContainerWithPipelines(container.getProtobuf(clientVersion));
        }
        return builder.build();
    }

    public StorageContainerLocationProtocolProtos.SCMListContainerResponseProto listContainer(StorageContainerLocationProtocolProtos.SCMListContainerRequestProto request) throws IOException {
        long startContainerID = 0L;
        int count = -1;
        if (request.hasStartContainerID()) {
            startContainerID = request.getStartContainerID();
        }
        count = request.getCount();
        HddsProtos.LifeCycleState state = null;
        HddsProtos.ReplicationFactor factor = null;
        HddsProtos.ReplicationType replicationType = null;
        ECReplicationConfig repConfig = null;
        if (request.hasState()) {
            state = request.getState();
        }
        if (request.hasType()) {
            replicationType = request.getType();
        }
        if (replicationType != null) {
            if (replicationType == HddsProtos.ReplicationType.EC) {
                if (request.hasEcReplicationConfig()) {
                    repConfig = new ECReplicationConfig(request.getEcReplicationConfig());
                }
            } else if (request.hasFactor()) {
                repConfig = ReplicationConfig.fromProtoTypeAndFactor((HddsProtos.ReplicationType)request.getType(), (HddsProtos.ReplicationFactor)request.getFactor());
            }
        } else if (request.hasFactor()) {
            factor = request.getFactor();
        }
        ContainerListResult containerListAndTotalCount = factor != null ? this.impl.listContainer(startContainerID, count, state, factor) : this.impl.listContainer(startContainerID, count, state, replicationType, (ReplicationConfig)repConfig);
        StorageContainerLocationProtocolProtos.SCMListContainerResponseProto.Builder builder = StorageContainerLocationProtocolProtos.SCMListContainerResponseProto.newBuilder();
        for (ContainerInfo container : containerListAndTotalCount.getContainerInfoList()) {
            builder.addContainers(container.getProtobuf());
        }
        builder.setContainerCount(containerListAndTotalCount.getTotalCount());
        return builder.build();
    }

    public StorageContainerLocationProtocolProtos.SCMDeleteContainerResponseProto deleteContainer(StorageContainerLocationProtocolProtos.SCMDeleteContainerRequestProto request) throws IOException {
        this.impl.deleteContainer(request.getContainerID());
        return StorageContainerLocationProtocolProtos.SCMDeleteContainerResponseProto.newBuilder().build();
    }

    public StorageContainerLocationProtocolProtos.NodeQueryResponseProto queryNode(StorageContainerLocationProtocolProtos.NodeQueryRequestProto request, int clientVersion) throws IOException {
        HddsProtos.NodeOperationalState opState = null;
        HddsProtos.NodeState nodeState = null;
        if (request.hasState()) {
            nodeState = request.getState();
        }
        if (request.hasOpState()) {
            opState = request.getOpState();
        }
        List datanodes = this.impl.queryNode(opState, nodeState, request.getScope(), request.getPoolName(), clientVersion);
        return StorageContainerLocationProtocolProtos.NodeQueryResponseProto.newBuilder().addAllDatanodes((Iterable)datanodes).build();
    }

    public StorageContainerLocationProtocolProtos.SingleNodeQueryResponseProto querySingleNode(StorageContainerLocationProtocolProtos.SingleNodeQueryRequestProto request) throws IOException {
        HddsProtos.Node datanode = this.impl.queryNode(ProtobufUtils.fromProtobuf((HddsProtos.UUID)request.getUuid()));
        return StorageContainerLocationProtocolProtos.SingleNodeQueryResponseProto.newBuilder().setDatanode(datanode).build();
    }

    public StorageContainerLocationProtocolProtos.SCMCloseContainerResponseProto closeContainer(StorageContainerLocationProtocolProtos.SCMCloseContainerRequestProto request) throws IOException {
        try {
            this.impl.closeContainer(request.getContainerID());
        }
        catch (SCMException exception) {
            if (exception.getResult().equals((Object)SCMException.ResultCodes.CONTAINER_ALREADY_CLOSED)) {
                return StorageContainerLocationProtocolProtos.SCMCloseContainerResponseProto.newBuilder().setStatus(StorageContainerLocationProtocolProtos.SCMCloseContainerResponseProto.Status.CONTAINER_ALREADY_CLOSED).build();
            }
            if (exception.getResult().equals((Object)SCMException.ResultCodes.CONTAINER_ALREADY_CLOSING)) {
                return StorageContainerLocationProtocolProtos.SCMCloseContainerResponseProto.newBuilder().setStatus(StorageContainerLocationProtocolProtos.SCMCloseContainerResponseProto.Status.CONTAINER_ALREADY_CLOSING).build();
            }
            throw exception;
        }
        return StorageContainerLocationProtocolProtos.SCMCloseContainerResponseProto.newBuilder().build();
    }

    public StorageContainerLocationProtocolProtos.PipelineResponseProto allocatePipeline(StorageContainerLocationProtocolProtos.PipelineRequestProto request, int clientVersion) throws IOException {
        Pipeline pipeline = this.impl.createReplicationPipeline(request.getReplicationType(), request.getReplicationFactor(), HddsProtos.NodePool.getDefaultInstance());
        if (pipeline == null) {
            return StorageContainerLocationProtocolProtos.PipelineResponseProto.newBuilder().setErrorCode(StorageContainerLocationProtocolProtos.PipelineResponseProto.Error.errorPipelineAlreadyExists).build();
        }
        return StorageContainerLocationProtocolProtos.PipelineResponseProto.newBuilder().setErrorCode(StorageContainerLocationProtocolProtos.PipelineResponseProto.Error.success).setPipeline(pipeline.getProtobufMessage(clientVersion)).build();
    }

    public StorageContainerLocationProtocolProtos.ListPipelineResponseProto listPipelines(StorageContainerLocationProtocolProtos.ListPipelineRequestProto request, int clientVersion) throws IOException {
        StorageContainerLocationProtocolProtos.ListPipelineResponseProto.Builder builder = StorageContainerLocationProtocolProtos.ListPipelineResponseProto.newBuilder();
        List pipelines = this.impl.listPipelines();
        for (Pipeline pipeline : pipelines) {
            builder.addPipelines(pipeline.getProtobufMessage(clientVersion));
        }
        return builder.build();
    }

    public StorageContainerLocationProtocolProtos.GetPipelineResponseProto getPipeline(StorageContainerLocationProtocolProtos.GetPipelineRequestProto request, int clientVersion) throws IOException {
        StorageContainerLocationProtocolProtos.GetPipelineResponseProto.Builder builder = StorageContainerLocationProtocolProtos.GetPipelineResponseProto.newBuilder();
        Pipeline pipeline = this.impl.getPipeline(request.getPipelineID());
        builder.setPipeline(pipeline.getProtobufMessage(clientVersion));
        return builder.build();
    }

    public StorageContainerLocationProtocolProtos.ActivatePipelineResponseProto activatePipeline(StorageContainerLocationProtocolProtos.ActivatePipelineRequestProto request) throws IOException {
        this.impl.activatePipeline(request.getPipelineID());
        return StorageContainerLocationProtocolProtos.ActivatePipelineResponseProto.newBuilder().build();
    }

    public StorageContainerLocationProtocolProtos.DeactivatePipelineResponseProto deactivatePipeline(StorageContainerLocationProtocolProtos.DeactivatePipelineRequestProto request) throws IOException {
        this.impl.deactivatePipeline(request.getPipelineID());
        return StorageContainerLocationProtocolProtos.DeactivatePipelineResponseProto.newBuilder().build();
    }

    public StorageContainerLocationProtocolProtos.ClosePipelineResponseProto closePipeline(StorageContainerLocationProtocolProtos.ClosePipelineRequestProto request) throws IOException {
        this.impl.closePipeline(request.getPipelineID());
        return StorageContainerLocationProtocolProtos.ClosePipelineResponseProto.newBuilder().build();
    }

    public HddsProtos.GetScmInfoResponseProto getScmInfo(HddsProtos.GetScmInfoRequestProto req) throws IOException {
        ScmInfo scmInfo = this.impl.getScmInfo();
        return HddsProtos.GetScmInfoResponseProto.newBuilder().setClusterId(scmInfo.getClusterId()).setScmId(scmInfo.getScmId()).addAllPeerRoles((Iterable)scmInfo.getPeerRoles()).build();
    }

    public StorageContainerLocationProtocolProtos.InSafeModeResponseProto inSafeMode(StorageContainerLocationProtocolProtos.InSafeModeRequestProto request) throws IOException {
        return StorageContainerLocationProtocolProtos.InSafeModeResponseProto.newBuilder().setInSafeMode(this.impl.inSafeMode()).build();
    }

    public StorageContainerLocationProtocolProtos.GetSafeModeRuleStatusesResponseProto getSafeModeRuleStatues(StorageContainerLocationProtocolProtos.GetSafeModeRuleStatusesRequestProto request) throws IOException {
        Map map = this.impl.getSafeModeRuleStatuses();
        ArrayList<StorageContainerLocationProtocolProtos.SafeModeRuleStatusProto> proto = new ArrayList<StorageContainerLocationProtocolProtos.SafeModeRuleStatusProto>();
        for (Map.Entry entry : map.entrySet()) {
            proto.add(StorageContainerLocationProtocolProtos.SafeModeRuleStatusProto.newBuilder().setRuleName((String)entry.getKey()).setValidate(((Boolean)((Pair)entry.getValue()).getLeft()).booleanValue()).setStatusText((String)((Pair)entry.getValue()).getRight()).build());
        }
        return StorageContainerLocationProtocolProtos.GetSafeModeRuleStatusesResponseProto.newBuilder().addAllSafeModeRuleStatusesProto(proto).build();
    }

    public StorageContainerLocationProtocolProtos.FinalizeScmUpgradeResponseProto getFinalizeScmUpgrade(StorageContainerLocationProtocolProtos.FinalizeScmUpgradeRequestProto request) throws IOException {
        UpgradeFinalization.StatusAndMessages progress = this.impl.finalizeScmUpgrade(request.getUpgradeClientId());
        HddsProtos.UpgradeFinalizationStatus.Status protoStatus = HddsProtos.UpgradeFinalizationStatus.Status.valueOf((String)progress.status().name());
        HddsProtos.UpgradeFinalizationStatus response = HddsProtos.UpgradeFinalizationStatus.newBuilder().setStatus(protoStatus).addAllMessages((Iterable)progress.msgs()).build();
        return StorageContainerLocationProtocolProtos.FinalizeScmUpgradeResponseProto.newBuilder().setStatus(response).build();
    }

    public StorageContainerLocationProtocolProtos.QueryUpgradeFinalizationProgressResponseProto getQueryUpgradeFinalizationProgress(StorageContainerLocationProtocolProtos.QueryUpgradeFinalizationProgressRequestProto request) throws IOException {
        UpgradeFinalization.StatusAndMessages progress = this.impl.queryUpgradeFinalizationProgress(request.getUpgradeClientId(), request.getTakeover(), request.getReadonly());
        HddsProtos.UpgradeFinalizationStatus.Status protoStatus = HddsProtos.UpgradeFinalizationStatus.Status.valueOf((String)progress.status().name());
        HddsProtos.UpgradeFinalizationStatus response = HddsProtos.UpgradeFinalizationStatus.newBuilder().setStatus(protoStatus).addAllMessages((Iterable)progress.msgs()).build();
        return StorageContainerLocationProtocolProtos.QueryUpgradeFinalizationProgressResponseProto.newBuilder().setStatus(response).build();
    }

    public StorageContainerLocationProtocolProtos.ForceExitSafeModeResponseProto forceExitSafeMode(StorageContainerLocationProtocolProtos.ForceExitSafeModeRequestProto request) throws IOException {
        return StorageContainerLocationProtocolProtos.ForceExitSafeModeResponseProto.newBuilder().setExitedSafeMode(this.impl.forceExitSafeMode()).build();
    }

    public StorageContainerLocationProtocolProtos.StartReplicationManagerResponseProto startReplicationManager(StorageContainerLocationProtocolProtos.StartReplicationManagerRequestProto request) throws IOException {
        this.impl.startReplicationManager();
        return StorageContainerLocationProtocolProtos.StartReplicationManagerResponseProto.newBuilder().build();
    }

    public StorageContainerLocationProtocolProtos.StopReplicationManagerResponseProto stopReplicationManager(StorageContainerLocationProtocolProtos.StopReplicationManagerRequestProto request) throws IOException {
        this.impl.stopReplicationManager();
        return StorageContainerLocationProtocolProtos.StopReplicationManagerResponseProto.newBuilder().build();
    }

    public StorageContainerLocationProtocolProtos.ReplicationManagerStatusResponseProto getReplicationManagerStatus(StorageContainerLocationProtocolProtos.ReplicationManagerStatusRequestProto request) throws IOException {
        return StorageContainerLocationProtocolProtos.ReplicationManagerStatusResponseProto.newBuilder().setIsRunning(this.impl.getReplicationManagerStatus()).build();
    }

    public StorageContainerLocationProtocolProtos.ReplicationManagerReportResponseProto getReplicationManagerReport(StorageContainerLocationProtocolProtos.ReplicationManagerReportRequestProto request) throws IOException {
        return StorageContainerLocationProtocolProtos.ReplicationManagerReportResponseProto.newBuilder().setReport(this.impl.getReplicationManagerReport().toProtobuf()).build();
    }

    public StorageContainerLocationProtocolProtos.StartContainerBalancerResponseProto startContainerBalancer(StorageContainerLocationProtocolProtos.StartContainerBalancerRequestProto request) throws IOException {
        Optional<Object> threshold = Optional.empty();
        Optional<Object> iterations = Optional.empty();
        Optional<Object> maxDatanodesPercentageToInvolvePerIteration = Optional.empty();
        Optional<Object> maxSizeToMovePerIterationInGB = Optional.empty();
        Optional<Object> maxSizeEnteringTargetInGB = Optional.empty();
        Optional<Object> maxSizeLeavingSourceInGB = Optional.empty();
        Optional<Object> balancingInterval = Optional.empty();
        Optional<Object> moveTimeout = Optional.empty();
        Optional<Object> moveReplicationTimeout = Optional.empty();
        Optional<Object> networkTopologyEnable = Optional.empty();
        Optional<Object> includeNodes = Optional.empty();
        Optional<Object> excludeNodes = Optional.empty();
        if (request.hasThreshold()) {
            threshold = Optional.of(request.getThreshold());
        }
        if (request.hasIterations()) {
            iterations = Optional.of(request.getIterations());
        } else if (request.hasIdleiterations()) {
            iterations = Optional.of(request.getIdleiterations());
        }
        if (request.hasMaxDatanodesPercentageToInvolvePerIteration()) {
            maxDatanodesPercentageToInvolvePerIteration = Optional.of(request.getMaxDatanodesPercentageToInvolvePerIteration());
        } else if (request.hasMaxDatanodesRatioToInvolvePerIteration()) {
            maxDatanodesPercentageToInvolvePerIteration = Optional.of((int)(request.getMaxDatanodesRatioToInvolvePerIteration() * 100.0));
        }
        if (request.hasMaxSizeToMovePerIterationInGB()) {
            maxSizeToMovePerIterationInGB = Optional.of(request.getMaxSizeToMovePerIterationInGB());
        }
        if (request.hasMaxSizeEnteringTargetInGB()) {
            maxSizeEnteringTargetInGB = Optional.of(request.getMaxSizeEnteringTargetInGB());
        }
        if (request.hasMaxSizeLeavingSourceInGB()) {
            maxSizeLeavingSourceInGB = Optional.of(request.getMaxSizeLeavingSourceInGB());
        }
        if (request.hasBalancingInterval()) {
            balancingInterval = Optional.of(request.getBalancingInterval());
        }
        if (request.hasMoveTimeout()) {
            moveTimeout = Optional.of(request.getMoveTimeout());
        }
        if (request.hasMoveReplicationTimeout()) {
            moveReplicationTimeout = Optional.of(request.getMoveReplicationTimeout());
        }
        if (request.hasNetworkTopologyEnable()) {
            networkTopologyEnable = Optional.of(request.getNetworkTopologyEnable());
        }
        if (request.hasIncludeNodes()) {
            includeNodes = Optional.of(request.getIncludeNodes());
        }
        if (request.hasExcludeNodes()) {
            excludeNodes = Optional.of(request.getExcludeNodes());
        }
        return this.impl.startContainerBalancer(threshold, iterations, maxDatanodesPercentageToInvolvePerIteration, maxSizeToMovePerIterationInGB, maxSizeEnteringTargetInGB, maxSizeLeavingSourceInGB, balancingInterval, moveTimeout, moveReplicationTimeout, networkTopologyEnable, includeNodes, excludeNodes);
    }

    public StorageContainerLocationProtocolProtos.StopContainerBalancerResponseProto stopContainerBalancer(StorageContainerLocationProtocolProtos.StopContainerBalancerRequestProto request) throws IOException {
        this.impl.stopContainerBalancer();
        return StorageContainerLocationProtocolProtos.StopContainerBalancerResponseProto.newBuilder().build();
    }

    public StorageContainerLocationProtocolProtos.ContainerBalancerStatusResponseProto getContainerBalancerStatus(StorageContainerLocationProtocolProtos.ContainerBalancerStatusRequestProto request) throws IOException {
        return StorageContainerLocationProtocolProtos.ContainerBalancerStatusResponseProto.newBuilder().setIsRunning(this.impl.getContainerBalancerStatus()).build();
    }

    public StorageContainerLocationProtocolProtos.ContainerBalancerStatusInfoResponseProto getContainerBalancerStatusInfo(StorageContainerLocationProtocolProtos.ContainerBalancerStatusInfoRequestProto request) throws IOException {
        return this.impl.getContainerBalancerStatusInfo();
    }

    public StorageContainerLocationProtocolProtos.DecommissionNodesResponseProto decommissionNodes(StorageContainerLocationProtocolProtos.DecommissionNodesRequestProto request) throws IOException {
        List errors = this.impl.decommissionNodes(request.getHostsList(), request.getForce());
        StorageContainerLocationProtocolProtos.DecommissionNodesResponseProto.Builder response = StorageContainerLocationProtocolProtos.DecommissionNodesResponseProto.newBuilder();
        for (DatanodeAdminError e : errors) {
            StorageContainerLocationProtocolProtos.DatanodeAdminErrorResponseProto.Builder error = StorageContainerLocationProtocolProtos.DatanodeAdminErrorResponseProto.newBuilder();
            error.setHost(e.getHostname());
            error.setError(e.getError());
            response.addFailedHosts(error);
        }
        return response.build();
    }

    public StorageContainerLocationProtocolProtos.GetContainersOnDecomNodeResponseProto getContainersOnDecomNode(StorageContainerLocationProtocolProtos.GetContainersOnDecomNodeRequestProto request) throws IOException {
        Map containerMap = this.impl.getContainersOnDecomNode(DatanodeDetails.getFromProtoBuf((HddsProtos.DatanodeDetailsProto)request.getDatanodeDetails()));
        ArrayList<StorageContainerLocationProtocolProtos.ContainersOnDecomNodeProto> containersProtoList = new ArrayList<StorageContainerLocationProtocolProtos.ContainersOnDecomNodeProto>();
        for (Map.Entry containerList : containerMap.entrySet()) {
            ArrayList<HddsProtos.ContainerID> containerIdsProto = new ArrayList<HddsProtos.ContainerID>();
            for (ContainerID id : (List)containerList.getValue()) {
                containerIdsProto.add(id.getProtobuf());
            }
            containersProtoList.add(StorageContainerLocationProtocolProtos.ContainersOnDecomNodeProto.newBuilder().setName((String)containerList.getKey()).addAllId(containerIdsProto).build());
        }
        return StorageContainerLocationProtocolProtos.GetContainersOnDecomNodeResponseProto.newBuilder().addAllContainersOnDecomNode(containersProtoList).build();
    }

    public StorageContainerLocationProtocolProtos.RecommissionNodesResponseProto recommissionNodes(StorageContainerLocationProtocolProtos.RecommissionNodesRequestProto request) throws IOException {
        List errors = this.impl.recommissionNodes(request.getHostsList());
        StorageContainerLocationProtocolProtos.RecommissionNodesResponseProto.Builder response = StorageContainerLocationProtocolProtos.RecommissionNodesResponseProto.newBuilder();
        for (DatanodeAdminError e : errors) {
            StorageContainerLocationProtocolProtos.DatanodeAdminErrorResponseProto.Builder error = StorageContainerLocationProtocolProtos.DatanodeAdminErrorResponseProto.newBuilder();
            error.setHost(e.getHostname());
            error.setError(e.getError());
            response.addFailedHosts(error);
        }
        return response.build();
    }

    public StorageContainerLocationProtocolProtos.StartMaintenanceNodesResponseProto startMaintenanceNodes(StorageContainerLocationProtocolProtos.StartMaintenanceNodesRequestProto request) throws IOException {
        List errors = this.impl.startMaintenanceNodes(request.getHostsList(), (int)request.getEndInHours(), request.getForce());
        StorageContainerLocationProtocolProtos.StartMaintenanceNodesResponseProto.Builder response = StorageContainerLocationProtocolProtos.StartMaintenanceNodesResponseProto.newBuilder();
        for (DatanodeAdminError e : errors) {
            StorageContainerLocationProtocolProtos.DatanodeAdminErrorResponseProto.Builder error = StorageContainerLocationProtocolProtos.DatanodeAdminErrorResponseProto.newBuilder();
            error.setHost(e.getHostname());
            error.setError(e.getError());
            response.addFailedHosts(error);
        }
        return response.build();
    }

    public StorageContainerLocationProtocolProtos.DatanodeUsageInfoResponseProto getDatanodeUsageInfo(StorageContainerLocationProtocolProtos.DatanodeUsageInfoRequestProto request, int clientVersion) throws IOException {
        List infoList = request.hasUuid() || request.hasIpaddress() ? this.impl.getDatanodeUsageInfo(request.getIpaddress(), request.getUuid(), clientVersion) : this.impl.getDatanodeUsageInfo(request.getMostUsed(), request.getCount(), clientVersion);
        return StorageContainerLocationProtocolProtos.DatanodeUsageInfoResponseProto.newBuilder().addAllInfo((Iterable)infoList).build();
    }

    public StorageContainerLocationProtocolProtos.GetContainerCountResponseProto getContainerCount(StorageContainerLocationProtocolProtos.GetContainerCountRequestProto request) throws IOException {
        return StorageContainerLocationProtocolProtos.GetContainerCountResponseProto.newBuilder().setContainerCount(this.impl.getContainerCount()).build();
    }

    public StorageContainerLocationProtocolProtos.GetContainerCountResponseProto getClosedContainerCount(StorageContainerLocationProtocolProtos.GetContainerCountRequestProto request) throws IOException {
        return StorageContainerLocationProtocolProtos.GetContainerCountResponseProto.newBuilder().setContainerCount(this.impl.getContainerCount(HddsProtos.LifeCycleState.CLOSED)).build();
    }

    public StorageContainerLocationProtocolProtos.GetFailedDeletedBlocksTxnResponseProto getFailedDeletedBlocksTxn(StorageContainerLocationProtocolProtos.GetFailedDeletedBlocksTxnRequestProto request) throws IOException {
        long startTxId = request.hasStartTxId() ? request.getStartTxId() : 0L;
        return StorageContainerLocationProtocolProtos.GetFailedDeletedBlocksTxnResponseProto.newBuilder().addAllDeletedBlocksTransactions((Iterable)this.impl.getFailedDeletedBlockTxn(request.getCount(), startTxId)).build();
    }

    public StorageContainerLocationProtocolProtos.ResetDeletedBlockRetryCountResponseProto getResetDeletedBlockRetryCount(StorageContainerLocationProtocolProtos.ResetDeletedBlockRetryCountRequestProto request) throws IOException {
        return StorageContainerLocationProtocolProtos.ResetDeletedBlockRetryCountResponseProto.newBuilder().setResetCount(this.impl.resetDeletedBlockRetryCount(request.getTransactionIdList())).build();
    }

    public HddsProtos.TransferLeadershipResponseProto transferScmLeadership(HddsProtos.TransferLeadershipRequestProto request) throws IOException {
        String newLeaderId = request.getNewLeaderId();
        this.impl.transferLeadership(newLeaderId);
        return HddsProtos.TransferLeadershipResponseProto.getDefaultInstance();
    }

    public StorageContainerLocationProtocolProtos.DecommissionScmResponseProto decommissionScm(StorageContainerLocationProtocolProtos.DecommissionScmRequestProto request) throws IOException {
        return this.impl.decommissionScm(request.getScmId());
    }

    public StorageContainerLocationProtocolProtos.GetMetricsResponseProto getMetrics(StorageContainerLocationProtocolProtos.GetMetricsRequestProto request) throws IOException {
        return StorageContainerLocationProtocolProtos.GetMetricsResponseProto.newBuilder().setMetricsJson(this.impl.getMetrics(request.getQuery())).build();
    }
}

