/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.pipeline.choose.algorithms;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import org.apache.hadoop.hdds.scm.PipelineChoosePolicy;
import org.apache.hadoop.hdds.scm.PipelineRequestInformation;
import org.apache.hadoop.hdds.scm.container.placement.metrics.SCMNodeMetric;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.choose.algorithms.HealthyPipelineChoosePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CapacityPipelineChoosePolicy
implements PipelineChoosePolicy {
    private static final Logger LOG = LoggerFactory.getLogger(PipelineChoosePolicy.class);
    private NodeManager nodeManager;
    private final PipelineChoosePolicy healthPolicy = new HealthyPipelineChoosePolicy();

    @Override
    public PipelineChoosePolicy init(NodeManager scmNodeManager) {
        this.nodeManager = scmNodeManager;
        return this;
    }

    @Override
    public Pipeline choosePipeline(List<Pipeline> pipelineList, PipelineRequestInformation pri) {
        Pipeline pipeline2;
        Pipeline pipeline1 = this.healthPolicy.choosePipeline(pipelineList, pri);
        int result = new CapacityPipelineComparator(this).compare(pipeline1, pipeline2 = this.healthPolicy.choosePipeline(pipelineList, pri));
        LOG.debug("Chosen the {} pipeline", (Object)(result <= 0 ? "first" : "second"));
        return result <= 0 ? pipeline1 : pipeline2;
    }

    @Override
    public int choosePipelineIndex(List<Pipeline> pipelineList, PipelineRequestInformation pri) {
        ArrayList<Pipeline> mutableList = new ArrayList<Pipeline>(pipelineList);
        Pipeline pipeline = this.choosePipeline(mutableList, pri);
        return pipelineList.indexOf(pipeline);
    }

    private Deque<SCMNodeMetric> getSortedNodeFromPipeline(Pipeline pipeline) {
        ArrayDeque<SCMNodeMetric> sortedNodeStack = new ArrayDeque<SCMNodeMetric>();
        pipeline.getNodes().stream().map(this.nodeManager::getNodeStat).filter(Objects::nonNull).sorted().forEach(sortedNodeStack::push);
        return sortedNodeStack;
    }

    static class CapacityPipelineComparator
    implements Comparator<Pipeline> {
        private final CapacityPipelineChoosePolicy policy;

        CapacityPipelineComparator(CapacityPipelineChoosePolicy policy) {
            this.policy = policy;
        }

        @Override
        public int compare(Pipeline p1, Pipeline p2) {
            if (p1.getId().equals((Object)p2.getId())) {
                LOG.debug("Compare the same pipeline {}", (Object)p1);
                return 0;
            }
            Deque sortedNodes1 = this.policy.getSortedNodeFromPipeline(p1);
            Deque sortedNodes2 = this.policy.getSortedNodeFromPipeline(p2);
            LOG.debug("Compare scmUsed weight in pipelines, first : {}, second : {}", (Object)sortedNodes1, (Object)sortedNodes2);
            int result = 0;
            int count = 0;
            while (result == 0 && !sortedNodes1.isEmpty() && !sortedNodes2.isEmpty()) {
                LOG.debug("Compare {} round", (Object)(++count));
                result = ((SCMNodeMetric)sortedNodes1.pop()).compareTo((SCMNodeMetric)sortedNodes2.pop());
            }
            return result;
        }
    }
}

